/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.geom.Point2D;

public class MathUtil {
    public static double computeDistanceFloat(double x1, double y1, double x2, double y2) {
        return Point2D.distance(x1, y1, x2, y2);
    }

    public static double getOrientation(Point2D P1, Point2D P2) {
        return P1 != null && P2 != null ? Double.valueOf(MathUtil.getOrientation(P1.getX(), P1.getY(), P2.getX(), P2.getY())) : null;
    }

    public static double getOrientation(double x1, double y1, double x2, double y2) {
        double teta = Math.atan2(y1 - y2, x1 - x2);
        double angle = Math.toDegrees(teta);
        angle = angle < 0.0 ? -angle : 180.0 - angle;
        return angle;
    }

    public static double getAzimuth(Point2D P1, Point2D P2) {
        return P1 != null && P2 != null ? Double.valueOf(MathUtil.getAzimuth(P1.getX(), P1.getY(), P2.getX(), P2.getY())) : null;
    }

    public static double getAzimuth(double x1, double y1, double x2, double y2) {
        double angle = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
        angle = (angle + 450.0) % 360.0;
        return angle;
    }

    public static float checkMin0(float val) {
        return val < 0.0f ? 0.0f : val;
    }

    public static float checkMax(float val, float max) {
        return val > max ? max : val;
    }

    public static float checkMinMax(float val, float min, float max) {
        if (val < min) {
            val = min;
        }
        if (val > max) {
            val = max;
        }
        return val;
    }

    public static int checkMinMax(int val, int min, int max) {
        if (val < min) {
            val = min;
        }
        if (val > max) {
            val = max;
        }
        return val;
    }
}

