/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.operator.TransposeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.ImageToolkit;

public class FlipOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlipOperation.class);
    public static final String name = Messages.getString("FlipOperation.title");

    @Override
    public String getOperationName() {
        return name;
    }

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        Boolean flip = (Boolean)imageOperation.getActionValue(ActionW.FLIP.cmd());
        if (flip == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else if (flip.booleanValue()) {
            ParameterBlock param = new ParameterBlock();
            param.addSource(source);
            param.add(TransposeDescriptor.FLIP_HORIZONTAL);
            this.result = JAI.create((String)"transpose", (ParameterBlock)param, (RenderingHints)ImageToolkit.NOCACHE_HINT);
        } else {
            this.result = source;
        }
        return this.result;
    }
}

