/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.util.ImageToolkit;
import org.weasis.core.api.media.data.ImageElement;

public class ZoomOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZoomOperation.class);
    public static final String name = Messages.getString("ZoomOperation.title");
    public static final String[] INTERPOLATIONS = new String[]{Messages.getString("ZoomOperation.nearest"), Messages.getString("ZoomOperation.bilinear"), Messages.getString("ZoomOperation.bicubic"), Messages.getString("ZoomOperation.bicubic2")};
    public static final String INTERPOLATION_CMD = "zoomInterpolation";

    @Override
    public String getOperationName() {
        return name;
    }

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        Double zoomFactor = (Double)imageOperation.getActionValue(ActionW.ZOOM.cmd());
        ImageElement image = imageOperation.getImage();
        if (zoomFactor == null || image == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else if (zoomFactor == 1.0 && image.getRescaleX() == 1.0 && image.getRescaleY() == 1.0) {
            this.result = source;
        } else {
            float val = (float)Math.abs(zoomFactor);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(source);
            pb.add(val * (float)image.getRescaleX());
            pb.add(val * (float)image.getRescaleY());
            pb.add(0.0f);
            pb.add(0.0f);
            pb.add(ZoomOperation.getInterpolation(imageOperation));
            this.result = JAI.create((String)"scale", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
        }
        return this.result;
    }

    public static Interpolation getInterpolation(ImageOperation imageOperation) {
        Integer interpolation = (Integer)imageOperation.getActionValue(INTERPOLATION_CMD);
        if (interpolation == null || interpolation < 0 || interpolation > 3) {
            interpolation = 1;
        }
        return Interpolation.getInstance((int)interpolation);
    }
}

