/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import java.io.Serializable;
import javax.media.jai.KernelJAI;
import org.weasis.core.api.Messages;

public class KernelData
implements Serializable {
    private static final long serialVersionUID = 5877650534432337573L;
    public static final KernelData NONE = new KernelData(Messages.getString("KernelData.0"), false, 1, 1, new float[]{1.0f});
    public static final KernelData MEAN = new KernelData(Messages.getString("KernelData.1"), false, 3, 3, 1, 1, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f}, 9);
    public static final KernelData BLUR = new KernelData(Messages.getString("KernelData.2"), false, 3, 3, 1, 1, new float[]{0.0f, 1.0f, 0.0f, 1.0f, 4.0f, 1.0f, 0.0f, 1.0f, 0.0f}, 8);
    public static final KernelData BLURMORE = new KernelData(Messages.getString("KernelData.3"), false, 3, 3, 1, 1, new float[]{1.0f, 2.0f, 1.0f, 2.0f, 2.0f, 2.0f, 1.0f, 2.0f, 1.0f}, 14);
    public static final KernelData SHARPEN = new KernelData(Messages.getString("KernelData.4"), false, 3, 3, 1, 1, new float[]{0.0f, -1.0f, 0.0f, -1.0f, 8.0f, -1.0f, 0.0f, -1.0f, 0.0f}, 4);
    public static final KernelData SHARPENMORE = new KernelData(Messages.getString("KernelData.5"), false, 3, 3, 1, 1, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 12.0f, -1.0f, -1.0f, -1.0f, -1.0f}, 4);
    public static final KernelData DEFOCUS = new KernelData(Messages.getString("KernelData.6"), false, 3, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, -7.0f, 1.0f, 1.0f, 1.0f, 1.0f});
    public static final KernelData EDGE1 = new KernelData(Messages.getString("KernelData.7"), false, 3, 3, new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f});
    public static final KernelData EDGE2 = new KernelData(Messages.getString("KernelData.8"), false, 3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 8.0f, -1.0f, -1.0f, -1.0f, -1.0f});
    public static final KernelData STRONGEDGE = new KernelData(Messages.getString("KernelData.9"), false, 5, 5, new float[]{-2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -3.0f, -3.0f, -3.0f, -2.0f, -2.0f, -3.0f, 53.0f, -3.0f, -2.0f, -2.0f, -3.0f, -3.0f, -3.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f, -2.0f});
    public static final KernelData OUTLINE = new KernelData(Messages.getString("KernelData.10"), false, 5, 5, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, -16.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f});
    public static final KernelData EMBOSS = new KernelData(Messages.getString("KernelData.11"), false, 3, 3, new float[]{-5.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 5.0f});
    public static final KernelData GAUSSIAN3 = KernelData.gaussianKernel(Messages.getString("KernelData.12"), 3, 3);
    public static final KernelData GAUSSIAN5 = KernelData.gaussianKernel(Messages.getString("KernelData.13"), 5, 5);
    public static final KernelData GAUSSIAN7 = KernelData.gaussianKernel(Messages.getString("KernelData.14"), 7, 7);
    public static final KernelData GAUSSIAN9 = KernelData.gaussianKernel(Messages.getString("KernelData.15"), 9, 9);
    public static final KernelData GAUSSIAN23 = KernelData.gaussianKernel2(Messages.getString("KernelData.16"), 3);
    public static final KernelData GAUSSIAN25 = KernelData.gaussianKernel2(Messages.getString("KernelData.17"), 5);
    public static final KernelData GAUSSIAN27 = KernelData.gaussianKernel2(Messages.getString("KernelData.18"), 7);
    public static KernelData[] ALL_FILTERS = new KernelData[]{NONE, MEAN, BLUR, BLURMORE, SHARPEN, SHARPENMORE, DEFOCUS, EDGE1, EDGE2, STRONGEDGE, OUTLINE, EMBOSS, GAUSSIAN3, GAUSSIAN5, GAUSSIAN7, GAUSSIAN9, GAUSSIAN23, GAUSSIAN25, GAUSSIAN27};
    private boolean morphologicalFilter;
    private String name;
    private int width;
    private int height;
    private int xOrigin;
    private int yOrigin;
    private int divisor;
    private float[] data = null;

    public KernelData(String name, boolean morphologicalFilter, int width, int height, int xOrigin, int yOrigin, float[] data, int divisor) {
        this.name = name;
        this.morphologicalFilter = morphologicalFilter;
        this.width = width;
        this.height = height;
        this.setXOrigin(xOrigin);
        this.setYOrigin(yOrigin);
        this.divisor = divisor;
        this.data = this.divideKernel(data);
    }

    public KernelData(String name, boolean morphologicalFilter, int width, int height, float[] data) {
        this(name, morphologicalFilter, width, height, width / 2, height / 2, data, 1);
    }

    public float[] getData() {
        return this.data;
    }

    private float[] divideKernel(float[] data) {
        if (data == null) {
            return new float[this.width * this.height];
        }
        if (this.divisor == 0) {
            this.divisor = 1;
        }
        if (this.divisor == 1) {
            return data;
        }
        float div = this.divisor;
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / div;
        }
        return data;
    }

    public int getDivisor() {
        return this.divisor;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getXOrigin() {
        return this.xOrigin;
    }

    public int getYOrigin() {
        return this.yOrigin;
    }

    public boolean isMorphologicalFilter() {
        return this.morphologicalFilter;
    }

    public boolean setYOrigin(int yOrigin) {
        if (yOrigin >= this.height || yOrigin < 0) {
            this.yOrigin = this.height / 2;
            return false;
        }
        this.yOrigin = yOrigin;
        return true;
    }

    public boolean setXOrigin(int xOrigin) {
        if (xOrigin >= this.width || xOrigin < 0) {
            this.xOrigin = this.width / 2;
            return false;
        }
        this.xOrigin = xOrigin;
        return true;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDivisor(int divisor) {
        this.divisor = divisor;
    }

    public KernelJAI getKernelJAI() {
        if (this.data == null) {
            return new KernelJAI(1, 1, 0, 0, new float[]{1.0f});
        }
        return new KernelJAI(this.width, this.height, this.xOrigin, this.yOrigin, this.data);
    }

    public static final KernelData makeGaussianKernel(String name, int radius) {
        int diameter = 2 * radius + 1;
        float invrsq = 1.0f / (float)(radius * radius);
        float[] gaussianData = new float[diameter * diameter];
        float sum = 0.0f;
        for (int i = 0; i < diameter; ++i) {
            float val;
            float d = i - radius;
            gaussianData[i] = val = (float)Math.exp(-d * d * invrsq);
            sum += val;
        }
        float invsum = 1.0f / sum;
        int i = 0;
        while (i < diameter) {
            int n = i++;
            gaussianData[n] = gaussianData[n] * invsum;
        }
        for (i = diameter; i < gaussianData.length; ++i) {
            gaussianData[i] = invsum;
        }
        return new KernelData(name, false, diameter, diameter, gaussianData);
    }

    public static int sign(float x) {
        int isign = 1;
        if (x < 0.0f) {
            isign = -1;
            x = -x;
        }
        return isign * (int)(x + 0.5f);
    }

    public static final KernelData gaussianKernel(String name, int nx, int ny) {
        if (nx % 2 == 0) {
            ++nx;
        }
        if (ny % 2 == 0) {
            ++ny;
        }
        float sigmax = (float)(nx - 1) / 6.0f;
        float sigmay = (float)(ny - 1) / 6.0f;
        return KernelData.gaussianKernel(name, sigmax, sigmay);
    }

    public static final KernelData gaussianKernel(String name, float sigmax, float sigmay) {
        int nx = KernelData.sign(6.0f * sigmax);
        int ny = KernelData.sign(6.0f * sigmay);
        if (nx % 2 == 0) {
            ++nx;
        }
        if (ny % 2 == 0) {
            ++ny;
        }
        float[] gauss_kernel = new float[nx * ny];
        float scale = 0.0f;
        if (sigmax == 0.0f) {
            sigmax = 1.0E-5f;
        }
        if (sigmay == 0.0f) {
            sigmay = 1.0E-5f;
        }
        for (int j = 0; j < ny; ++j) {
            float locy = j - (ny - 1) / 2;
            for (int i = 0; i < nx; ++i) {
                float locx = i - (nx - 1) / 2;
                gauss_kernel[j * nx + i] = (float)Math.exp(-0.5f * (locx * locx / (sigmax * sigmax) + locy * locy / (sigmay * sigmay)));
                scale += gauss_kernel[j * nx + i];
            }
        }
        int i = 0;
        while (i < gauss_kernel.length) {
            int n = i++;
            gauss_kernel[n] = gauss_kernel[n] / scale;
        }
        return new KernelData(name, false, nx, ny, gauss_kernel);
    }

    public static final KernelData gaussianKernel2(String name, int n) {
        int i;
        float[] gauss_kernel = new float[n * n];
        float sigma = (float)(n - 1) / 6.0f;
        float scale = 0.0f;
        for (i = 0; i < n; ++i) {
            float locy = i - (n - 1) / 2;
            for (int j = 0; j < n; ++j) {
                float locx = j - (n - 1) / 2;
                float dist = (float)Math.sqrt(locy * locy + locx * locx);
                gauss_kernel[j * n + i] = -dist / (sigma * sigma) * (float)Math.exp(-dist * dist / (2.0f * sigma * sigma));
                scale += gauss_kernel[j * n + i];
            }
        }
        i = 0;
        while (i < gauss_kernel.length) {
            int n2 = i++;
            gauss_kernel[n2] = gauss_kernel[n2] / scale;
        }
        return new KernelData(name, false, n, n, gauss_kernel);
    }
}

