/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image.util;

import java.util.ArrayList;
import org.weasis.core.api.Messages;
import org.weasis.core.api.image.util.AbbreviationUnit;

public enum Unit {
    PIXEL(-5, Messages.getString("Unit.pix"), Messages.getString("Unit.pix_s"), 1.0),
    NANOMETER(-2, Messages.getString("Unit.nano"), Messages.getString("Unit.nano_S"), 1.0E-9),
    MICROMETER(-1, Messages.getString("Unit.micro"), Messages.getString("Unit.micro_S"), 1.0E-6),
    MILLIMETER(0, Messages.getString("Unit.milli"), Messages.getString("Unit.milli_s"), 0.001),
    CENTIMETER(1, Messages.getString("Unit.cent"), Messages.getString("Unit.cent_s"), 0.01),
    METER(2, Messages.getString("Unit.meter"), Messages.getString("Unit.meter_s"), 1.0),
    KILOMETER(3, Messages.getString("Unit.kilo"), Messages.getString("Unit.kilo_s"), 1000.0),
    MICROINCH(10, Messages.getString("Unit.minch"), Messages.getString("Unit.minch_s"), 2.54E-8),
    INCH(11, Messages.getString("Unit.inch"), Messages.getString("Unit.inch_s"), 0.0254),
    FEET(12, Messages.getString("Unit.feet"), Messages.getString("Unit.feet_s"), 0.3048),
    YARD(13, Messages.getString("Unit.yard"), Messages.getString("Unit.yard_s"), 0.9144),
    MILE(14, Messages.getString("Unit.mile"), Messages.getString("Unit.mile_s"), 1609.344);

    private final int id;
    private final String fullName;
    private final String abbreviation;
    private final double convFactor;

    private Unit(int id, String fullName, String abbreviation, double convFactor) {
        this.id = id;
        this.fullName = fullName;
        this.abbreviation = abbreviation;
        this.convFactor = convFactor;
    }

    public int getId() {
        return this.id;
    }

    public String getFullName() {
        return this.fullName;
    }

    public double getConvFactor() {
        return this.convFactor;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String toString() {
        return this.fullName;
    }

    public double getConversionRatio(double calibRatio) {
        return calibRatio / this.convFactor;
    }

    public static ArrayList<AbbreviationUnit> getAbbreviationUnits() {
        ArrayList<AbbreviationUnit> units = new ArrayList<AbbreviationUnit>();
        for (Unit u : Unit.values()) {
            if (u.getId() == PIXEL.getId()) continue;
            units.add(new AbbreviationUnit(u));
        }
        return units;
    }

    public static Unit getCurrentIdUnit(int id) {
        for (Unit u : Unit.values()) {
            if (id != u.getId()) continue;
            return u;
        }
        return PIXEL;
    }

    public static final ArrayList<String> getUnitsName() {
        ArrayList<String> list = new ArrayList<String>();
        for (Unit u : Unit.values()) {
            list.add(u.getFullName());
        }
        return list;
    }

    public Unit getUpUnit() {
        for (Unit u : Unit.values()) {
            if (u.getId() - this.getId() != 1) continue;
            return u;
        }
        return null;
    }

    public Unit getDownUnit() {
        for (Unit u : Unit.values()) {
            if (this.getId() - u.getId() != 1) continue;
            return u;
        }
        return null;
    }

    public static ArrayList<Unit> getUnitExceptPixel() {
        ArrayList<Unit> list = new ArrayList<Unit>();
        for (Unit u : Unit.values()) {
            if (u.getId() == PIXEL.getId()) continue;
            list.add(u);
        }
        return list;
    }
}

