/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.InfoViewListPanel;

public class TagW
implements Transferable,
Serializable {
    public static final AtomicInteger AppID = new AtomicInteger(1);
    private static final AtomicInteger idCounter = new AtomicInteger(Integer.MAX_VALUE);
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final SimpleDateFormat formatDate = new SimpleDateFormat("dd-MM-yyyy");
    public static final SimpleDateFormat formatTime = new SimpleDateFormat("HH:mm:ss.SSSSSS");
    public static final SimpleDateFormat formatDateTime = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    public static final SimpleDateFormat dicomformatDate = new SimpleDateFormat("yyyyMMdd");
    public static final SimpleDateFormat dicomformatTime = new SimpleDateFormat("HHmmss");
    public static final TagW PatientPseudoUID = new TagW(Messages.getString("TagElement.pat_uid"), TagType.String, 1);
    public static final TagW SeriesLoading = new TagW(Messages.getString("TagElement.laod"), TagType.Integer);
    public static final TagW Thumbnail = new TagW(Messages.getString("TagElement.thumb"), TagType.Thumbnail);
    public static final TagW ExplorerModel = new TagW(Messages.getString("TagElement.exp_model"), TagType.Object);
    public static final TagW MeasurementGraphics = new TagW(Messages.getString("TagElement.measure_graph"), TagType.List);
    public static final TagW SplitSeriesNumber = new TagW(Messages.getString("TagElement.split_no"), TagType.Boolean);
    public static final TagW SeriesSelected = new TagW(Messages.getString("TagElement.select"), TagType.Boolean);
    public static final TagW SeriesOpen = new TagW(Messages.getString("TagElement.open"), TagType.Boolean);
    public static final TagW ImageWidth = new TagW(Messages.getString("TagElement.img_w"), TagType.Integer);
    public static final TagW ImageHeight = new TagW(Messages.getString("TagElement.img_h"), TagType.Integer);
    public static final TagW ImageDepth = new TagW(Messages.getString("TagElement.img_d"), TagType.Integer);
    public static final TagW ImageOrientationPlane = new TagW(Messages.getString("TagElement.img_or"), TagType.String);
    public static final TagW ImageBitsPerPixel = new TagW(Messages.getString("TagElement.img_bpp"), TagType.Integer);
    public static final TagW ImageCache = new TagW("Image Cache", TagType.Boolean);
    public static final TagW WadoCompressionRate = new TagW("Wado Compression Rate", TagType.Integer);
    public static final TagW WadoTransferSyntaxUID = new TagW("Wado Transfer Syntax UID", TagType.String);
    public static final TagW DirectDownloadFile = new TagW("Direct Download File", TagType.String);
    public static final TagW WadoParameters = new TagW("Wado Parameter", TagType.Object);
    public static final TagW WadoInstanceReferenceList = new TagW("List of DICOM instance References", TagType.List);
    public static final TagW DicomSpecialElement = new TagW("Special DICOM Object", TagType.Object);
    public static final TagW DicomSpecialElementList = new TagW("Special DICOM List", TagType.List);
    public static final TagW SlicePosition = new TagW("Slice Position", TagType.DoubleArray);
    public static final TagW SuvFactor = new TagW("SUV Factor", TagType.DoubleArray);
    public static final TagW RootElement = new TagW("Root Element", TagType.String);
    public static final TagW CurrentFolder = new TagW(Messages.getString("TagElement.cur_dir"), TagType.String);
    public static final TagW TransferSyntaxUID = new TagW(131088, "Transfer Syntax UID", TagType.String);
    public static final TagW PatientName = new TagW(0x100010, "Patient Name", TagType.String, 1);
    public static final TagW PatientID = new TagW(0x100020, "PatientID", TagType.String, 1);
    public static final TagW IssuerOfPatientID = new TagW(0x100021, "Issuer of PatientID", TagType.String, 1);
    public static final TagW PatientBirthDate = new TagW(0x100030, "Patient Birth Date", TagType.Date, 1);
    public static final TagW PatientBirthTime = new TagW(1048626, "Patient Birth Time", TagType.Time, 1);
    public static final TagW PatientSex = new TagW(0x100040, "Patient Sex", TagType.String, 1);
    public static final TagW PatientWeight = new TagW(0x101030, "Patient Weight", TagType.Float, 1);
    public static final TagW PatientComments = new TagW(0x104000, "Patient Comments", TagType.String, 1);
    public static final TagW StudyInstanceUID = new TagW(0x20000D, "Study Instance UID", TagType.String, 2);
    public static final TagW SubseriesInstanceUID = new TagW("Subseries Instance UID", TagType.String, 3);
    public static final TagW SeriesInstanceUID = new TagW(0x20000E, "Series Instance UID", TagType.String, 3);
    public static final TagW StudyID = new TagW(0x200010, "Study ID", TagType.String, 2);
    public static final TagW InstanceNumber = new TagW(2097171, "Instance Number", TagType.Integer, 4);
    public static final TagW ImagePositionPatient = new TagW(0x200032, "Image Position Patient", TagType.DoubleArray, 4);
    public static final TagW ImageOrientationPatient = new TagW(2097207, "Image Orientation", TagType.DoubleArray, 4);
    public static final TagW SliceLocation = new TagW(2101313, "Slice Location", TagType.Float, 4);
    public static final TagW SliceThickness = new TagW(1572944, "Slice Thickness", TagType.Float, 4);
    public static final TagW ImageType = new TagW(524296, "Image Type", TagType.String, 4);
    public static final TagW SOPClassUID = new TagW(524310, "SOP Class UID", TagType.String, 4);
    public static final TagW SOPInstanceUID = new TagW(524312, "SOP Instance UID", TagType.String, 4);
    public static final TagW StudyDate = new TagW(524320, "Study Date", TagType.Date, 2);
    public static final TagW SeriesDate = new TagW(524321, "Series Date", TagType.Date, 3);
    public static final TagW AcquisitionDate = new TagW(524322, "Acquisition Date", TagType.Date, 4);
    public static final TagW StudyTime = new TagW(524336, "Study Time", TagType.Time, 2);
    public static final TagW AcquisitionTime = new TagW(524338, "Acquisition Time", TagType.Time, 4);
    public static final TagW AccessionNumber = new TagW(524368, "Accession Number", TagType.String, 2);
    public static final TagW RetrieveAETitle = new TagW(524372, "Retrieve AE Title", TagType.String, 3);
    public static final TagW Modality = new TagW(524384, "Modality", TagType.String, 3);
    public static final TagW ModalitiesInStudy = new TagW(524385, "Modalities in Study", TagType.String, 2);
    public static final TagW Manufacturer = new TagW(524400, "Manufacturer", TagType.String, 3);
    public static final TagW InstitutionName = new TagW(524416, "Institution Name", TagType.String, 3);
    public static final TagW ReferringPhysicianName = new TagW(524432, "Referring Physician Name", TagType.String, 3);
    public static final TagW StationName = new TagW(528400, "Station Name", TagType.String, 3);
    public static final TagW StudyDescription = new TagW(528432, "Study Description", TagType.String, 2);
    public static final TagW ProcedureCodeSequence = new TagW(528434, "Procedure Code Sequence", TagType.Sequence, 2);
    public static final TagW SeriesDescription = new TagW(528446, "Series Description", TagType.String, 3);
    public static final TagW InstitutionalDepartmentName = new TagW(528448, "Institutional Department Name", TagType.String, 3);
    public static final TagW ManufacturerModelName = new TagW(528528, "Manufacturer Model Name", TagType.String, 3);
    public static final TagW ReferencedPerformedProcedureStepSequence = new TagW(528657, "Referenced Performed Procedure Step Sequence", TagType.Sequence, 3);
    public static final TagW ReferencedImageSequence = new TagW(528704, "Referenced Image Sequence", TagType.Sequence);
    public static final TagW FrameType = new TagW(561159, "Frame Type", TagType.String, 4);
    public static final TagW ContrastBolusAgent = new TagW(0x180010, "Contras tBolus Agent", TagType.String);
    public static final TagW ScanningSequence = new TagW(1572896, "Scanning Sequence", TagType.String);
    public static final TagW SequenceVariant = new TagW(1572897, "Sequence Variant", TagType.String);
    public static final TagW ScanOptions = new TagW(1572898, "Scan Options", TagType.String);
    public static final TagW CineRate = new TagW(1572928, "Cine Rate", TagType.Integer);
    public static final TagW KVP = new TagW(1572960, "kVP", TagType.String);
    public static final TagW RepetitionTime = new TagW(0x180080, "Repetition Time", TagType.Float);
    public static final TagW EchoTime = new TagW(0x180081, "Echo Time", TagType.Float);
    public static final TagW InversionTime = new TagW(1572994, "Inversion Time", TagType.Float);
    public static final TagW EchoNumbers = new TagW(1572998, "Echo Number", TagType.Integer);
    public static final TagW ImagerPixelSpacing = new TagW(1577316, "Imager Pixel Spacing", TagType.DoubleArray);
    public static final TagW GantryDetectorTilt = new TagW(1577248, "Gantry Detector Tilt", TagType.Float);
    public static final TagW PreferredPlaybackSequencing = new TagW(1577540, "Preferred Playback Sequencing", TagType.Integer);
    public static final TagW ConvolutionKernel = new TagW(1577488, "Convolution Kernel", TagType.String);
    public static final TagW FlipAngle = new TagW(1577748, "Scan Options", TagType.Float);
    public static final TagW FrameOfReferenceUID = new TagW(0x200052, "Frame Of Reference UID", TagType.String);
    public static final TagW PixelData = new TagW(2145386512, "Pixel Data", TagType.Text);
    public static final TagW PixelSpacing = new TagW(2621488, "Pixel Spacing", TagType.DoubleArray);
    public static final TagW PixelSpacingCalibrationDescription = new TagW(2624004, "Pixel Spacing Calibration Description", TagType.String);
    public static final TagW WindowWidth = new TagW(2625617, "Window Width", TagType.Float);
    public static final TagW WindowCenter = new TagW(2625616, "Window Center", TagType.Float);
    public static final TagW RescaleSlope = new TagW(2625619, "Rescale Slope", TagType.Float);
    public static final TagW RescaleIntercept = new TagW(2625618, "Rescale Intercept", TagType.Float);
    public static final TagW RescaleType = new TagW(2625620, "Rescale Type", TagType.String);
    public static final TagW PixelDataProviderURL = new TagW(2654176, "Pixel Data Provider URL", TagType.String);
    public static final TagW SmallestImagePixelValue = new TagW(2621702, "Smallest ImagePixel Value", TagType.Float);
    public static final TagW LargestImagePixelValue = new TagW(2621703, "Largest Image PixelValue", TagType.Float);
    public static final TagW BodyPartExamined = new TagW(1572885, "Body Part Examined", TagType.String, 3);
    public static final TagW SeriesNumber = new TagW(0x200011, "Series Number", TagType.Integer, 3);
    public static final TagW Laterality = new TagW(0x200060, "Laterality", TagType.String, 3);
    public static final TagW NumberOfStudyRelatedSeries = new TagW(2101766, "Number of Study Related Series", TagType.Integer, 2);
    public static final TagW NumberOfStudyRelatedInstances = new TagW(2101768, "Number of Study Related Instances", TagType.Integer, 2);
    public static final TagW NumberOfSeriesRelatedInstances = new TagW(2101769, "Number of Series Related Instances", TagType.Integer);
    public static final TagW ImageComments = new TagW(0x204000, "Image Comments", TagType.String);
    public static final TagW StackID = new TagW(2134102, "Stack ID", TagType.String, 4);
    public static final TagW FrameAcquisitionNumber = new TagW(2134358, "Frame Acquisition Number", TagType.Integer, 4);
    public static final TagW NumberOfFrames = new TagW(0x280008, "Number of Frames", TagType.Integer);
    public static final TagW PixelPaddingValue = new TagW(2621728, "Pixel Padding Value", TagType.Integer);
    public static final TagW PixelPaddingRangeLimit = new TagW(2621729, "Pixel Padding Range Limit", TagType.Integer);
    public static final TagW SamplesPerPixel = new TagW(0x280002, "Samples Per Pixel", TagType.Integer);
    public static final TagW MonoChrome = new TagW("MonoChrome", TagType.Boolean);
    public static final TagW PhotometricInterpretation = new TagW(2621444, "Photometric Interpretation", TagType.String);
    public static final TagW OverlayRows = new TagW(0x60000010, "Overlay Rows", TagType.Integer);
    public static final TagW Rows = new TagW(2621456, "Rows", TagType.Integer);
    public static final TagW Columns = new TagW(2621457, "Columns", TagType.Integer);
    public static final TagW BitsAllocated = new TagW(2621696, "Bits Allocated", TagType.Integer);
    public static final TagW BitsStored = new TagW(2621697, "Bits Stored", TagType.Integer);
    public static final TagW PixelRepresentation = new TagW(2621699, "Pixel Representation", TagType.Integer);
    public static final TagW StudyStatusID = new TagW(3276810, "Study StatusID", TagType.String, 2);
    public static final TagW PerformedProcedureStepStartDate = new TagW(0x400244, "Performed Procedure Step Start Date", TagType.Date, 3);
    public static final TagW PerformedProcedureStepStartTime = new TagW(4194885, "Performed Procedure Step Start Time", TagType.Time, 3);
    public static final TagW RequestAttributesSequence = new TagW(4194933, "Request Attributes Sequence", TagType.Sequence, 3);
    public static final TagW Units = new TagW(5509121, "Units", TagType.String);
    public static final TagW MIMETypeOfEncapsulatedDocument = new TagW(4325394, "MIME Type Of Encapsulated Document", TagType.String);
    private static final long serialVersionUID = -7914330824854199622L;
    public static DataFlavor infoElementDataFlavor;
    private static final DataFlavor[] flavors;
    protected final int id;
    protected final int level;
    protected final String name;
    protected final TagType type;
    protected String format;
    protected int anonymizationType;

    public TagW(int id, String name, TagType type, int level) {
        this.id = id;
        this.name = name;
        this.type = type == null ? TagType.String : type;
        this.format = null;
        this.level = level;
        this.anonymizationType = 0;
    }

    public TagW(int id, String name, TagType type) {
        this(id, name, type, 0);
    }

    public TagW(String name) {
        this(idCounter.getAndDecrement(), name, null);
    }

    public TagW(String name, TagType type) {
        this(idCounter.getAndDecrement(), name, type);
    }

    public TagW(String name, TagType type, int level) {
        this(idCounter.getAndDecrement(), name, type, level);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTagName() {
        return this.name.replaceAll(" ", "");
    }

    public TagType getType() {
        return this.type;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TagW) {
            return ((TagW)obj).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public static String getFormattedText(Object value, TagType type, String format) {
        int i;
        Object[] array;
        String str;
        if (value == null) {
            return "";
        }
        if (TagType.String.equals((Object)type)) {
            str = value.toString();
        } else if (TagType.Date.equals((Object)type)) {
            str = formatDate.format((Date)value);
        } else if (TagType.Time.equals((Object)type)) {
            str = formatTime.format((Date)value);
        } else if (TagType.DateTime.equals((Object)type)) {
            str = formatDateTime.format((Date)value);
        } else if (TagType.Period.equals((Object)type)) {
            str = value.toString();
            char[] tab = str.toCharArray();
            for (int i2 = 0; i2 < tab.length && tab[i2] == '0'; ++i2) {
                str = str.substring(1);
            }
            if (tab.length > 0) {
                switch (tab[tab.length - 1]) {
                    case 'Y': {
                        str = str.replaceFirst("Y", " years");
                        break;
                    }
                    case 'M': {
                        str = str.replaceFirst("M", " months");
                        break;
                    }
                    case 'W': {
                        str = str.replaceFirst("W", " weeks");
                        break;
                    }
                    case 'D': {
                        str = str.replaceFirst("D", " days");
                    }
                }
            }
        } else if (value instanceof float[]) {
            array = (float[])value;
            StringBuffer s = new StringBuffer();
            for (i = 0; i < array.length; ++i) {
                s.append(array[i]);
                if (i >= array.length - 1) continue;
                s.append(", ");
            }
            str = s.toString();
        } else if (value instanceof double[]) {
            array = (double[])value;
            StringBuffer s = new StringBuffer();
            for (i = 0; i < array.length; ++i) {
                s.append((double)array[i]);
                if (i >= array.length - 1) continue;
                s.append(", ");
            }
            str = s.toString();
        } else if (value instanceof int[]) {
            array = (int[])value;
            StringBuffer s = new StringBuffer();
            for (i = 0; i < array.length; ++i) {
                s.append((int)array[i]);
                if (i >= array.length - 1) continue;
                s.append(", ");
            }
            str = s.toString();
        } else {
            str = value.toString();
        }
        if (format != null && !format.trim().equals("$V") && !str.equals("")) {
            int index = format.indexOf("$V");
            int fmLength = 2;
            if (index != -1) {
                boolean suffix;
                boolean bl = suffix = format.length() > index + fmLength;
                if (suffix && format.charAt(index + fmLength) == ':') {
                    String pattern;
                    if (format.charAt(index + ++fmLength) == 'f' && TagType.Float.equals((Object)type) || TagType.Double.equals((Object)type)) {
                        String pattern2;
                        if ((pattern2 = TagW.getPattern(index + ++fmLength, format)) != null) {
                            fmLength += pattern2.length() + 2;
                            try {
                                str = new DecimalFormat(pattern2).format(Double.parseDouble(str));
                            }
                            catch (NumberFormatException e) {}
                        }
                    } else if (format.charAt(index + fmLength) == 'l' && (pattern = TagW.getPattern(index + ++fmLength, format)) != null) {
                        fmLength += pattern.length() + 2;
                        try {
                            int limit = Integer.parseInt(pattern);
                            int size = str.length();
                            if (size > limit) {
                                str = str.substring(0, limit) + "...";
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                str = format.substring(0, index) + str;
                if (format.length() > index + fmLength) {
                    str = str + format.substring(index + fmLength);
                }
            }
        }
        return str;
    }

    private static String getPattern(int startIndex, String format) {
        int beginIndex = format.indexOf(36, startIndex);
        int endIndex = format.indexOf(36, startIndex + 2);
        if (beginIndex == -1 || endIndex == -1) {
            return null;
        }
        return format.substring(beginIndex + 1, endIndex);
    }

    public String getFormattedText(Object value) {
        return TagW.getFormattedText(value, this.type, this.format);
    }

    public synchronized void setFormat(String format) {
        this.format = format;
    }

    public synchronized String getFormat() {
        return this.format;
    }

    public synchronized int getAnonymizationType() {
        return this.anonymizationType;
    }

    public synchronized void setAnonymizationType(int anonymizationType) {
        this.anonymizationType = anonymizationType;
    }

    public static Date getDateTime(String dateTime) {
        if (dateTime != null) {
            try {
                return formatDateTime.parse(dateTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getDate(String date) {
        if (date != null) {
            try {
                return formatDate.parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getDicomDate(String date) {
        if (date != null) {
            try {
                return dicomformatDate.parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date getDicomTime(String dateTime) {
        if (dateTime != null) {
            try {
                return dicomformatTime.parse(dateTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Date dateTime(Date date, Date time) {
        if (time == null) {
            return date;
        }
        if (date == null) {
            return time;
        }
        Calendar calendarA = Calendar.getInstance();
        calendarA.setTime(date);
        Calendar calendarB = Calendar.getInstance();
        calendarB.setTime(time);
        calendarA.set(11, calendarB.get(11));
        calendarA.set(12, calendarB.get(12));
        calendarA.set(13, calendarB.get(13));
        calendarA.set(14, calendarB.get(14));
        return calendarA.getTime();
    }

    public static Date getOnlyDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendarA = Calendar.getInstance();
        calendarA.setTime(date);
        calendarA.set(11, 0);
        calendarA.set(12, 0);
        calendarA.set(13, 0);
        calendarA.set(14, 0);
        return calendarA.getTime();
    }

    public static String formatDate(Date date) {
        if (date != null) {
            return formatDate.format(date);
        }
        return "";
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public static synchronized void enableAnonymizationProfile(boolean activate) {
        TagW[] list = new TagW[]{PatientName, PatientID, PatientSex, PatientBirthDate, PatientBirthTime, PatientComments, PatientPseudoUID, PatientWeight, AccessionNumber, StudyID, InstitutionalDepartmentName, InstitutionName, ReferringPhysicianName, StudyDescription, SeriesDescription, RequestAttributesSequence, StationName, ImageComments};
        int type = activate ? 1 : 0;
        for (TagW t : list) {
            t.setAnonymizationType(type);
        }
    }

    static {
        try {
            infoElementDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + InfoViewListPanel.class.getName(), null, InfoViewListPanel.class.getClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        flavors = new DataFlavor[]{infoElementDataFlavor};
        TagW.enableAnonymizationProfile(true);
    }

    public static enum TagType {
        String,
        Text,
        URI,
        Sequence,
        Date,
        DateTime,
        Time,
        Period,
        Boolean,
        Integer,
        IntegerArray,
        Float,
        FloatArray,
        Double,
        DoubleArray,
        Color,
        Thumbnail,
        Object,
        List;

    }

    public static enum DICOM_LEVEL {
        Patient,
        Study,
        Series,
        Instance;

    }
}

