/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.util.Iterator;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.display.PresetWindowLevel;
import org.weasis.dicom.codec.geometry.ImageOrientation;
import org.weasis.dicom.viewer2d.View2d;

public class MprView
extends View2d {
    private final GridBagLayoutModel mprModel;
    private double[] stackOrientation;

    public MprView(ImageViewerEventManager<DicomImageElement> eventManager, GridBagLayoutModel layoutModel) {
        super(eventManager);
        this.mprModel = layoutModel;
    }

    public int getViewIndex() {
        Iterator enumVal = this.mprModel.getConstraints().values().iterator();
        int index = 0;
        while (enumVal.hasNext()) {
            if (enumVal.next() == this) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void setSeries(MediaSeries<DicomImageElement> series, int defaultIndex) {
        int index = this.getViewIndex();
        if (index == 0) {
            super.setSeries(series, defaultIndex);
        } else {
            MediaSeries oldsequence = this.series;
            if (oldsequence != null) {
                this.closingSeries(oldsequence);
            }
            if (series == null) {
                this.imageLayer.setImage(null);
                this.getLayerModel().deleteAllGraphics();
                this.closeLens();
            } else {
                Object val;
                this.series = new DicomSeries((String)series.getTagValue(series.getTagID()));
                DicomImageElement dcm = (DicomImageElement)series.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
                if (dcm != null) {
                    val = (double[])dcm.getTagValue(TagW.ImageOrientationPatient);
                    this.stackOrientation = ImageOrientation.computeNormalVectorOfPlan((double[])val);
                    if (index == 1) {
                        // empty if block
                    }
                }
                defaultIndex = defaultIndex < 0 || defaultIndex >= series.size() ? 0 : defaultIndex;
                this.frameIndex = defaultIndex + this.tileOffset;
                this.actionsInView.put(ActionW.PRESET.cmd(), PresetWindowLevel.DEFAULT);
                this.setImage((DicomImageElement)series.getMedia(this.frameIndex), true);
                val = (Double)this.actionsInView.get(ActionW.ZOOM.cmd());
                this.zoom(val == null ? 1.0 : (Double)val);
                this.center();
            }
            this.eventManager.updateComponentsListener((DefaultView2d)this);
            if (series != null && oldsequence != series) {
                series.setOpen(true);
            }
        }
    }

    protected void setImage(DicomImageElement img, boolean bestFit) {
        int index = this.getViewIndex();
        if (index == 0) {
            super.setImage((ImageElement)img, bestFit);
        } else {
            DicomImageElement oldImage = (DicomImageElement)this.imageLayer.getSourceImage();
            if (img == null || !img.equals(oldImage)) {
                // empty if block
            }
        }
    }

    public void anonymizeVolumeNotAxial() {
        int size = this.series.size();
        DicomImageElement midSeries = (DicomImageElement)this.series.getMedia(MediaSeries.MEDIA_POSITION.MIDDLE);
        boolean readVert = false;
        double[] v = (double[])midSeries.getTagValue(TagW.ImageOrientationPatient);
        String rowAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine((double)v[0], (double)v[1], (double)v[2]);
        String colAxis = ImageOrientation.getMajorAxisFromPatientRelativeDirectionCosine((double)v[3], (double)v[4], (double)v[5]);
        TransposeType rotate = null;
        if (rowAxis.equals("L") && colAxis.equals("F") || rowAxis.equals("R") && colAxis.equals("H")) {
            rotate = TransposeDescriptor.ROTATE_180;
        } else if ((rowAxis.equals("H") || rowAxis.equals("F")) && (colAxis.equals("R") || colAxis.equals("L"))) {
            readVert = true;
            if (rowAxis.equals("H") && colAxis.equals("L") || rowAxis.equals("F") && colAxis.equals("R")) {
                rotate = TransposeDescriptor.ROTATE_180;
            }
        } else if (rowAxis.equals("A") && (colAxis.equals("F") || colAxis.equals("H"))) {
            rotate = TransposeDescriptor.ROTATE_270;
        } else if (rowAxis.equals("P") && (colAxis.equals("F") || colAxis.equals("H"))) {
            rotate = TransposeDescriptor.ROTATE_90;
        } else if (colAxis.equals("P") && (rowAxis.equals("H") || rowAxis.equals("F"))) {
            readVert = true;
            rotate = TransposeDescriptor.ROTATE_90;
        } else if (colAxis.equals("A") && (rowAxis.equals("H") || rowAxis.equals("F"))) {
            readVert = true;
            rotate = TransposeDescriptor.ROTATE_270;
        }
    }
}

