/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d.dockable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.gui.util.JSliderW;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.SliderCineListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.util.FontTools;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.editor.image.MouseActions;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.ResetTools;

public class ImageTool
extends PluginTool {
    public static final String BUTTON_NAME = Messages.getString("ImageTool.img_tool");
    public static final Font TITLE_FONT = FontTools.getFont12Bold();
    public static final Color TITLE_COLOR = Color.GRAY;
    private final Border spaceY = BorderFactory.createEmptyBorder(10, 3, 0, 3);

    public ImageTool(String pluginName) {
        super(BUTTON_NAME, pluginName, ToolWindowAnchor.RIGHT);
        this.setIcon(new ImageIcon(ImageTool.class.getResource("/icon/16x16/image.png")));
        this.setDockableWidth(290);
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.getWindowLevelPanel());
        this.add(this.getTransformPanel());
        this.add(this.getSlicePanel());
        this.add(this.getResetPanel());
        JPanel panel_1 = new JPanel();
        panel_1.setAlignmentY(0.0f);
        panel_1.setAlignmentX(0.0f);
        panel_1.setLayout(new GridBagLayout());
        this.add(panel_1);
    }

    public Component getToolComponent() {
        return new JScrollPane((Component)((Object)this));
    }

    public JPanel getResetPanel() {
        JPanel panel_2 = new JPanel();
        panel_2.setAlignmentY(0.0f);
        panel_2.setAlignmentX(0.0f);
        panel_2.setLayout(new FlowLayout(0, 3, 3));
        panel_2.setBorder(BorderFactory.createCompoundBorder(this.spaceY, new TitledBorder(null, Messages.getString("ResetTools.reset"), 0, 0, TITLE_FONT, TITLE_COLOR)));
        final JComboBox<ResetTools> resetComboBox = new JComboBox<ResetTools>(ResetTools.values());
        panel_2.add(resetComboBox);
        JButton resetButton = new JButton();
        resetButton.setText(Messages.getString("ResetTools.reset"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventManager.getInstance().reset((ResetTools)((Object)resetComboBox.getSelectedItem()));
            }
        });
        panel_2.add(resetButton);
        return panel_2;
    }

    public JPanel getSlicePanel() {
        JPanel framePanel = new JPanel();
        framePanel.setAlignmentX(0.0f);
        framePanel.setAlignmentY(0.0f);
        framePanel.setLayout(new BoxLayout(framePanel, 1));
        framePanel.setBorder(BorderFactory.createCompoundBorder(this.spaceY, new TitledBorder(null, Messages.getString("ImageTool.frame"), 0, 0, TITLE_FONT, TITLE_COLOR)));
        ActionState sequence = EventManager.getInstance().getAction(ActionW.SCROLL_SERIES);
        if (sequence instanceof SliderCineListener) {
            SliderCineListener cineAction = (SliderCineListener)sequence;
            JSliderW frameSlider = cineAction.createSlider(4, false);
            framePanel.add(frameSlider.getParent());
            JPanel panel_3 = new JPanel();
            panel_3.setLayout(new FlowLayout(0, 3, 3));
            JLabel speedLabel = new JLabel();
            speedLabel.setText(Messages.getString("ImageTool.cine_speed"));
            panel_3.add(speedLabel);
            JSpinner speedSpinner = new JSpinner(cineAction.getSpeedModel());
            JMVUtils.formatCheckAction((JSpinner)speedSpinner);
            panel_3.add(speedSpinner);
            JButton startButton = new JButton();
            startButton.setActionCommand(ActionW.CINESTART.cmd());
            startButton.setPreferredSize(JMVUtils.getBigIconButtonSize());
            startButton.setToolTipText(Messages.getString("ImageTool.cine_start"));
            startButton.setIcon(new ImageIcon(MouseActions.class.getResource("/icon/22x22/media-playback-start.png")));
            startButton.addActionListener(EventManager.getInstance());
            panel_3.add(startButton);
            JButton stopButton = new JButton();
            stopButton.setActionCommand(ActionW.CINESTOP.cmd());
            stopButton.setPreferredSize(JMVUtils.getBigIconButtonSize());
            stopButton.setToolTipText(Messages.getString("ImageTool.cine_stop"));
            stopButton.setIcon(new ImageIcon(MouseActions.class.getResource("/icon/22x22/media-playback-stop.png")));
            stopButton.addActionListener(EventManager.getInstance());
            panel_3.add(stopButton);
            framePanel.add(panel_3);
        }
        return framePanel;
    }

    public JPanel getWindowLevelPanel() {
        ActionState filterAction;
        ActionState lutAction;
        ActionState presetAction;
        ActionState levelAction;
        JPanel winLevelPanel = new JPanel();
        winLevelPanel.setAlignmentY(0.0f);
        winLevelPanel.setAlignmentX(0.0f);
        winLevelPanel.setLayout(new BoxLayout(winLevelPanel, 1));
        winLevelPanel.setBorder(BorderFactory.createCompoundBorder(this.spaceY, new TitledBorder(null, Messages.getString("ImageTool.wl"), 0, 0, TITLE_FONT, TITLE_COLOR)));
        ActionState winAction = EventManager.getInstance().getAction(ActionW.WINDOW);
        if (winAction instanceof SliderChangeListener) {
            JSliderW windowSlider = ((SliderChangeListener)winAction).createSlider(4, false);
            JMVUtils.setPreferredWidth((JComponent)windowSlider, (int)100);
            winLevelPanel.add(windowSlider.getParent());
        }
        if ((levelAction = EventManager.getInstance().getAction(ActionW.LEVEL)) instanceof SliderChangeListener) {
            JSliderW levelSlider = ((SliderChangeListener)levelAction).createSlider(4, false);
            levelSlider.setMajorTickSpacing(1024);
            JMVUtils.setPreferredWidth((JComponent)levelSlider, (int)100);
            winLevelPanel.add(levelSlider.getParent());
        }
        if ((presetAction = EventManager.getInstance().getAction(ActionW.PRESET)) instanceof ComboItemListener) {
            JPanel panel_3 = new JPanel();
            panel_3.setLayout(new FlowLayout(0, 2, 3));
            JLabel presetsLabel = new JLabel();
            panel_3.add(presetsLabel);
            presetsLabel.setText(Messages.getString("ImageTool.presets"));
            JComboBox presetComboBox = ((ComboItemListener)presetAction).createCombo();
            presetComboBox.setMaximumRowCount(10);
            panel_3.add(presetComboBox);
            winLevelPanel.add(panel_3);
        }
        if ((lutAction = EventManager.getInstance().getAction(ActionW.LUT)) instanceof ComboItemListener) {
            JPanel panel_4 = new JPanel(new FlowLayout(0, 2, 3));
            JLabel lutLabel = new JLabel();
            lutLabel.setText(Messages.getString("ImageTool.lut"));
            panel_4.add(lutLabel);
            JComboBox lutcomboBox = ((ComboItemListener)lutAction).createCombo();
            panel_4.add(lutcomboBox);
            ActionState invlutAction = EventManager.getInstance().getAction(ActionW.INVERSELUT);
            if (invlutAction instanceof ToggleButtonListener) {
                panel_4.add(((ToggleButtonListener)invlutAction).createCheckBox(Messages.getString("ImageTool.inverse")));
            }
            winLevelPanel.add(panel_4);
        }
        if ((filterAction = EventManager.getInstance().getAction(ActionW.FILTER)) instanceof ComboItemListener) {
            JPanel panel_4 = new JPanel(new FlowLayout(0, 2, 3));
            JLabel lutLabel = new JLabel();
            lutLabel.setText(Messages.getString("ImageTool.filter"));
            panel_4.add(lutLabel);
            JComboBox filtercomboBox = ((ComboItemListener)filterAction).createCombo();
            panel_4.add(filtercomboBox);
            winLevelPanel.add(panel_4);
        }
        return winLevelPanel;
    }

    public JPanel getTransformPanel() {
        ActionState flipAction;
        ActionState rotateAction;
        JPanel transform = new JPanel();
        transform.setAlignmentY(0.0f);
        transform.setAlignmentX(0.0f);
        transform.setLayout(new BoxLayout(transform, 1));
        transform.setBorder(BorderFactory.createCompoundBorder(this.spaceY, new TitledBorder(null, Messages.getString("ImageTool.transform"), 0, 0, TITLE_FONT, TITLE_COLOR)));
        ActionState zoomAction = EventManager.getInstance().getAction(ActionW.ZOOM);
        if (zoomAction instanceof SliderChangeListener) {
            JSliderW zoomSlider = ((SliderChangeListener)zoomAction).createSlider(0, false);
            JMVUtils.setPreferredWidth((JComponent)zoomSlider, (int)100);
            transform.add(zoomSlider.getParent());
        }
        if ((rotateAction = EventManager.getInstance().getAction(ActionW.ROTATION)) instanceof SliderChangeListener) {
            JSliderW rotationSlider = ((SliderChangeListener)rotateAction).createSlider(4, false);
            JMVUtils.setPreferredWidth((JComponent)rotationSlider, (int)100);
            transform.add(rotationSlider.getParent());
        }
        if ((flipAction = EventManager.getInstance().getAction(ActionW.FLIP)) instanceof ToggleButtonListener) {
            JPanel pane = new JPanel(new FlowLayout(0, 0, 3));
            pane.add(((ToggleButtonListener)flipAction).createCheckBox(Messages.getString("ImageTool.flip")));
            transform.add(pane);
        }
        return transform;
    }

    protected void changeToolWindowAnchor(ToolWindowAnchor anchor) {
    }
}

