/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ComplexArithmeticOpImage
extends PointOpImage {
    protected boolean isDivision = false;
    private int[] s1r;
    private int[] s1i;
    private int[] s2r;
    private int[] s2i;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        SampleModel sampleModel;
        int n;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        if (imageLayout2.isValid(256) && (n = (sampleModel = imageLayout2.getSampleModel(null)).getNumBands()) % 2 != 0) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), ++n);
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ComplexArithmeticOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, boolean bl) {
        super(renderedImage, renderedImage2, ComplexArithmeticOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.isDivision = bl;
        int n = renderedImage.getSampleModel().getNumBands();
        int n2 = renderedImage2.getSampleModel().getNumBands();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        if (imageLayout != null) {
            n4 = imageLayout.getSampleModel(null).getNumBands();
        }
        if (imageLayout != null && imageLayout.isValid(256) && (n == 2 && n2 > 2 || n2 == 2 && n > 2 || n >= n4 && n2 >= n4 && n4 > 0) && n4 % 2 == 0) {
            n3 = n4;
            n3 = Math.min(Math.max(n, n2), n3);
        }
        if (n3 != this.sampleModel.getNumBands()) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n3);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        int n5 = this.sampleModel.getNumBands() / 2;
        this.s1r = new int[n5];
        this.s1i = new int[n5];
        this.s2r = new int[n5];
        this.s2i = new int[n5];
        int n6 = n > 2 ? 2 : 0;
        int n7 = n2 > 2 ? 2 : 0;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n5; ++i) {
            this.s1r[i] = n8;
            this.s1i[i] = n8 + 1;
            this.s2r[i] = n9;
            this.s2i[i] = n9 + 1;
            n8 += n6;
            n9 += n7;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ComplexArithmeticOpImage0"));
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            double[] dArray = rasterAccessor.getDoubleDataArray(this.s1r[i]);
            double[] dArray2 = rasterAccessor.getDoubleDataArray(this.s1i[i]);
            double[] dArray3 = rasterAccessor2.getDoubleDataArray(this.s2r[i]);
            double[] dArray4 = rasterAccessor2.getDoubleDataArray(this.s2i[i]);
            double[] dArray5 = rasterAccessor3.getDoubleDataArray(n10);
            double[] dArray6 = rasterAccessor3.getDoubleDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                double d;
                double d2;
                double d3;
                double d4;
                int n24;
                int n25 = n18;
                int n26 = n19;
                int n27 = n20;
                int n28 = n21;
                int n29 = n22;
                int n30 = n23;
                if (this.isDivision) {
                    for (n24 = 0; n24 < n2; ++n24) {
                        d4 = dArray[n25];
                        d3 = dArray2[n26];
                        d2 = dArray3[n27];
                        d = dArray4[n28];
                        double d5 = d2 * d2 + d * d;
                        dArray5[n29] = (d4 * d2 + d3 * d) / d5;
                        dArray6[n30] = (d3 * d2 - d4 * d) / d5;
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                } else {
                    for (n24 = 0; n24 < n2; ++n24) {
                        d4 = dArray[n25];
                        d3 = dArray2[n26];
                        d2 = dArray3[n27];
                        d = dArray4[n28];
                        dArray5[n29] = d4 * d2 - d3 * d;
                        dArray6[n30] = d4 * d + d3 * d2;
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            float[] fArray = rasterAccessor.getFloatDataArray(this.s1r[i]);
            float[] fArray2 = rasterAccessor.getFloatDataArray(this.s1i[i]);
            float[] fArray3 = rasterAccessor2.getFloatDataArray(this.s2r[i]);
            float[] fArray4 = rasterAccessor2.getFloatDataArray(this.s2i[i]);
            float[] fArray5 = rasterAccessor3.getFloatDataArray(n10);
            float[] fArray6 = rasterAccessor3.getFloatDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                float f;
                float f2;
                float f3;
                float f4;
                int n24;
                int n25 = n18;
                int n26 = n19;
                int n27 = n20;
                int n28 = n21;
                int n29 = n22;
                int n30 = n23;
                if (this.isDivision) {
                    for (n24 = 0; n24 < n2; ++n24) {
                        f4 = fArray[n25];
                        f3 = fArray2[n26];
                        f2 = fArray3[n27];
                        f = fArray4[n28];
                        float f5 = f2 * f2 + f * f;
                        fArray5[n29] = (f4 * f2 + f3 * f) / f5;
                        fArray6[n30] = (f3 * f2 - f4 * f) / f5;
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                } else {
                    for (n24 = 0; n24 < n2; ++n24) {
                        f4 = fArray[n25];
                        f3 = fArray2[n26];
                        f2 = fArray3[n27];
                        f = fArray4[n28];
                        fArray5[n29] = f4 * f2 - f3 * f;
                        fArray6[n30] = f4 * f + f3 * f2;
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            int[] nArray = rasterAccessor.getIntDataArray(this.s1r[i]);
            int[] nArray2 = rasterAccessor.getIntDataArray(this.s1i[i]);
            int[] nArray3 = rasterAccessor2.getIntDataArray(this.s2r[i]);
            int[] nArray4 = rasterAccessor2.getIntDataArray(this.s2i[i]);
            int[] nArray5 = rasterAccessor3.getIntDataArray(n10);
            int[] nArray6 = rasterAccessor3.getIntDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                int n24;
                int n25 = n18;
                int n26 = n19;
                int n27 = n20;
                int n28 = n21;
                int n29 = n22;
                int n30 = n23;
                if (this.isDivision) {
                    for (n24 = 0; n24 < n2; ++n24) {
                        int n31 = nArray[n25];
                        int n32 = nArray2[n26];
                        int n33 = nArray3[n27];
                        int n34 = nArray4[n28];
                        float f = n33 * n33 + n34 * n34;
                        nArray5[n29] = ImageUtil.clampRoundInt((float)(n31 * n33 + n32 * n34) / f);
                        nArray6[n30] = ImageUtil.clampRoundInt((float)(n32 * n33 - n31 * n34) / f);
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                } else {
                    for (n24 = 0; n24 < n2; ++n24) {
                        long l = nArray[n25];
                        long l2 = nArray2[n26];
                        long l3 = nArray3[n27];
                        long l4 = nArray4[n28];
                        nArray5[n29] = ImageUtil.clampInt(l * l3 - l2 * l4);
                        nArray6[n30] = ImageUtil.clampInt(l * l4 + l2 * l3);
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[i]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[i]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[i]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[i]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n10);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                int n29 = n18;
                int n30 = n19;
                int n31 = n20;
                int n32 = n21;
                int n33 = n22;
                int n34 = n23;
                if (this.isDivision) {
                    for (n28 = 0; n28 < n2; ++n28) {
                        n27 = sArray[n29] & 0xFFFF;
                        n26 = sArray2[n30] & 0xFFFF;
                        n25 = sArray3[n31] & 0xFFFF;
                        n24 = sArray4[n32] & 0xFFFF;
                        int n35 = n25 * n25 + n24 * n24;
                        sArray5[n33] = ImageUtil.clampUShort((n27 * n25 + n26 * n24) / n35);
                        sArray6[n34] = ImageUtil.clampUShort((n26 * n25 - n27 * n24) / n35);
                        n29 += n3;
                        n30 += n3;
                        n31 += n5;
                        n32 += n5;
                        n33 += n7;
                        n34 += n7;
                    }
                } else {
                    for (n28 = 0; n28 < n2; ++n28) {
                        n27 = sArray[n29] & 0xFFFF;
                        n26 = sArray2[n30] & 0xFFFF;
                        n25 = sArray3[n31] & 0xFFFF;
                        n24 = sArray4[n32] & 0xFFFF;
                        sArray5[n33] = ImageUtil.clampUShort(n27 * n25 - n26 * n24);
                        sArray6[n34] = ImageUtil.clampUShort(n27 * n24 + n26 * n25);
                        n29 += n3;
                        n30 += n3;
                        n31 += n5;
                        n32 += n5;
                        n33 += n7;
                        n34 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[i]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[i]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[i]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[i]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n10);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                short s;
                short s2;
                short s3;
                short s4;
                int n24;
                int n25 = n18;
                int n26 = n19;
                int n27 = n20;
                int n28 = n21;
                int n29 = n22;
                int n30 = n23;
                if (this.isDivision) {
                    for (n24 = 0; n24 < n2; ++n24) {
                        s4 = sArray[n25];
                        s3 = sArray2[n26];
                        s2 = sArray3[n27];
                        s = sArray4[n28];
                        int n31 = s2 * s2 + s * s;
                        sArray5[n29] = ImageUtil.clampShort((s4 * s2 + s3 * s) / n31);
                        sArray6[n30] = ImageUtil.clampShort((s3 * s2 - s4 * s) / n31);
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                } else {
                    for (n24 = 0; n24 < n2; ++n24) {
                        s4 = sArray[n25];
                        s3 = sArray2[n26];
                        s2 = sArray3[n27];
                        s = sArray4[n28];
                        sArray5[n29] = ImageUtil.clampShort(s4 * s2 - s3 * s);
                        sArray6[n30] = ImageUtil.clampShort(s4 * s + s3 * s2);
                        n25 += n3;
                        n26 += n3;
                        n27 += n5;
                        n28 += n5;
                        n29 += n7;
                        n30 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        for (int i = 0; i < n9; ++i) {
            int n10 = 2 * i;
            int n11 = n10 + 1;
            byte[] byArray = rasterAccessor.getByteDataArray(this.s1r[i]);
            byte[] byArray2 = rasterAccessor.getByteDataArray(this.s1i[i]);
            byte[] byArray3 = rasterAccessor2.getByteDataArray(this.s2r[i]);
            byte[] byArray4 = rasterAccessor2.getByteDataArray(this.s2i[i]);
            byte[] byArray5 = rasterAccessor3.getByteDataArray(n10);
            byte[] byArray6 = rasterAccessor3.getByteDataArray(n11);
            int n12 = rasterAccessor.getBandOffset(this.s1r[i]);
            int n13 = rasterAccessor.getBandOffset(this.s1i[i]);
            int n14 = rasterAccessor2.getBandOffset(this.s2r[i]);
            int n15 = rasterAccessor2.getBandOffset(this.s2i[i]);
            int n16 = rasterAccessor3.getBandOffset(n10);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = n12;
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            for (int j = 0; j < n; ++j) {
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                int n29 = n18;
                int n30 = n19;
                int n31 = n20;
                int n32 = n21;
                int n33 = n22;
                int n34 = n23;
                if (this.isDivision) {
                    for (n28 = 0; n28 < n2; ++n28) {
                        n27 = byArray[n29] & 0xFF;
                        n26 = byArray2[n30] & 0xFF;
                        n25 = byArray3[n31] & 0xFF;
                        n24 = byArray4[n32] & 0xFF;
                        int n35 = n25 * n25 + n24 * n24;
                        byArray5[n33] = ImageUtil.clampByte((n27 * n25 + n26 * n24) / n35);
                        byArray6[n34] = ImageUtil.clampByte((n26 * n25 - n27 * n24) / n35);
                        n29 += n3;
                        n30 += n3;
                        n31 += n5;
                        n32 += n5;
                        n33 += n7;
                        n34 += n7;
                    }
                } else {
                    for (n28 = 0; n28 < n2; ++n28) {
                        n27 = byArray[n29] & 0xFF;
                        n26 = byArray2[n30] & 0xFF;
                        n25 = byArray3[n31] & 0xFF;
                        n24 = byArray4[n32] & 0xFF;
                        byArray5[n33] = ImageUtil.clampByte(n27 * n25 - n26 * n24);
                        byArray6[n34] = ImageUtil.clampByte(n27 * n24 + n26 * n25);
                        n29 += n3;
                        n30 += n3;
                        n31 += n5;
                        n32 += n5;
                        n33 += n7;
                        n34 += n7;
                    }
                }
                n18 += n4;
                n19 += n4;
                n20 += n6;
                n21 += n6;
                n22 += n8;
                n23 += n8;
            }
        }
    }
}

