/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.PersistenceDelegateFilter;
import org.noos.xing.mydoggy.RepresentativeAnchorDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowBar;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.ToolWindowType;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindow;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.PropertyChangeEventSource;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.FloatingContainer;
import org.noos.xing.mydoggy.plaf.ui.FloatingLiveContainer;
import org.noos.xing.mydoggy.plaf.ui.SlidingContainer;
import org.noos.xing.mydoggy.plaf.ui.ToolWindowDescriptor;
import org.noos.xing.mydoggy.plaf.ui.animation.AbstractAnimation;
import org.noos.xing.mydoggy.plaf.ui.cmp.DebugSplitPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.DockableDropPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ExtendedTableLayout;
import org.noos.xing.mydoggy.plaf.ui.cmp.MultiSplitDockableContainer;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowBarPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowPanel;
import org.noos.xing.mydoggy.plaf.ui.cmp.ToolWindowScrollBar;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.ToolsOnBarMouseListener;
import org.noos.xing.mydoggy.plaf.ui.cmp.multisplit.MultiSplitLayout;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.drag.ToolWindowBarDropTarget;
import org.noos.xing.mydoggy.plaf.ui.util.SourceFilterPropertyChangeListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class MyDoggyToolWindowBar
extends PropertyChangeEventSource
implements ToolWindowBar,
SwingConstants,
PropertyChangeListener {
    public static final int VERTICAL_LEFT = 2;
    public static final int VERTICAL_RIGHT = 3;
    public static final int HORIZONTAL = 1;
    static int dragComponentLength;
    protected MyDoggyToolWindowManager manager;
    protected ToolWindowAnchor anchor;
    protected int dividerSize;
    protected boolean aggregateMode;
    protected boolean visible = true;
    protected ToolWindowScrollBar toolWindowScrollBar;
    protected JPanel toolWindowBarContainer;
    protected TableLayout toolWindowBarContainerLayout;
    protected JSplitPane splitPane;
    protected MultiSplitDockableContainer multiSplitDockableContainer;
    protected DockableDropPanel dockableDropPanel;
    protected JPopupMenu popupMenu;
    protected int length;
    protected int availableTools;
    protected int orientation;
    protected boolean horizontal;
    protected PropertyChangeSupport propertyChangeSupport;
    protected boolean temporarilyVisible;
    boolean valueAdjusting = false;
    protected boolean toolsVisible = true;
    protected byte[] toolsWorkspace;

    public MyDoggyToolWindowBar(MyDoggyToolWindowManager manager, JSplitPane splitPane, ToolWindowAnchor anchor) {
        super(manager.getFirePublicEvent());
        this.manager = manager;
        this.splitPane = splitPane;
        if (splitPane instanceof DebugSplitPane) {
            ((DebugSplitPane)splitPane).setToolWindowBar(this);
        }
        this.anchor = anchor;
        this.availableTools = 0;
        this.dividerSize = 3;
        this.length = SwingUtil.getInt("ToolWindowBarPanelUI." + anchor.toString().toLowerCase() + ".length", 23);
        this.initComponents();
        this.initListeners();
        if (anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.TOP) {
            this.setSplitDividerLocation(0);
        }
    }

    public ToolWindowManager getToolWindowManager() {
        return this.manager;
    }

    public ToolWindowAnchor getAnchor() {
        return this.anchor;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int size) {
        if (this.dividerSize == size) {
            return;
        }
        if (size < 1) {
            throw new IllegalArgumentException("Size cannot be lesser than 1");
        }
        int old = this.dividerSize;
        this.dividerSize = size;
        this.firePropertyChangeEvent("dividerSize", old, size);
    }

    public void setAggregateMode(boolean enable) {
        if (this.aggregateMode == enable) {
            return;
        }
        boolean old = this.aggregateMode;
        this.aggregateMode = enable;
        this.firePropertyChangeEvent("aggregateMode", old, enable);
    }

    public boolean isAggregateMode() {
        return this.aggregateMode;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setLength(int length) {
        if (this.length == length) {
            return;
        }
        int old = this.length;
        this.length = length;
        this.firePropertyChangeEvent("length", old, length);
    }

    public int getLength() {
        return this.length;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenu != null && this.popupMenu.equals(popupMenu)) {
            return;
        }
        JPopupMenu old = this.popupMenu;
        this.popupMenu = popupMenu;
        this.firePropertyChangeEvent("popupMenu", old, popupMenu);
    }

    public ToolWindow[] getToolWindows() {
        return this.manager.getToolsByAnchor(this.anchor);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.firePropertyChangeEvent("visible", !visible, visible);
    }

    public boolean areToolsVisible() {
        return this.toolsVisible;
    }

    public void setToolsVisible(boolean visible) {
        if (visible) {
            if (this.toolsWorkspace != null) {
                this.manager.getPersistenceDelegate().merge(new ByteArrayInputStream(this.toolsWorkspace), PersistenceDelegate.MergePolicy.RESET);
            }
        } else {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.manager.getPersistenceDelegate().save(outputStream, new PersistenceDelegateFilter(){

                public boolean storeToolWindowManagerDescriptor() {
                    return false;
                }

                public boolean storeToolWindow(ToolWindow toolWindow) {
                    return toolWindow.getAnchor() == MyDoggyToolWindowBar.this.anchor;
                }

                public boolean storeToolWindowBar(ToolWindowBar toolWindowBar) {
                    return toolWindowBar == MyDoggyToolWindowBar.this;
                }

                public boolean storeContentManager() {
                    return false;
                }
            });
            this.toolsWorkspace = outputStream.toByteArray();
            for (ToolWindow toolWindow : this.getToolWindows()) {
                toolWindow.setVisible(false);
            }
        }
        this.toolsVisible = visible;
        this.firePropertyChangeEvent("toolsVisible", !visible, visible);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public String toString() {
        return "MyDoggyToolWindowBar{anchor=" + (Object)((Object)this.anchor) + ", availableTools=" + this.availableTools + ", orientation=" + this.orientation + '}';
    }

    public Object getLayout() {
        return this.multiSplitDockableContainer.getMultiSplitLayout();
    }

    public void setLayout(Object layout) {
        this.multiSplitDockableContainer.setMultiSplitLayout((MultiSplitLayout.Node)layout);
    }

    public Container getContainer() {
        return this.toolWindowScrollBar;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void ensureVisible(final Component component) {
        if (component == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MyDoggyToolWindowBar.this.toolWindowScrollBar.ensureVisible(component);
            }
        });
    }

    public int getAvailableTools() {
        return this.availableTools;
    }

    public boolean isTemporarilyVisible() {
        return this.temporarilyVisible;
    }

    public void setTemporarilyVisible(boolean temporarilyVisible) {
        boolean old = this.temporarilyVisible;
        this.temporarilyVisible = temporarilyVisible;
        this.manager.syncPanel(this.anchor);
        this.firePropertyChangeEvent("temporarilyVisible", old, temporarilyVisible);
    }

    public int getRepresentativeAnchorIndex(Component representativeAnchor) {
        TableLayoutConstraints constraints = this.getRepresentativeAnchorConstraints(representativeAnchor);
        if (constraints == null) {
            return -1;
        }
        if (this.horizontal) {
            return constraints.col1 / 2 - 1;
        }
        return constraints.row1 / 2 - 1;
    }

    public synchronized void deactiveTool(ToolWindow toolWindow) {
        this.valueAdjusting = true;
        toolWindow.setActive(false);
        this.valueAdjusting = false;
    }

    public synchronized void hideTool(ToolWindow toolWindow) {
        this.valueAdjusting = true;
        toolWindow.setVisible(false);
        this.valueAdjusting = false;
    }

    public int getSize() {
        return this.getAvailableTools() > 0 ? this.getLength() : 0;
    }

    public boolean isValueAdjusting() {
        return this.valueAdjusting;
    }

    public byte[] getToolsWorkspace() {
        return this.toolsWorkspace;
    }

    public void setToolWorkspace(byte[] workspace, boolean toolsVisible) {
        this.toolsWorkspace = workspace;
        this.toolsVisible = toolsVisible;
    }

    public void updateMaximizedToolSize() {
        this.setSplitDividerLocation(-1);
        SwingUtil.repaintNow(this.splitPane);
    }

    protected void initComponents() {
        this.splitPane.setName(this.anchor.toString());
        this.dockableDropPanel = new DockedDockableDropPanel();
        this.toolWindowBarContainer = new ToolWindowBarPanel(this);
        this.toolWindowBarContainer.setName("toolWindowManager.bar." + this.anchor.toString());
        this.toolWindowBarContainer.setFocusable(false);
        this.toolWindowBarContainer.setFocusCycleRoot(true);
        switch (this.anchor) {
            case LEFT: 
            case RIGHT: {
                this.horizontal = false;
                this.toolWindowBarContainerLayout = new ExtendedTableLayout(new double[][]{{2.0, this.getLength() - 4, 2.0}, {0.0}});
                this.toolWindowBarContainer.setLayout(this.toolWindowBarContainerLayout);
                this.orientation = 0;
                break;
            }
            default: {
                this.horizontal = true;
                this.toolWindowBarContainerLayout = new ExtendedTableLayout(new double[][]{{0.0}, {2.0, this.getLength() - 4, 2.0}});
                this.toolWindowBarContainer.setLayout(this.toolWindowBarContainerLayout);
                this.orientation = 1;
            }
        }
        this.multiSplitDockableContainer = new MultiSplitDockableContainer(this.manager, this.orientation);
        this.toolWindowScrollBar = new ToolWindowScrollBar(this, this.toolWindowBarContainer);
        this.toolWindowBarContainer.setDropTarget(new ToolWindowBarDropTarget(this.manager, this.anchor, this.toolWindowBarContainer));
        this.toolWindowBarContainer.addMouseListener(new ToolsOnBarMouseListener(this.manager, this));
    }

    protected void initListeners() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        AvailableListener availableListener = new AvailableListener();
        this.propertyChangeSupport.addPropertyChangeListener("available", availableListener);
        this.propertyChangeSupport.addPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(availableListener, RepresentativeAnchorDescriptor.class));
        this.propertyChangeSupport.addPropertyChangeListener("showUnavailableTools", new ShowUnavailableToolsListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.before", new VisibleBeforeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.DOCKED", new VisibleDockedListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING", new VisibleFloatingListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING_FREE", new VisibleFloatingFreeListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.SLIDING", new VisibleSlidingListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible.FLOATING_LIVE", new VisibleFloatingLiveListener());
        this.propertyChangeSupport.addPropertyChangeListener("visible", new SourceFilterPropertyChangeListener(new VisibleListener(), ToolWindow.class));
        this.propertyChangeSupport.addPropertyChangeListener("active.before", new ActiveBeforeListener());
        this.propertyChangeSupport.addPropertyChangeListener("type", new TypeListener());
        this.propertyChangeSupport.addPropertyChangeListener("index", new IndexListener());
        this.propertyChangeSupport.addPropertyChangeListener("title", new TitleListener());
        this.propertyChangeSupport.addPropertyChangeListener("icon", new IconListener());
        this.propertyChangeSupport.addPropertyChangeListener("dockLength", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToolWindow toolWindow = (ToolWindow)evt.getSource();
                if (toolWindow.isVisible()) {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation((Integer)evt.getNewValue());
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.splitPane);
                }
            }
        });
        DragSupportListener dragSupportListener = new DragSupportListener();
        this.propertyChangeSupport.addPropertyChangeListener("startDrag", dragSupportListener);
        this.propertyChangeSupport.addPropertyChangeListener("endDrag", dragSupportListener);
        this.propertyChangeSupport.addPropertyChangeListener("maximized", new MaximizedListener());
        this.addPropertyChangeListener("dividerSize", new DividerSizeListener());
        this.addPropertyChangeListener("length", new BarLengthListener());
    }

    protected int getSplitDividerLocation() {
        int dividerLocation = 0;
        switch (this.anchor) {
            case LEFT: 
            case TOP: {
                dividerLocation = this.splitPane.getDividerLocation();
                break;
            }
            case RIGHT: {
                dividerLocation = this.splitPane.getWidth() - this.splitPane.getDividerLocation();
                break;
            }
            case BOTTOM: {
                dividerLocation = this.splitPane.getHeight() - this.splitPane.getDividerLocation();
            }
        }
        return dividerLocation;
    }

    protected void setSplitDividerLocation(int dividerLocation) {
        if (dividerLocation == -1) {
            switch (this.anchor) {
                case LEFT: {
                    this.splitPane.setDividerLocation(this.splitPane.getWidth());
                    break;
                }
                case TOP: {
                    this.splitPane.setDividerLocation(this.splitPane.getHeight());
                    break;
                }
                case RIGHT: {
                    this.splitPane.setDividerLocation(0);
                    break;
                }
                case BOTTOM: {
                    this.splitPane.setDividerLocation(0);
                }
            }
        } else {
            switch (this.anchor) {
                case LEFT: 
                case TOP: {
                    this.splitPane.setDividerLocation(dividerLocation);
                    break;
                }
                case RIGHT: {
                    this.splitPane.setDividerLocation(Math.abs(this.splitPane.getWidth() - dividerLocation));
                    break;
                }
                case BOTTOM: {
                    this.splitPane.setDividerLocation(Math.abs(this.splitPane.getHeight() - dividerLocation));
                }
            }
        }
    }

    protected Component getSplitPaneContent() {
        return this.dockableDropPanel.getComponent();
    }

    protected void addRepresentativeAnchor(DockableDescriptor dockableDescriptor, Component representativeAnchor, int index) {
        representativeAnchor = new RepresentativeAnchorWrapper(dockableDescriptor, representativeAnchor);
        if (dockableDescriptor.isAvailableCountable()) {
            ++this.availableTools;
        }
        if (this.horizontal) {
            Component[] components;
            this.toolWindowBarContainerLayout.insertColumn(this.toolWindowBarContainerLayout.getNumColumn(), this.toolWindowBarContainerLayout.getNumColumn() > 0 ? 5.0 : 1.0);
            this.toolWindowBarContainerLayout.insertColumn(this.toolWindowBarContainerLayout.getNumColumn(), -2.0);
            int finalCol = index * 2 + 2;
            if (finalCol >= this.toolWindowBarContainerLayout.getNumColumn()) {
                index = -1;
            } else if (index != -1) {
                for (Component component : components = this.toolWindowBarContainer.getComponents()) {
                    TableLayoutConstraints constraints = this.toolWindowBarContainerLayout.getConstraints(component);
                    if (constraints.col1 < finalCol || !((RepresentativeAnchorWrapper)component).getDockableDescriptor().isAnchorPositionLocked()) continue;
                    finalCol += 2;
                    ++index;
                }
            }
            if (index >= 0) {
                components = this.toolWindowBarContainer.getComponents();
                Hashtable<Integer, Double> olds = new Hashtable<Integer, Double>();
                for (Component component : components) {
                    TableLayoutConstraints constraints = this.toolWindowBarContainerLayout.getConstraints(component);
                    if (constraints.col1 < finalCol) continue;
                    int newCol1 = constraints.col1 + 2;
                    this.toolWindowBarContainerLayout.setConstraints(component, new TableLayoutConstraints(newCol1 + ",1,"));
                    olds.put(newCol1, this.toolWindowBarContainerLayout.getColumn(newCol1));
                    Double colSize = (Double)olds.get(constraints.col1);
                    if (colSize == null) {
                        colSize = this.toolWindowBarContainerLayout.getColumn(constraints.col1);
                    }
                    this.toolWindowBarContainerLayout.setColumn(newCol1, colSize);
                }
                this.toolWindowBarContainerLayout.setColumn(finalCol, -2.0);
                this.toolWindowBarContainer.add(representativeAnchor, index * 2 + 2 + ",1");
            } else {
                this.toolWindowBarContainer.add(representativeAnchor, this.toolWindowBarContainerLayout.getNumColumn() - 1 + ",1");
            }
        } else {
            Component[] components;
            this.toolWindowBarContainerLayout.insertRow(this.toolWindowBarContainerLayout.getNumRow(), this.toolWindowBarContainerLayout.getNumRow() > 0 ? 5.0 : 1.0);
            this.toolWindowBarContainerLayout.insertRow(this.toolWindowBarContainerLayout.getNumRow(), -2.0);
            int finalRow = index * 2 + 2;
            if (finalRow >= this.toolWindowBarContainerLayout.getNumRow()) {
                index = -1;
            } else if (index != -1) {
                for (Component component : components = this.toolWindowBarContainer.getComponents()) {
                    TableLayoutConstraints constraints = this.toolWindowBarContainerLayout.getConstraints(component);
                    if (constraints.row1 < finalRow || !((RepresentativeAnchorWrapper)component).getDockableDescriptor().isAnchorPositionLocked()) continue;
                    finalRow += 2;
                    ++index;
                }
            }
            if (index >= 0) {
                components = this.toolWindowBarContainer.getComponents();
                Hashtable<Integer, Double> olds = new Hashtable<Integer, Double>();
                for (Component component : components) {
                    TableLayoutConstraints constraints = this.toolWindowBarContainerLayout.getConstraints(component);
                    if (constraints.row1 < finalRow) continue;
                    int newRow1 = constraints.row1 + 2;
                    this.toolWindowBarContainerLayout.setConstraints(component, new TableLayoutConstraints("1," + newRow1));
                    olds.put(newRow1, this.toolWindowBarContainerLayout.getRow(newRow1));
                    Double rowSize = (Double)olds.get(constraints.row1);
                    if (rowSize == null) {
                        rowSize = this.toolWindowBarContainerLayout.getRow(constraints.row1);
                    }
                    this.toolWindowBarContainerLayout.setRow(newRow1, rowSize);
                }
                if (this.toolWindowBarContainerLayout.getNumRow() <= finalRow) {
                    this.toolWindowBarContainerLayout.setRow(this.toolWindowBarContainerLayout.getNumRow() - 1, -2.0);
                } else {
                    this.toolWindowBarContainerLayout.setRow(finalRow, -2.0);
                }
                this.toolWindowBarContainer.add(representativeAnchor, "1," + (index * 2 + 2));
            } else {
                this.toolWindowBarContainer.add(representativeAnchor, "1," + (this.toolWindowBarContainerLayout.getNumRow() - 1));
            }
        }
        SwingUtil.repaint(this.toolWindowScrollBar);
    }

    protected void removeRepresentativeAnchor(DockableDescriptor dockableDescriptor, Component representativeAnchor) {
        TableLayoutConstraints constraints;
        Component[] components;
        if (representativeAnchor == null) {
            return;
        }
        for (Component component : components = this.toolWindowBarContainer.getComponents()) {
            if (!((RepresentativeAnchorWrapper)component).getRepresentativeAnchor().equals(representativeAnchor)) continue;
            representativeAnchor = component;
            break;
        }
        if ((constraints = this.toolWindowBarContainerLayout.getConstraints(representativeAnchor)) == null) {
            return;
        }
        if (dockableDescriptor.isAvailableCountable()) {
            --this.availableTools;
        }
        int toDelete = this.horizontal ? constraints.col1 : constraints.row1;
        this.toolWindowBarContainer.remove(representativeAnchor);
        if (this.horizontal) {
            this.toolWindowBarContainerLayout.deleteColumn(toDelete);
            this.toolWindowBarContainerLayout.deleteColumn(toDelete - 1);
        } else {
            this.toolWindowBarContainerLayout.deleteRow(toDelete);
            this.toolWindowBarContainerLayout.deleteRow(toDelete - 1);
        }
        SwingUtil.repaint(this.toolWindowScrollBar);
        dockableDescriptor.resetRepresentativeAnchor();
        this.manager.syncPanel(dockableDescriptor.getAnchor());
    }

    protected TableLayoutConstraints getRepresentativeAnchorConstraints(Component representativeAnchor) {
        Component[] components;
        for (Component component : components = this.toolWindowBarContainer.getComponents()) {
            if (!((RepresentativeAnchorWrapper)component).getRepresentativeAnchor().equals(representativeAnchor)) continue;
            representativeAnchor = component;
            break;
        }
        return this.toolWindowBarContainerLayout.getConstraints(representativeAnchor);
    }

    public class RepresentativeAnchorWrapper
    extends JPanel {
        protected DockableDescriptor dockableDescriptor;
        protected Component representativeAnchor;

        public RepresentativeAnchorWrapper(DockableDescriptor dockableDescriptor, Component representativeAnchor) {
            this.dockableDescriptor = dockableDescriptor;
            this.representativeAnchor = representativeAnchor;
            this.setOpaque(false);
            this.setLayout(new ExtendedTableLayout(new double[][]{{-1.0}, {-1.0}}));
            this.putClientProperty("ra", representativeAnchor);
            this.add(representativeAnchor, "0,0,FULL,FULL");
        }

        public DockableDescriptor getDockableDescriptor() {
            return this.dockableDescriptor;
        }

        public Component getRepresentativeAnchor() {
            return this.representativeAnchor;
        }
    }

    public class DockedDockableDropPanel
    extends DockableDropPanel {
        public DockedDockableDropPanel() {
            super(ToolWindow.class, Content.class);
        }

        public boolean dragStart(Transferable transferable, int action) {
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(MyDoggyToolWindowBar.this.manager)) && action == 2 && (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF) || transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF))) {
                    return super.dragStart(transferable, action);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean drop(Transferable transferable) {
            block49: {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) {
                    try {
                        ToolWindow toolWindow = MyDoggyToolWindowBar.this.manager.getToolWindow(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                        if (toolWindow != null) {
                            ToolWindow onToolWindow;
                            int anchorIndex;
                            if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                                ToolWindowTab tab = (ToolWindowTab)MyDoggyToolWindowBar.this.manager.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                                tab.getOwner().removeToolWindowTab(tab);
                                toolWindow = (ToolWindow)tab.getDockableDelegator();
                            }
                            int n = anchorIndex = (onToolWindow = (ToolWindow)this.getOnDockable()) != null ? onToolWindow.getAnchorIndex() : -1;
                            if (toolWindow == onToolWindow) {
                                return false;
                            }
                            boolean oldAggregateMode = toolWindow.isAggregateMode();
                            toolWindow.setAggregateMode(true);
                            try {
                                ToolWindowAnchor dragAnchor = this.getOnAnchor();
                                if (dragAnchor == null && onToolWindow != null && toolWindow != onToolWindow && !SwingUtil.getBoolean("drag.toolwindow.asTab", true)) {
                                    switch (onToolWindow.getAnchor()) {
                                        case LEFT: 
                                        case RIGHT: {
                                            dragAnchor = ToolWindowAnchor.TOP;
                                            break;
                                        }
                                        case TOP: 
                                        case BOTTOM: {
                                            dragAnchor = ToolWindowAnchor.LEFT;
                                        }
                                    }
                                }
                                if (dragAnchor != null) {
                                    switch (dragAnchor) {
                                        case LEFT: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, anchorIndex != -1 ? anchorIndex - 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, 0);
                                            toolWindow.aggregate(AggregationPosition.LEFT);
                                            break;
                                        }
                                        case RIGHT: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, anchorIndex != -1 ? anchorIndex + 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor);
                                            toolWindow.aggregate(AggregationPosition.RIGHT);
                                            break;
                                        }
                                        case BOTTOM: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, anchorIndex != -1 ? anchorIndex + 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor);
                                            toolWindow.aggregate(AggregationPosition.BOTTOM);
                                            break;
                                        }
                                        case TOP: {
                                            if (onToolWindow != null) {
                                                toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, anchorIndex != -1 ? anchorIndex - 1 : -1);
                                                toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                                break;
                                            }
                                            if (!this.checkCondition(toolWindow)) break;
                                            toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, 0);
                                            toolWindow.aggregate(AggregationPosition.TOP);
                                        }
                                    }
                                    toolWindow.setActive(true);
                                } else if (onToolWindow != null && toolWindow != onToolWindow) {
                                    onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                    onToolWindow.setActive(true);
                                } else {
                                    toolWindow.aggregate();
                                    toolWindow.setActive(true);
                                }
                                Object var8_14 = null;
                                toolWindow.setAggregateMode(oldAggregateMode);
                            }
                            catch (Throwable throwable) {
                                Object var8_15 = null;
                                toolWindow.setAggregateMode(oldAggregateMode);
                                throw throwable;
                            }
                            return true;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                    try {
                        Content content = MyDoggyToolWindowBar.this.manager.getContentManager().getContent(transferable.getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                        if (content != null) {
                            if (content.getDockableDelegator() != null) {
                                MyDoggyToolWindowBar.this.manager.getContentManager().removeContent(content);
                                Dockable delegator = content.getDockableDelegator();
                                if (!(delegator instanceof ToolWindow)) break block49;
                                ToolWindow toolWindow = (ToolWindow)delegator;
                                ToolWindow onToolWindow = (ToolWindow)this.getOnDockable();
                                int anchorIndex = onToolWindow != null ? onToolWindow.getAnchorIndex() : -1;
                                ToolWindowAnchor dragAnchor = this.getOnAnchor();
                                if (toolWindow == onToolWindow) {
                                    return false;
                                }
                                boolean oldAggregateMode = toolWindow.isAggregateMode();
                                toolWindow.setAggregateMode(true);
                                try {
                                    toolWindow.setAnchor(MyDoggyToolWindowBar.this.anchor, anchorIndex);
                                    if (dragAnchor != null) {
                                        switch (dragAnchor) {
                                            case LEFT: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.LEFT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.LEFT);
                                                break;
                                            }
                                            case RIGHT: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.RIGHT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.RIGHT);
                                                break;
                                            }
                                            case BOTTOM: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.BOTTOM);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.BOTTOM);
                                                break;
                                            }
                                            case TOP: {
                                                if (onToolWindow != null) {
                                                    toolWindow.aggregate(onToolWindow, AggregationPosition.TOP);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.TOP);
                                            }
                                        }
                                        toolWindow.setActive(true);
                                    } else if (onToolWindow != null) {
                                        onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                        onToolWindow.setActive(true);
                                    } else {
                                        toolWindow.aggregate();
                                        toolWindow.setActive(true);
                                    }
                                    Object var10_19 = null;
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                }
                                catch (Throwable throwable) {
                                    Object var10_20 = null;
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                    throw throwable;
                                }
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
            return false;
        }

        protected boolean checkCondition(ToolWindow toolWindow) {
            return true;
        }
    }

    public class DividerSizeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (MyDoggyToolWindowBar.this.splitPane.getDividerSize() > 0) {
                MyDoggyToolWindowBar.this.splitPane.setDividerSize((Integer)evt.getNewValue());
            }
        }
    }

    public class MaximizedListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            if (descriptor.getToolWindow().getType() == ToolWindowType.DOCKED) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    descriptor.setTempDivederLocation(MyDoggyToolWindowBar.this.getSplitDividerLocation());
                    MyDoggyToolWindow maximizedTool = descriptor.getToolWindow();
                    for (ToolWindow tool : MyDoggyToolWindowBar.this.manager.getToolWindows()) {
                        if (tool == maximizedTool || tool.getType() == ToolWindowType.FLOATING || tool.getType() == ToolWindowType.FLOATING_FREE || tool.getType() == ToolWindowType.EXTERN) continue;
                        tool.setVisible(false);
                    }
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(-1);
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                } else {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(descriptor.getTempDivederLocation());
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                }
            }
        }
    }

    public class DragSupportListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if ("startDrag".equals(evt.getPropertyName())) {
                Component cmp = SwingUtil.getComponentWhoseParentIs((Component)evt.getSource(), MyDoggyToolWindowBar.this.toolWindowBarContainer);
                TableLayout layout = (TableLayout)MyDoggyToolWindowBar.this.toolWindowBarContainer.getLayout();
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: 
                    case RIGHT: {
                        dragComponentLength = cmp.getHeight();
                        layout.setRow(layout.getConstraints((Component)cmp).row1, 0.0);
                        break;
                    }
                    case TOP: 
                    case BOTTOM: {
                        dragComponentLength = cmp.getWidth();
                        layout.setColumn(layout.getConstraints((Component)cmp).col1, 0.0);
                    }
                }
                SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
            } else if ("endDrag".equals(evt.getPropertyName())) {
                TableLayout layout = (TableLayout)MyDoggyToolWindowBar.this.toolWindowBarContainer.getLayout();
                TableLayoutConstraints constraints = MyDoggyToolWindowBar.this.getRepresentativeAnchorConstraints((Component)evt.getSource());
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: 
                    case RIGHT: {
                        if (constraints == null) break;
                        layout.setRow(constraints.row1, dragComponentLength);
                        break;
                    }
                    case TOP: 
                    case BOTTOM: {
                        if (constraints == null) break;
                        layout.setColumn(constraints.col1, dragComponentLength);
                    }
                }
                if (constraints != null) {
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
                    MyDoggyToolWindowBar.this.manager.syncPanel(MyDoggyToolWindowBar.this.anchor);
                }
            } else {
                throw new IllegalArgumentException("Invalid property name. [property : " + evt.getPropertyName() + "]");
            }
        }
    }

    public class BarLengthListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            int oldValue = (Integer)evt.getOldValue() - 4;
            int newValue = (Integer)evt.getNewValue() - 4;
            switch (MyDoggyToolWindowBar.this.anchor) {
                case LEFT: 
                case RIGHT: {
                    int size = MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.getNumColumn();
                    for (int i = 0; i < size; ++i) {
                        if (MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.getColumn(i) != (double)oldValue) continue;
                        MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.setColumn(i, newValue);
                    }
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    int size = MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.getNumRow();
                    for (int i = 0; i < size; ++i) {
                        if (MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.getRow(i) != (double)oldValue) continue;
                        MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.setRow(i, newValue);
                    }
                    break;
                }
            }
            SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
        }
    }

    public class TitleListener
    extends IndexListener {
    }

    public class IconListener
    extends IndexListener {
    }

    public class IndexListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            JLabel representativeAnchor = descriptor.getRepresentativeAnchor();
            if (representativeAnchor != null) {
                TableLayoutConstraints constraints = MyDoggyToolWindowBar.this.getRepresentativeAnchorConstraints(representativeAnchor);
                if (MyDoggyToolWindowBar.this.horizontal) {
                    int width = representativeAnchor.getPreferredSize().width + 6;
                    MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.setColumn(constraints.col1, width);
                } else {
                    int height = Math.max(representativeAnchor.getPreferredSize().height, representativeAnchor.getSize().height);
                    MyDoggyToolWindowBar.this.toolWindowBarContainerLayout.setRow(constraints.row1, height);
                }
                SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
            }
        }
    }

    public class VisibleFloatingLiveListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            boolean visible = (Boolean)evt.getNewValue();
            if (evt instanceof UserPropertyChangeEvent) {
                ToolWindowPanel component;
                Object[] params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                ToolWindow referenceAggregationTool = (ToolWindow)params[3];
                ToolWindowDescriptor referenceAggregationDescriptor = null;
                if (referenceAggregationTool != null) {
                    referenceAggregationDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(referenceAggregationTool);
                }
                ToolWindow aggregationOnTool = (ToolWindow)params[2];
                ToolWindowDescriptor aggregationOnDescriptor = null;
                if (aggregationOnTool != null) {
                    aggregationOnDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(aggregationOnTool);
                }
                if (referenceAggregationDescriptor == null) {
                    referenceAggregationDescriptor = aggregationOnDescriptor;
                }
                ToolWindowPanel toolWindowPanel = component = visible ? toolWindowDescriptor.getToolWindowPanel() : null;
                if (component == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                    return;
                }
                FloatingLiveContainer container = (FloatingLiveContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING_LIVE);
                container.setVisible(referenceAggregationDescriptor, component, aggregationOnDescriptor, (AggregationPosition)((Object)params[1]));
            } else {
                Component content = visible ? toolWindowDescriptor.getComponent() : null;
                FloatingLiveContainer container = (FloatingLiveContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING_LIVE);
                if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                    return;
                }
                container.setVisible(visible);
            }
        }
    }

    public class VisibleFloatingFreeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            FloatingContainer container = (FloatingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING_FREE);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.setVisible(visible);
        }
    }

    public class VisibleFloatingListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            boolean visible = (Boolean)evt.getNewValue();
            if (evt instanceof UserPropertyChangeEvent) {
                ToolWindowPanel content;
                Object[] params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                ToolWindow referenceAggregationTool = (ToolWindow)params[3];
                ToolWindowDescriptor referenceAggregationDescriptor = null;
                if (referenceAggregationTool != null) {
                    referenceAggregationDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(referenceAggregationTool);
                }
                ToolWindow aggregationOnTool = (ToolWindow)params[2];
                ToolWindowDescriptor aggregationOnDescriptor = null;
                if (aggregationOnTool != null) {
                    aggregationOnDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(aggregationOnTool);
                }
                if (referenceAggregationDescriptor == null) {
                    referenceAggregationDescriptor = aggregationOnDescriptor;
                }
                ToolWindowPanel toolWindowPanel = content = visible ? toolWindowDescriptor.getToolWindowPanel() : null;
                if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                    return;
                }
                FloatingContainer container = (FloatingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING);
                container.setVisible(referenceAggregationDescriptor, content, aggregationOnDescriptor, (AggregationPosition)((Object)params[1]));
            } else {
                Component content = visible ? toolWindowDescriptor.getComponent() : null;
                FloatingContainer container = (FloatingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.FLOATING);
                if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                    return;
                }
                container.setVisible(visible);
            }
        }
    }

    public class VisibleSlidingListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            boolean visible = (Boolean)evt.getNewValue();
            Component content = visible ? toolWindowDescriptor.getComponent() : null;
            SlidingContainer container = (SlidingContainer)toolWindowDescriptor.getToolWindowContainer(ToolWindowType.SLIDING);
            if (content == null && toolWindowDescriptor.getToolWindow().isVisible()) {
                return;
            }
            container.setVisible(visible, MyDoggyToolWindowBar.this.getContainer());
        }
    }

    public class VisibleDockedListener
    implements PropertyChangeListener {
        protected final SplitAnimation splitAnimation = new SplitAnimation();
        protected boolean vsdValueAdjusting = false;
        protected Map<ToolWindowDescriptor, Integer> anchorPositions = new HashMap<ToolWindowDescriptor, Integer>();

        public VisibleDockedListener() {
            MyDoggyToolWindowBar.this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    int dividerLocation = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                    if (VisibleDockedListener.this.splitAnimation.isAnimating() || VisibleDockedListener.this.vsdValueAdjusting || dividerLocation <= 5) {
                        return;
                    }
                    for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                        if (!toolWindow.isVisible()) continue;
                        MyDoggyToolWindowBar.this.manager.getDescriptor(toolWindow).setDividerLocation(dividerLocation);
                    }
                }
            });
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!MyDoggyToolWindowBar.this.manager.getContentManager().isEnabled() && MyDoggyToolWindowBar.this.manager.dockableMainContentMode) {
                this.disabledContentManagerPropertyChange(evt);
            } else {
                this.enabledContentManagerPropertyChange(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void enabledContentManagerPropertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor descriptor;
            block39: {
                int dividerLocation;
                block36: {
                    block37: {
                        block38: {
                            boolean animate;
                            Component component;
                            block32: {
                                block33: {
                                    Component splitPaneContent;
                                    AggregationPosition aggregationPosition;
                                    boolean shiftShow;
                                    block34: {
                                        MultiSplitDockableContainer dockableContainer;
                                        ToolWindow aggregationOnTool;
                                        block35: {
                                            shiftShow = false;
                                            aggregationPosition = AggregationPosition.DEFAULT;
                                            aggregationOnTool = null;
                                            if (evt instanceof UserPropertyChangeEvent) {
                                                UserPropertyChangeEvent upce = (UserPropertyChangeEvent)evt;
                                                Object[] args = (Object[])upce.getUserObject();
                                                shiftShow = (Boolean)args[0];
                                                aggregationPosition = (AggregationPosition)((Object)args[1]);
                                                aggregationOnTool = (ToolWindow)args[2];
                                            }
                                            descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
                                            boolean visible = (Boolean)evt.getNewValue();
                                            ToolWindowDescriptor.fullExternalFocusValueAdjusting = true;
                                            if (descriptor.getTypeDescriptor().isHideRepresentativeButtonOnVisible()) {
                                                if (visible) {
                                                    this.anchorPositions.put(descriptor, descriptor.getAnchorIndex());
                                                    SwingUtilities.invokeLater(new Runnable(){

                                                        public void run() {
                                                            MyDoggyToolWindowBar.this.removeRepresentativeAnchor(descriptor, descriptor.getRepresentativeAnchor());
                                                        }
                                                    });
                                                } else {
                                                    int index = -1;
                                                    if (this.anchorPositions.containsKey(descriptor)) {
                                                        index = this.anchorPositions.get(descriptor);
                                                    }
                                                    MyDoggyToolWindowBar.this.addRepresentativeAnchor(descriptor, descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.toolWindowBarContainer), index);
                                                }
                                            }
                                            Component component2 = component = visible ? descriptor.getComponent() : null;
                                            if (component != null) {
                                                component = descriptor.getToolWindowPanel();
                                            }
                                            if (component == null || descriptor.getDividerLocation() > 0 && MyDoggyToolWindowBar.this.splitPane.getDividerSize() != 0) {
                                                SplitAnimation splitAnimation = this.splitAnimation;
                                                // MONITORENTER : splitAnimation
                                                if (this.splitAnimation.isAnimating()) {
                                                    this.splitAnimation.stop();
                                                }
                                                // MONITOREXIT : splitAnimation
                                                if (MyDoggyToolWindowBar.this.manager.getShowingGroup() == null) {
                                                    descriptor.setDividerLocation(MyDoggyToolWindowBar.this.getSplitDividerLocation());
                                                } else {
                                                    this.updateToolDividerLocation(descriptor.getDividerLocation());
                                                }
                                            }
                                            if (component == null && descriptor.getToolWindow().isVisible()) {
                                                return;
                                            }
                                            dividerLocation = Math.max(descriptor.getDividerLocation(), descriptor.getDockedTypeDescriptor().getMinimumDockLength());
                                            if (MyDoggyToolWindowBar.this.getSplitDividerLocation() != 0) {
                                                for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                                                    if (descriptor.getToolWindow() == toolWindow || !toolWindow.isVisible() || toolWindow.getType() != ToolWindowType.DOCKED) continue;
                                                    dividerLocation = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                                                    break;
                                                }
                                            }
                                            animate = true;
                                            splitPaneContent = MyDoggyToolWindowBar.this.getSplitPaneContent();
                                            if (splitPaneContent == null) break block33;
                                            if (!(splitPaneContent instanceof MultiSplitDockableContainer)) break block34;
                                            dockableContainer = (MultiSplitDockableContainer)splitPaneContent;
                                            if (component != null) break block35;
                                            dockableContainer.removeDockable(descriptor.getToolWindow(), !visible && !MyDoggyToolWindowBar.this.manager.isShowingGroup());
                                            animate = false;
                                            if (dockableContainer.isEmpty()) {
                                                animate = true;
                                                component = null;
                                                break block32;
                                            } else if (dockableContainer.getDockableCount() == 1) {
                                                animate = false;
                                                Dockable dockable = dockableContainer.getDockable();
                                                component = dockableContainer.getDockableComponent();
                                                dockableContainer.removeDockable(dockable, false);
                                                int temp = MyDoggyToolWindowBar.this.getSplitDividerLocation();
                                                this.setSplitPaneContent(component);
                                                MyDoggyToolWindowBar.this.setSplitDividerLocation(temp);
                                            }
                                            break block32;
                                        }
                                        if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null) {
                                            dockableContainer.addDockable(descriptor.getToolWindow(), component, aggregationOnTool, -1, aggregationPosition);
                                            break block32;
                                        } else {
                                            this.setSplitPaneContent(component);
                                        }
                                        break block32;
                                    }
                                    if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null && component != null) {
                                        MyDoggyToolWindowBar.this.multiSplitDockableContainer.clear();
                                        if (shiftShow) {
                                            MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable((Dockable)((JComponent)splitPaneContent).getClientProperty(ToolWindow.class), splitPaneContent, null, -1, AggregationPosition.DEFAULT);
                                        }
                                        MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable(descriptor.getToolWindow(), component, null, -1, aggregationPosition);
                                        this.setSplitPaneContent(MyDoggyToolWindowBar.this.multiSplitDockableContainer);
                                        break block32;
                                    } else if (component != null) {
                                        this.setSplitPaneContent(component);
                                    }
                                    break block32;
                                }
                                if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null && component != null) {
                                    MyDoggyToolWindowBar.this.multiSplitDockableContainer.clear();
                                    MyDoggyToolWindowBar.this.multiSplitDockableContainer.addDockable(descriptor.getToolWindow(), component, null, -1, AggregationPosition.DEFAULT);
                                    this.setSplitPaneContent(MyDoggyToolWindowBar.this.multiSplitDockableContainer);
                                } else if (component != null) {
                                    this.setSplitPaneContent(component);
                                }
                            }
                            if (!animate) break block36;
                            if (component == null) break block37;
                            MyDoggyToolWindowBar.this.splitPane.setDividerSize(MyDoggyToolWindowBar.this.getDividerSize());
                            if (MyDoggyToolWindowBar.this.manager.getShowingGroup() != null || !descriptor.getTypeDescriptor(ToolWindowType.DOCKED).isAnimating()) break block38;
                            this.splitAnimation.show(dividerLocation);
                            break block39;
                        }
                        if (dividerLocation != 0) {
                            this.vsdValueAdjusting = true;
                            try {
                                MyDoggyToolWindowBar.this.setSplitDividerLocation(dividerLocation);
                                Object var15_20 = null;
                                this.vsdValueAdjusting = false;
                            }
                            catch (Throwable throwable) {
                                Object var15_21 = null;
                                this.vsdValueAdjusting = false;
                                throw throwable;
                            }
                            SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                        }
                        break block39;
                    }
                    MyDoggyToolWindowBar.this.splitPane.setDividerSize(0);
                    this.setSplitPaneContent(null);
                    this.vsdValueAdjusting = true;
                    try {
                        MyDoggyToolWindowBar.this.setSplitDividerLocation(0);
                        SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                        Object var17_23 = null;
                        this.vsdValueAdjusting = false;
                    }
                    catch (Throwable throwable) {
                        Object var17_24 = null;
                        this.vsdValueAdjusting = false;
                        throw throwable;
                    }
                }
                MyDoggyToolWindowBar.this.setSplitDividerLocation(dividerLocation);
                SwingUtil.repaint(MyDoggyToolWindowBar.this.splitPane);
            }
            descriptor.disableFullExternalFocusValueAdjustingLater();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disabledContentManagerPropertyChange(PropertyChangeEvent evt) {
            MultiSplitDockableContainer managerDockableContainer = (MultiSplitDockableContainer)((DockableDropPanel)MyDoggyToolWindowBar.this.manager.getMainContent()).getComponent();
            ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            boolean visible = (Boolean)evt.getNewValue();
            ToolWindowDescriptor.fullExternalFocusValueAdjusting = true;
            try {
                if (visible) {
                    AggregationPosition aggregationPosition;
                    ToolWindow aggregationOnTool = null;
                    if (evt instanceof UserPropertyChangeEvent) {
                        UserPropertyChangeEvent upce = (UserPropertyChangeEvent)evt;
                        Object[] args = (Object[])upce.getUserObject();
                        aggregationPosition = (AggregationPosition)((Object)args[1]);
                        aggregationOnTool = (ToolWindow)args[2];
                    } else {
                        aggregationPosition = AggregationPosition.valueOf(MyDoggyToolWindowBar.this.anchor.toString());
                    }
                    managerDockableContainer.addDockable(descriptor.getToolWindow(), descriptor.getToolWindowPanel(), aggregationOnTool, -1, aggregationPosition);
                } else {
                    managerDockableContainer.removeDockable(descriptor.getToolWindow());
                }
                SwingUtil.repaint(managerDockableContainer);
                Object var10_9 = null;
                descriptor.disableFullExternalFocusValueAdjustingLater();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                descriptor.disableFullExternalFocusValueAdjustingLater();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setSplitPaneContent(Component content) {
            this.vsdValueAdjusting = true;
            try {
                if (content != null && MyDoggyToolWindowBar.this.splitPane.getDividerLocation() == 0) {
                    MyDoggyToolWindowBar.this.splitPane.setDividerLocation(1);
                }
                Component splitPaneContent = content;
                if (content != null) {
                    MyDoggyToolWindowBar.this.dockableDropPanel.setComponent(content);
                    splitPaneContent = MyDoggyToolWindowBar.this.dockableDropPanel;
                } else {
                    MyDoggyToolWindowBar.this.dockableDropPanel.resetComponent();
                }
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: {
                        MyDoggyToolWindowBar.this.splitPane.setLeftComponent(splitPaneContent);
                        break;
                    }
                    case RIGHT: {
                        MyDoggyToolWindowBar.this.splitPane.setRightComponent(splitPaneContent);
                        if (splitPaneContent == null) break;
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getWidth());
                        break;
                    }
                    case BOTTOM: {
                        MyDoggyToolWindowBar.this.splitPane.setBottomComponent(splitPaneContent);
                        if (splitPaneContent == null) break;
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getHeight());
                        break;
                    }
                    case TOP: {
                        MyDoggyToolWindowBar.this.splitPane.setTopComponent(splitPaneContent);
                    }
                }
                if (splitPaneContent != null) {
                    content.setVisible(true);
                }
                Object var4_3 = null;
                this.vsdValueAdjusting = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.vsdValueAdjusting = false;
                throw throwable;
            }
        }

        protected void updateToolDividerLocation(int divederLocation) {
            for (ToolWindow toolWindow : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                if (!toolWindow.isVisible()) continue;
                MyDoggyToolWindowBar.this.manager.getDescriptor(toolWindow).setDividerLocation(divederLocation);
            }
        }

        public class SplitAnimation
        extends AbstractAnimation {
            protected int dividerLocation;
            protected int sheetLen;

            public SplitAnimation() {
                super(60.0f);
            }

            protected float onAnimating(float animationPercent) {
                AbstractAnimation.Direction direction = this.getAnimationDirection();
                int animatingHeight = direction == AbstractAnimation.Direction.INCOMING ? (int)(animationPercent * (float)this.sheetLen) : (int)((1.0f - animationPercent) * (float)this.sheetLen);
                switch (MyDoggyToolWindowBar.this.anchor) {
                    case LEFT: 
                    case TOP: {
                        if (direction == AbstractAnimation.Direction.INCOMING) {
                            if (MyDoggyToolWindowBar.this.splitPane.getDividerLocation() > animatingHeight) break;
                            MyDoggyToolWindowBar.this.splitPane.setDividerLocation(animatingHeight);
                            break;
                        }
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(animatingHeight);
                        break;
                    }
                    case RIGHT: {
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getWidth() - animatingHeight);
                        break;
                    }
                    case BOTTOM: {
                        MyDoggyToolWindowBar.this.splitPane.setDividerLocation(MyDoggyToolWindowBar.this.splitPane.getHeight() - animatingHeight);
                    }
                }
                return animationPercent;
            }

            protected void onFinishAnimation() {
                if (MyDoggyToolWindowBar.this.splitPane.getDividerSize() == 0) {
                    VisibleDockedListener.this.setSplitPaneContent(null);
                } else if (this.getAnimationDirection() == AbstractAnimation.Direction.OUTGOING) {
                    VisibleDockedListener.this.vsdValueAdjusting = true;
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(0);
                    VisibleDockedListener.this.vsdValueAdjusting = false;
                } else {
                    MyDoggyToolWindowBar.this.setSplitDividerLocation(this.sheetLen);
                    SwingUtil.repaintNow(MyDoggyToolWindowBar.this.splitPane);
                }
            }

            protected void onHide(Object ... params) {
                this.dividerLocation = (Integer)params[0];
            }

            protected void onShow(Object ... params) {
                this.dividerLocation = (Integer)params[0];
            }

            protected void onStartAnimation(AbstractAnimation.Direction direction) {
                this.sheetLen = this.dividerLocation;
            }

            protected AbstractAnimation.Direction chooseFinishDirection(AbstractAnimation.Type type) {
                return type == AbstractAnimation.Type.SHOW ? AbstractAnimation.Direction.OUTGOING : AbstractAnimation.Direction.INCOMING;
            }
        }
    }

    public class VisibleListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            boolean oldValue = (Boolean)evt.getOldValue();
            boolean newValue = (Boolean)evt.getNewValue();
            if (evt instanceof UserPropertyChangeEvent) {
                MyDoggyToolWindowBar.this.propertyChange(new UserPropertyChangeEvent(evt.getSource(), "visible." + sourceTool.getType().toString(), null, !oldValue && newValue, ((UserPropertyChangeEvent)evt).getUserObject()));
            } else {
                MyDoggyToolWindowBar.this.propertyChange(new PropertyChangeEvent(evt.getSource(), "visible." + sourceTool.getType().toString(), null, !oldValue && newValue));
            }
        }
    }

    public class VisibleBeforeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            if (sourceTool.getType() == ToolWindowType.FLOATING || sourceTool.getType() == ToolWindowType.FLOATING_FREE) {
                return;
            }
            boolean oldValue = (Boolean)evt.getOldValue();
            boolean newValue = (Boolean)evt.getNewValue();
            if (!oldValue && newValue) {
                ToolWindow[] toolWindows;
                if (MyDoggyToolWindowBar.this.getAnchor().equals((Object)sourceTool.getAnchor()) && sourceTool.getType() == ToolWindowType.SLIDING) {
                    return;
                }
                for (ToolWindow toolWindow : toolWindows = MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.getAnchor())) {
                    if (toolWindow == sourceTool) continue;
                    if (MyDoggyToolWindowBar.this.manager.getShowingGroup() == null) {
                        if (toolWindow.getType() == ToolWindowType.FLOATING || toolWindow.getType() == ToolWindowType.FLOATING_FREE || toolWindow.getType() == ToolWindowType.FLOATING_LIVE || toolWindow.getType() == ToolWindowType.EXTERN) continue;
                        if (toolWindow.getAnchor().equals((Object)sourceTool.getAnchor())) {
                            MyDoggyToolWindowBar.this.hideTool(toolWindow);
                        } else if (toolWindow.isAutoHide() || toolWindow.getType() == ToolWindowType.SLIDING) {
                            MyDoggyToolWindowBar.this.hideTool(toolWindow);
                        }
                    } else if (toolWindow.getType() == ToolWindowType.SLIDING) {
                        MyDoggyToolWindowBar.this.hideTool(toolWindow);
                    }
                    if (!toolWindow.isVisible() || !toolWindow.isMaximized()) continue;
                    toolWindow.setMaximized(false);
                }
            }
        }
    }

    public class TypeListener
    extends AvailableListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindowDescriptor toolWindowDescriptor = MyDoggyToolWindowBar.this.manager.getDescriptor((ToolWindow)evt.getSource());
            if (evt.getOldValue() == ToolWindowType.FLOATING_FREE) {
                MyDoggyToolWindowBar.this.addRepresentativeAnchor(toolWindowDescriptor, toolWindowDescriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.toolWindowBarContainer), -1);
                MyDoggyToolWindowBar.this.ensureVisible(toolWindowDescriptor.getRepresentativeAnchor());
                SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
            } else if ((evt.getNewValue() == ToolWindowType.FLOATING_FREE || evt.getNewValue() == ToolWindowType.EXTERN) && toolWindowDescriptor.getRepresentativeAnchor() != null) {
                MyDoggyToolWindowBar.this.removeRepresentativeAnchor(toolWindowDescriptor, toolWindowDescriptor.getRepresentativeAnchor());
                SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
            }
        }
    }

    public class ActiveBeforeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            ToolWindow sourceTool = (ToolWindow)evt.getSource();
            boolean newValue = (Boolean)evt.getNewValue();
            if (newValue) {
                ToolWindow[] toolWindows;
                for (ToolWindow toolWindow : toolWindows = MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.getAnchor())) {
                    if (toolWindow == sourceTool) continue;
                    MyDoggyToolWindowBar.this.deactiveTool(toolWindow);
                }
            }
        }
    }

    public class ShowUnavailableToolsListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() == Boolean.TRUE) {
                for (ToolWindow tool : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                    if (tool.isAvailable() || tool.getType() == ToolWindowType.FLOATING_FREE) continue;
                    ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(tool);
                    MyDoggyToolWindowBar.this.addRepresentativeAnchor(descriptor, MyDoggyToolWindowBar.this.manager.getDescriptor(tool).getRepresentativeAnchor(MyDoggyToolWindowBar.this.toolWindowBarContainer), -1);
                }
            } else {
                for (ToolWindow tool : MyDoggyToolWindowBar.this.manager.getToolsByAnchor(MyDoggyToolWindowBar.this.anchor)) {
                    if (tool.isAvailable() || tool.getType() == ToolWindowType.FLOATING_FREE) continue;
                    ToolWindowDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDescriptor(tool);
                    MyDoggyToolWindowBar.this.removeRepresentativeAnchor(descriptor, descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.toolWindowBarContainer));
                }
            }
        }
    }

    public class AvailableListener
    implements PropertyChangeListener {
        protected Map<DockableDescriptor, Integer> rabsPositions = new Hashtable<DockableDescriptor, Integer>();

        public void propertyChange(PropertyChangeEvent evt) {
            DockableDescriptor descriptor = MyDoggyToolWindowBar.this.manager.getDockableDescriptorBySource(evt.getSource());
            if (this.isDockableDescriptorValid(descriptor)) {
                boolean rabEvent = evt.getPropertyName().equals("visible");
                if (!rabEvent && descriptor.getDockableType() == DockableDescriptor.DockableType.TOOL_WINDOW && !((ToolWindow)descriptor.getDockable()).getRepresentativeAnchorDescriptor().isVisible()) {
                    return;
                }
                boolean oldAvailable = (Boolean)evt.getOldValue();
                boolean newAvailable = (Boolean)evt.getNewValue();
                boolean repaint = false;
                if (oldAvailable && !newAvailable) {
                    JComponent representativeAnchor;
                    boolean updateRepresentativeAnchor = false;
                    if (!rabEvent) {
                        assert (evt instanceof UserPropertyChangeEvent);
                        Object[] params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                        boolean bl = updateRepresentativeAnchor = MyDoggyToolWindowBar.this.manager.getToolWindowManagerDescriptor().isShowUnavailableTools() && descriptor.getAnchorIndex() != -1;
                        if (params[1] == Boolean.TRUE) {
                            updateRepresentativeAnchor = false;
                        }
                    }
                    if ((representativeAnchor = descriptor.getRepresentativeAnchor()) != null) {
                        if (updateRepresentativeAnchor && descriptor.getDockableType() == DockableDescriptor.DockableType.TOOL_WINDOW) {
                            descriptor.updateRepresentativeAnchor();
                        } else {
                            if (rabEvent) {
                                this.rabsPositions.put(descriptor, descriptor.getAnchorIndex());
                            }
                            MyDoggyToolWindowBar.this.removeRepresentativeAnchor(descriptor, representativeAnchor);
                        }
                        repaint = true;
                    }
                } else if (!oldAvailable && newAvailable) {
                    Object[] params = null;
                    boolean updateRepresentativeAnchor = false;
                    if (!rabEvent) {
                        assert (evt instanceof UserPropertyChangeEvent);
                        params = (Object[])((UserPropertyChangeEvent)evt).getUserObject();
                        boolean bl = updateRepresentativeAnchor = MyDoggyToolWindowBar.this.manager.getToolWindowManagerDescriptor().isShowUnavailableTools() && descriptor.getAnchorIndex() != -1;
                        if (params[1] == Boolean.TRUE) {
                            updateRepresentativeAnchor = false;
                        }
                    }
                    JComponent representativeAnchor = descriptor.getRepresentativeAnchor(MyDoggyToolWindowBar.this.toolWindowBarContainer);
                    if (updateRepresentativeAnchor && descriptor.getDockableType() != DockableDescriptor.DockableType.CUSTOM) {
                        descriptor.updateRepresentativeAnchor();
                    } else if (rabEvent) {
                        int index = -1;
                        if (rabEvent && this.rabsPositions.containsKey(descriptor)) {
                            index = this.rabsPositions.get(descriptor);
                        }
                        MyDoggyToolWindowBar.this.addRepresentativeAnchor(descriptor, representativeAnchor, index);
                    } else {
                        MyDoggyToolWindowBar.this.addRepresentativeAnchor(descriptor, representativeAnchor, (Integer)params[0]);
                    }
                    repaint = true;
                }
                if (repaint) {
                    SwingUtil.repaint(MyDoggyToolWindowBar.this.toolWindowBarContainer);
                }
            }
        }

        protected boolean isDockableDescriptorValid(DockableDescriptor dockableDescriptor) {
            if (dockableDescriptor.getDockableType() == DockableDescriptor.DockableType.TOOL_WINDOW) {
                ToolWindow tool = (ToolWindow)dockableDescriptor.getDockable();
                return tool.getType() != ToolWindowType.FLOATING_FREE && tool.getType() != ToolWindowType.EXTERN;
            }
            return true;
        }
    }
}

