/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class ContentDesktopManager
implements DesktopManager,
Serializable {
    private static final long serialVersionUID = -2247702899708786437L;
    static final String HAS_BEEN_ICONIFIED_PROPERTY = "wasIconOnce";
    static final int DEFAULT_DRAG_MODE = 0;
    static final int OUTLINE_DRAG_MODE = 1;
    int dragMode = 0;
    private transient Rectangle currentBounds = null;
    private transient Point currentLoc = null;

    public void openFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        if (f.getDesktopIcon().getParent() != null) {
            f.getDesktopIcon().getParent().add(f);
            this.removeIconFor(f);
        }
    }

    public void closeFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        boolean findNext = f.isSelected();
        Container c = f.getParent();
        if (findNext) {
            try {
                f.setSelected(false);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
        }
        if (c != null) {
            c.remove(f);
            c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        }
        this.removeIconFor(f);
        if (f.getNormalBounds() != null) {
            f.setNormalBounds(null);
        }
        if (this.wasIcon(f)) {
            this.setWasIcon(f, null);
        }
        if (findNext) {
            this.activateNextFrame(c);
        }
    }

    public void maximizeFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        if (f.isIcon()) {
            try {
                f.setIcon(false);
            }
            catch (PropertyVetoException e2) {}
        } else {
            f.setNormalBounds(f.getBounds());
            Rectangle desktopBounds = f.getParent().getBounds();
            this.setBoundsForFrame(f, 0, 0, desktopBounds.width, desktopBounds.height);
        }
        try {
            f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void minimizeFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        if (f.isIcon()) {
            this.iconifyFrame(f);
            return;
        }
        if (f.getNormalBounds() != null) {
            Rectangle r = f.getNormalBounds();
            f.setNormalBounds(null);
            try {
                f.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setBoundsForFrame(f, r.x, r.y, r.width, r.height);
        }
    }

    public void iconifyFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        Container c = f.getParent();
        boolean findNext = f.isSelected();
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        if (!this.wasIcon(f)) {
            Rectangle r = this.getBoundsForIconOf(f);
            desktopIcon.setBounds(r.x, r.y, r.width, r.height);
            this.setWasIcon(f, Boolean.TRUE);
        }
        if (c == null) {
            return;
        }
        if (c instanceof JLayeredPane) {
            int layer = JLayeredPane.getLayer(f);
            JLayeredPane.putLayer(desktopIcon, layer);
        }
        if (!f.isMaximum()) {
            f.setNormalBounds(f.getBounds());
        }
        c.remove(f);
        c.add(desktopIcon);
        c.repaint(f.getX(), f.getY(), f.getWidth(), f.getHeight());
        try {
            f.setSelected(false);
        }
        catch (PropertyVetoException e2) {
            // empty catch block
        }
        if (findNext) {
            this.activateNextFrame(c);
        }
    }

    public void deiconifyFrame(JInternalFrame f) {
        if (f == null) {
            return;
        }
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        Container c = desktopIcon.getParent();
        if (c != null) {
            c.add(f);
            if (f.isMaximum()) {
                Rectangle desktopBounds = c.getBounds();
                if (f.getWidth() != desktopBounds.width || f.getHeight() != desktopBounds.height) {
                    this.setBoundsForFrame(f, 0, 0, desktopBounds.width, desktopBounds.height);
                }
            }
            this.removeIconFor(f);
            if (f.isSelected()) {
                f.moveToFront();
            } else {
                try {
                    f.setSelected(true);
                }
                catch (PropertyVetoException e2) {
                    // empty catch block
                }
            }
        }
    }

    public void activateFrame(JInternalFrame f) {
        JInternalFrame currentlyActiveFrame;
        if (f == null) {
            return;
        }
        Container p = f.getParent();
        JDesktopPane d = f.getDesktopPane();
        JInternalFrame jInternalFrame = currentlyActiveFrame = d == null ? null : d.getSelectedFrame();
        if (p == null && (p = f.getDesktopIcon().getParent()) == null) {
            return;
        }
        if (currentlyActiveFrame == null) {
            if (d != null) {
                d.setSelectedFrame(f);
            }
        } else if (currentlyActiveFrame != f) {
            if (currentlyActiveFrame.isSelected()) {
                try {
                    currentlyActiveFrame.setSelected(false);
                }
                catch (PropertyVetoException e2) {
                    // empty catch block
                }
            }
            d.setSelectedFrame(f);
        }
        f.moveToFront();
    }

    public void deactivateFrame(JInternalFrame f) {
        JInternalFrame currentlyActiveFrame;
        if (f == null) {
            return;
        }
        JDesktopPane d = f.getDesktopPane();
        JInternalFrame jInternalFrame = currentlyActiveFrame = d == null ? null : d.getSelectedFrame();
        if (currentlyActiveFrame == f) {
            d.setSelectedFrame(null);
        }
    }

    public void beginDraggingFrame(JComponent f) {
        this.setupDragMode(f);
    }

    public void dragFrame(JComponent f, int newX, int newY) {
        if (this.dragMode == 1) {
            JDesktopPane desktopPane = this.getDesktopPane(f);
            if (desktopPane != null) {
                Graphics g = desktopPane.getGraphics();
                g.setXORMode(Color.white);
                if (this.currentLoc != null) {
                    g.drawRect(this.currentLoc.x, this.currentLoc.y, f.getWidth() - 1, f.getHeight() - 1);
                }
                g.drawRect(newX, newY, f.getWidth() - 1, f.getHeight() - 1);
                this.currentLoc = new Point(newX, newY);
                g.dispose();
            }
        } else {
            this.setBoundsForFrame(f, newX, newY, f.getWidth(), f.getHeight());
        }
    }

    public void endDraggingFrame(JComponent f) {
        if (this.dragMode == 1 && this.currentLoc != null) {
            this.setBoundsForFrame(f, this.currentLoc.x, this.currentLoc.y, f.getWidth(), f.getHeight());
            this.currentLoc = null;
        }
    }

    public void beginResizingFrame(JComponent f, int direction) {
        this.setupDragMode(f);
    }

    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        if (this.dragMode == 0) {
            this.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
        } else {
            JDesktopPane desktopPane = this.getDesktopPane(f);
            if (desktopPane != null) {
                Graphics g = desktopPane.getGraphics();
                g.setXORMode(Color.white);
                if (this.currentBounds != null) {
                    g.drawRect(this.currentBounds.x, this.currentBounds.y, this.currentBounds.width - 1, this.currentBounds.height - 1);
                }
                g.drawRect(newX, newY, newWidth - 1, newHeight - 1);
                this.currentBounds = new Rectangle(newX, newY, newWidth, newHeight);
                g.setPaintMode();
                g.dispose();
            }
        }
    }

    public void endResizingFrame(JComponent f) {
        if (this.dragMode == 1 && this.currentBounds != null) {
            this.setBoundsForFrame(f, this.currentBounds.x, this.currentBounds.y, this.currentBounds.width, this.currentBounds.height);
            this.currentBounds = null;
        }
    }

    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        boolean didResize = f.getWidth() != newWidth || f.getHeight() != newHeight;
        f.setBounds(newX, newY, newWidth, newHeight);
        if (didResize) {
            f.validate();
        }
    }

    protected void activateNextFrame(Container c) {
        JInternalFrame nextFrame = null;
        if (c == null) {
            return;
        }
        for (int i = 0; i < c.getComponentCount(); ++i) {
            if (!(c.getComponent(i) instanceof JInternalFrame)) continue;
            nextFrame = (JInternalFrame)c.getComponent(i);
            break;
        }
        if (nextFrame != null) {
            try {
                nextFrame.setSelected(true);
            }
            catch (PropertyVetoException e2) {
                // empty catch block
            }
            nextFrame.moveToFront();
        }
    }

    protected void setupDragMode(JComponent f) {
        JDesktopPane p = this.getDesktopPane(f);
        if (p != null) {
            String mode = (String)p.getClientProperty("JDesktopPane.dragMode");
            this.dragMode = mode != null && mode.equals("outline") ? 1 : (mode != null && mode.equals("faster") && f instanceof JInternalFrame && f.isOpaque() ? 0 : (p.getDragMode() == 1 ? 1 : 0));
        }
    }

    protected void removeIconFor(JInternalFrame f) {
        JInternalFrame.JDesktopIcon di = f.getDesktopIcon();
        Container c = di.getParent();
        if (c != null) {
            c.remove(di);
            c.repaint(di.getX(), di.getY(), di.getWidth(), di.getHeight());
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame f) {
        JInternalFrame.JDesktopIcon icon = f.getDesktopIcon();
        Dimension prefSize = icon.getPreferredSize();
        Container c = f.getParent();
        if (c == null) {
            c = f.getDesktopIcon().getParent();
        }
        if (c == null) {
            return new Rectangle(0, 0, prefSize.width, prefSize.height);
        }
        Rectangle parentBounds = c.getBounds();
        Component[] components = c.getComponents();
        Rectangle availableRectangle = null;
        Component currentIcon = null;
        int x = 0;
        int y = parentBounds.height - prefSize.height;
        int w = prefSize.width;
        int h = prefSize.height;
        boolean found = false;
        while (!found) {
            availableRectangle = new Rectangle(x, y, w, h);
            found = true;
            for (Component component : components) {
                if (component instanceof JInternalFrame) {
                    currentIcon = ((JInternalFrame)component).getDesktopIcon();
                } else {
                    if (!(component instanceof JInternalFrame.JDesktopIcon)) continue;
                    currentIcon = (JInternalFrame.JDesktopIcon)component;
                }
                if (currentIcon.equals(icon) || !availableRectangle.intersects(currentIcon.getBounds())) continue;
                found = false;
                break;
            }
            if (currentIcon == null) {
                return availableRectangle;
            }
            if ((x += currentIcon.getBounds().width) + w <= parentBounds.width) continue;
            x = 0;
            y -= h;
        }
        return availableRectangle;
    }

    protected void setWasIcon(JInternalFrame f, Boolean value) {
        if (value != null) {
            f.putClientProperty(HAS_BEEN_ICONIFIED_PROPERTY, value);
        }
    }

    protected boolean wasIcon(JInternalFrame f) {
        return f.getClientProperty(HAS_BEEN_ICONIFIED_PROPERTY) == Boolean.TRUE;
    }

    JDesktopPane getDesktopPane(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }
}

