/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.content;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.ContentManagerUI;
import org.noos.xing.mydoggy.ContentManagerUIListener;
import org.noos.xing.mydoggy.ContentUI;
import org.noos.xing.mydoggy.MultiSplitConstraint;
import org.noos.xing.mydoggy.PersistenceDelegate;
import org.noos.xing.mydoggy.TabbedContentManagerUI;
import org.noos.xing.mydoggy.TabbedContentUI;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.plaf.MyDoggyToolWindowManager;
import org.noos.xing.mydoggy.plaf.support.UserPropertyChangeEvent;
import org.noos.xing.mydoggy.plaf.ui.DockableDescriptor;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentDialog;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentFrame;
import org.noos.xing.mydoggy.plaf.ui.cmp.ContentWindow;
import org.noos.xing.mydoggy.plaf.ui.cmp.TabbedContentPane;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneEvent;
import org.noos.xing.mydoggy.plaf.ui.cmp.event.TabbedContentPaneListener;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.content.MyDoggyTabbedContentUI;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContent;
import org.noos.xing.mydoggy.plaf.ui.content.PlafContentManagerUI;
import org.noos.xing.mydoggy.plaf.ui.content.action.NextContentAction;
import org.noos.xing.mydoggy.plaf.ui.content.action.PreviousContentAction;
import org.noos.xing.mydoggy.plaf.ui.drag.DragListenerAdapter;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.GraphicsUtil;
import org.noos.xing.mydoggy.plaf.ui.util.RemoveNotifyDragListener;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyDoggyTabbedContentManagerUI
extends MyDoggyContentManagerUI<TabbedContentUI>
implements TabbedContentManagerUI,
PlafContentManagerUI {
    protected TabbedContentPane tabbedContentPane;
    protected boolean showAlwaysTab;
    protected Component componentInFocusRequest = null;
    protected FocusOwnerPropertyChangeListener focusOwnerPropertyChangeListener;
    protected RemoveNotifyDragListener removeNotifyDragListener;

    public MyDoggyTabbedContentManagerUI() {
        this.setContentManagerUI(this);
        this.showAlwaysTab = false;
        this.initComponents();
    }

    @Override
    public void setTabPlacement(TabbedContentManagerUI.TabPlacement tabPlacement) {
        if (tabPlacement == null || tabPlacement == this.getTabPlacement()) {
            return;
        }
        TabbedContentManagerUI.TabPlacement old = this.getTabPlacement();
        this.tabbedContentPane.setTabPlacement(tabPlacement.ordinal() + 1);
        this.fireContentManagerUIProperty("tabPlacement", (Object)old, (Object)tabPlacement);
    }

    @Override
    public TabbedContentManagerUI.TabPlacement getTabPlacement() {
        switch (this.tabbedContentPane.getTabPlacement()) {
            case 1: {
                return TabbedContentManagerUI.TabPlacement.TOP;
            }
            case 2: {
                return TabbedContentManagerUI.TabPlacement.LEFT;
            }
            case 3: {
                return TabbedContentManagerUI.TabPlacement.BOTTOM;
            }
            case 4: {
                return TabbedContentManagerUI.TabPlacement.RIGHT;
            }
        }
        throw new IllegalStateException("Invalid Tab Placement...");
    }

    @Override
    public void setTabLayout(TabbedContentManagerUI.TabLayout tabLayout) {
        if (tabLayout == null || tabLayout == this.getTabLayout()) {
            return;
        }
        TabbedContentManagerUI.TabLayout old = this.getTabLayout();
        this.tabbedContentPane.setTabLayoutPolicy(tabLayout.ordinal());
        SwingUtil.repaint(this.tabbedContentPane);
        this.fireContentManagerUIProperty("tabLayout", (Object)old, (Object)tabLayout);
    }

    @Override
    public TabbedContentManagerUI.TabLayout getTabLayout() {
        switch (this.tabbedContentPane.getTabLayoutPolicy()) {
            case 0: {
                return TabbedContentManagerUI.TabLayout.WRAP;
            }
            case 1: {
                return TabbedContentManagerUI.TabLayout.SCROLL;
            }
        }
        throw new IllegalStateException("Invalid Tab Layout...");
    }

    @Override
    public boolean isShowAlwaysTab() {
        return this.showAlwaysTab;
    }

    @Override
    public void setShowAlwaysTab(boolean showAlwaysTab) {
        if (this.showAlwaysTab == showAlwaysTab) {
            return;
        }
        boolean old = this.showAlwaysTab;
        this.showAlwaysTab = showAlwaysTab;
        if (showAlwaysTab) {
            if (this.contentManager.getContentCount() == 1 && this.toolWindowManager.getMainContent() != this.tabbedContentPane && this.tabbedContentPane.getParent() == null) {
                this.valueAdjusting = true;
                this.addTab(this.contentManager.getContentByComponent(this.toolWindowManager.getMainContent()), new Object[0]);
                this.valueAdjusting = false;
                this.toolWindowManager.setMainContent(this.tabbedContentPane);
            }
        } else if (this.contentManager.getContentCount() == 1) {
            this.toolWindowManager.setMainContent(this.tabbedContentPane.getComponentAt(0));
        }
        this.fireContentManagerUIProperty("showAlwaysTab", old, showAlwaysTab);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlafContentManagerUI install(ContentManagerUI oldContentManagerUI, ToolWindowManager manager) {
        this.toolWindowManager = (MyDoggyToolWindowManager)manager;
        this.contentManager = manager.getContentManager();
        this.resourceManager = this.toolWindowManager.getResourceManager();
        this.tabbedContentPane.setToolWindowManager(this.toolWindowManager);
        if (oldContentManagerUI != null) {
            this.closeable = oldContentManagerUI.isCloseable();
            this.detachable = oldContentManagerUI.isDetachable();
            this.minimizable = oldContentManagerUI.isMinimizable();
        }
        this.setPopupMenu(this.contentManager.getPopupMenu());
        this.initListeners();
        this.lastSelected = null;
        this.previousLastSelected = null;
        Content selectedContent = null;
        this.contentValueAdjusting = true;
        try {
            for (Content content : this.contentManager.getContents()) {
                if (content.isSelected()) {
                    selectedContent = content;
                }
                this.addContent((PlafContent)content, new Object[0]);
            }
        }
        finally {
            this.contentValueAdjusting = false;
        }
        if (oldContentManagerUI != null && SwingUtil.getBoolean("ContentManagerUI.ContentManagerUiListener.import", false)) {
            for (ContentManagerUIListener listener : oldContentManagerUI.getContentManagerUiListener()) {
                oldContentManagerUI.removeContentManagerUIListener(listener);
                this.addContentManagerUIListener(listener);
            }
        }
        this.installed = true;
        if (oldContentManagerUI != null) {
            final Content selectedContent1 = selectedContent;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (selectedContent1 != null) {
                        selectedContent1.setSelected(true);
                    } else if (MyDoggyTabbedContentManagerUI.this.contentManager.getContentCount() > 0) {
                        MyDoggyTabbedContentManagerUI.this.contentManager.getContent(0).setSelected(true);
                    }
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        this.uninstalling = true;
        try {
            if (this.maximizedContent != null) {
                this.maximizedContent.setMaximized(false);
            }
            this.contentValueAdjusting = true;
            try {
                for (Content content : this.contentManager.getContents()) {
                    this.removeContent((PlafContent)content);
                }
            }
            finally {
                this.contentValueAdjusting = false;
            }
            this.removeListeners();
            this.installed = false;
        }
        finally {
            this.uninstalling = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setSelected(Content content, boolean selected) {
        if (selected) {
            if (this.lastSelected != null) {
                this.previousLastSelected = this.lastSelected;
                this.lastSelected.setSelected(false);
            }
            if (content.isMinimized()) {
                content.setMinimized(false);
                content.setSelected(true);
            } else if (content.isDetached()) {
                final Window window = SwingUtilities.windowForComponent(content.getComponent());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        window.toFront();
                        Component focusRequester = SwingUtil.findFocusable(window);
                        SwingUtil.requestFocus(focusRequester != null ? focusRequester : window);
                    }
                });
            } else {
                int index = this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    this.valueAdjusting = true;
                    try {
                        this.tabbedContentPane.setSelectedIndex(index);
                        if (!this.isFocusAncestor(content.getComponent())) {
                            this.componentInFocusRequest = this.findAndRequestFocus(this.tabbedContentPane.getComponentAt(index));
                        }
                        this.lastSelected = content;
                    }
                    finally {
                        this.valueAdjusting = false;
                    }
                } else {
                    if (this.isContentManagerEnabled() && this.toolWindowManager.getMainContent() != content.getComponent()) {
                        throw new IllegalStateException("Invalid content ui state.");
                    }
                    if (!this.isFocusAncestor(content.getComponent())) {
                        this.componentInFocusRequest = this.findAndRequestFocus(this.toolWindowManager.getMainContent());
                    }
                    this.lastSelected = content;
                }
            }
        } else if (content == this.lastSelected) {
            this.lastSelected = null;
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.tabbedContentPane.getComponentPopupMenu();
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.tabbedContentPane.setComponentPopupMenu(popupMenu);
    }

    @Override
    public void updateUI() {
        this.tabbedContentPane.updateUI();
    }

    @Override
    public void selectNextContent(Content content) {
        if (this.previousLastSelected != null && this.contentManager.getContent(this.previousLastSelected.getId()) != null) {
            this.previousLastSelected.setSelected(true);
            return;
        }
        if (this.tabbedContentPane.getTabCount() == 0) {
            this.toolWindowManager.resetMainContent();
            this.lastSelected = null;
            return;
        }
        if (this.tabbedContentPane.getTabCount() == 1 && !this.isShowAlwaysTab()) {
            Content lastContent = this.contentManager.getSelectedContent();
            if (lastContent != null) {
                if (lastContent == content) {
                    lastContent = this.contentManager.getNextContent();
                }
                this.toolWindowManager.setMainContent(lastContent.getComponent());
                lastContent.setSelected(true);
            }
            this.lastSelected = null;
        } else {
            int selectedIndex = this.tabbedContentPane.getSelectedIndex();
            if (selectedIndex != -1) {
                this.tabbedContentPane.getContentAt(selectedIndex).setSelected(true);
            } else {
                this.lastSelected = null;
            }
            if (this.tabbedContentPane.getTabCount() == 0) {
                this.toolWindowManager.resetMainContent();
            }
        }
    }

    protected void initComponents() {
        final TabbedContentPane tabbedContentPane = new TabbedContentPane(true);
        tabbedContentPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (!(MyDoggyTabbedContentManagerUI.this.valueAdjusting || MyDoggyTabbedContentManagerUI.this.contentValueAdjusting || tabbedContentPane.valueAdjusting)) {
                    int selectedIndex = tabbedContentPane.getSelectedIndex();
                    if (selectedIndex == -1) {
                        return;
                    }
                    Content newSelected = tabbedContentPane.getContentAt(selectedIndex);
                    if (newSelected == MyDoggyTabbedContentManagerUI.this.lastSelected) {
                        return;
                    }
                    if (newSelected != null && !newSelected.isMinimized()) {
                        newSelected.setSelected(true);
                    }
                    MyDoggyTabbedContentManagerUI.this.lastSelected = newSelected;
                }
            }
        });
        tabbedContentPane.addTabbedContentPaneListener(new TabbedContentPaneListener(){
            public ByteArrayOutputStream tmpWorkspace;

            public void tabbedContentPaneEventFired(TabbedContentPaneEvent event) {
                Content content = event.getContent();
                switch (event.getActionId()) {
                    case ON_CLOSE: {
                        if (!MyDoggyTabbedContentManagerUI.this.fireContentUIRemoving((ContentUI)MyDoggyTabbedContentManagerUI.this.getContentUI(content))) break;
                        MyDoggyTabbedContentManagerUI.this.contentManager.removeContent(content);
                        break;
                    }
                    case ON_DETACH: {
                        content.setDetached(true);
                        MyDoggyTabbedContentManagerUI.this.fireContentUIDetached((ContentUI)MyDoggyTabbedContentManagerUI.this.getContentUI(content));
                    }
                }
            }
        });
        this.tabbedContentPane = tabbedContentPane;
        this.setupActions();
    }

    protected void initListeners() {
        if (this.internalPropertyChangeSupport == null) {
            this.internalPropertyChangeSupport = new PropertyChangeSupport(this);
            this.internalPropertyChangeSupport.addPropertyChangeListener("component", new ComponentListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("disabledIcon", new DisabledIconListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("icon", new IconListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("mnemonic", new MnemonicListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("enabled", new EnabledListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("foreground", new ForegroundListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("title", new TitleListener());
            this.internalPropertyChangeSupport.addPropertyChangeListener("toolTipText", new ToolTipTextListener());
            DetachedListener detachedListener = new DetachedListener();
            this.internalPropertyChangeSupport.addPropertyChangeListener("detached.dispose", detachedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("detached", detachedListener);
            MaximizedListener maximizedListener = new MaximizedListener();
            this.internalPropertyChangeSupport.addPropertyChangeListener("maximizedBefore", maximizedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("maximized", maximizedListener);
            this.internalPropertyChangeSupport.addPropertyChangeListener("minimized", new MinimizedListener());
            this.contentUIListener = new MyDoggyContentManagerUI.ContentUIListener();
            this.removeNotifyDragListener = new RemoveNotifyDragListener(this.tabbedContentPane, new TabbedContentManagerDragListener());
            this.toolWindowManager.addRemoveNotifyListener(this.removeNotifyDragListener);
        }
        this.toolWindowManager.addInternalPropertyChangeListener("managerWindowAncestor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", MyDoggyTabbedContentManagerUI.this.focusOwnerPropertyChangeListener);
                }
            }
        });
        this.focusOwnerPropertyChangeListener = new FocusOwnerPropertyChangeListener();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusOwnerPropertyChangeListener);
    }

    protected void removeListeners() {
        this.removeNotifyDragListener.cleanup();
        this.toolWindowManager.removeRemoveNotifyListener(this.removeNotifyDragListener);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusOwnerPropertyChangeListener);
    }

    @Override
    protected Object addUIForContent(Content content, Object ... constaints) {
        TabbedContentUI contentUI = (TabbedContentUI)this.contentUIMap.get(content);
        if (contentUI == null) {
            contentUI = new MyDoggyTabbedContentUI(this, this.tabbedContentPane, content);
            contentUI.addPropertyChangeListener(this.contentUIListener);
            contentUI.setCloseable(this.closeable);
            contentUI.setDetachable(this.detachable);
            contentUI.setMinimizable(this.minimizable);
            this.contentUIMap.put(content, contentUI);
        }
        if (!this.showAlwaysTab && this.tabbedContentPane.getTabCount() == 0 && this.toolWindowManager.getMainContent() == null) {
            this.toolWindowManager.setMainContent(content.getComponent());
            return -1;
        }
        if (!this.showAlwaysTab && this.tabbedContentPane.getParent() == null) {
            this.valueAdjusting = true;
            this.addTab(this.contentManager.getContentByComponent(this.toolWindowManager.getMainContent()), new Object[0]);
            this.valueAdjusting = false;
        }
        int index = this.addTab(content, constaints);
        this.toolWindowManager.setMainContent(this.tabbedContentPane);
        if (!this.tabbedContentPane.isEnabledAt(this.tabbedContentPane.getSelectedIndex())) {
            this.tabbedContentPane.setSelectedIndex(this.tabbedContentPane.getTabCount() - 1);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeUIForContent(Content content) {
        int index = this.tabbedContentPane.indexOfContent(content);
        if (index != -1) {
            this.valueAdjusting = true;
            try {
                this.tabbedContentPane.removeTabAt(index);
            }
            finally {
                this.valueAdjusting = false;
            }
        } else if (this.toolWindowManager.getMainContent() != content.getComponent()) {
            throw new IllegalStateException("Invalid content ui state.");
        }
    }

    protected int addTab(Content content, Object ... constaints) {
        int index;
        if (constaints.length == 1 && constaints[0] instanceof Integer) {
            index = this.tabbedContentPane.addTab(content, content.getComponent(), (Integer)constaints[0]);
        } else {
            this.tabbedContentPane.addTab(content);
            index = this.tabbedContentPane.getTabCount() - 1;
        }
        this.tabbedContentPane.setDisabledIconAt(index, content.getDisabledIcon());
        int mnemonic = content.getMnemonic();
        if (mnemonic != -1) {
            this.tabbedContentPane.setMnemonicAt(index, mnemonic);
        }
        if (content.getForeground() != null) {
            this.tabbedContentPane.setForegroundAt(index, content.getForeground());
        }
        return index;
    }

    protected void setupActions() {
        SwingUtil.addKeyActionMapping(1, this.tabbedContentPane, KeyStroke.getKeyStroke(39, 8), "nextContent", new NextContentAction(this.toolWindowManager));
        SwingUtil.addKeyActionMapping(1, this.tabbedContentPane, KeyStroke.getKeyStroke(37, 8), "previousContent", new PreviousContentAction(this.toolWindowManager));
    }

    public class FocusOwnerPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            if (!MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled()) {
                return;
            }
            if (MyDoggyTabbedContentManagerUI.this.valueAdjusting) {
                return;
            }
            if (MyDoggyTabbedContentManagerUI.this.componentInFocusRequest != null) {
                if (evt.getNewValue() == MyDoggyTabbedContentManagerUI.this.componentInFocusRequest) {
                    MyDoggyTabbedContentManagerUI.this.componentInFocusRequest = null;
                } else {
                    return;
                }
            }
            if (evt.getNewValue() != null) {
                for (Component cursor = (Component)evt.getNewValue(); cursor != null; cursor = cursor.getParent()) {
                    int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfComponent(cursor);
                    if (index == -1) continue;
                    Content content = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getContentAt(index);
                    if (content.isSelected() || content.isDetached()) break;
                    content.setSelected(true);
                    break;
                }
            }
        }
    }

    public class TabbedContentManagerDragListener
    extends DragListenerAdapter {
        public TabbedContentManagerDragListener() {
            super(MyDoggyTabbedContentManagerUI.this.toolWindowManager);
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            super.dragGestureRecognized(dge);
            if (!this.acquireLocks()) {
                return;
            }
            Point origin = dge.getDragOrigin();
            int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexAtLocation(origin.x, origin.y);
            if (index != -1) {
                Content content = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getContentAt(index);
                if (content.getDockableDelegator() != null) {
                    dge.startDrag(DragSource.DefaultMoveDrop, new MyDoggyTransferable(this.manager, MyDoggyTransferable.CONTENT_ID_DF, content.getId()), this);
                    if (SwingUtil.getBoolean("drag.icon.useDefault", false)) {
                        this.setGhostImage(dge.getDragOrigin(), SwingUtil.getImage("mydoggy.image.drag"));
                    } else {
                        Component component = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getComponentAt(index);
                        BufferedImage ghostImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
                        component.print(ghostImage.getGraphics());
                        ghostImage = GraphicsUtil.scale(ghostImage, component.getWidth() / 4, component.getHeight() / 4);
                        this.setGhostImage(dge.getDragOrigin(), ghostImage);
                    }
                } else {
                    this.releaseLocks();
                }
            } else {
                this.releaseLocks();
            }
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            if (!this.checkStatus()) {
                return;
            }
            this.updateGhostImage(dsde.getLocation());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dragDropEnd(DragSourceDropEvent dsde) {
            try {
                if (!this.checkStatus()) {
                    return;
                }
                this.releaseLocks();
            }
            finally {
                this.cleanupGhostImage();
                this.dockableDropDragEnd();
            }
        }
    }

    public class MinimizedListener
    implements PropertyChangeListener {
        protected Map<Content, Integer> minimizedContentUIMap = new HashMap<Content, Integer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                content.setSelected(false);
                content.setMaximized(false);
                DockableDescriptor descriptor = MyDoggyTabbedContentManagerUI.this.toolWindowManager.getDockableDescriptor(content.getId());
                if (descriptor == null) {
                    descriptor = MyDoggyTabbedContentManagerUI.this.toolWindowManager.createDescriptor(content);
                }
                if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getTabCount() != 0) {
                    this.minimizedContentUIMap.put(content, MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content));
                } else {
                    this.minimizedContentUIMap.put(content, -1);
                }
                int tabIndex = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (tabIndex != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.removeTabAt(tabIndex);
                    if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getTabCount() == 0) {
                        MyDoggyTabbedContentManagerUI.this.toolWindowManager.resetMainContent();
                    }
                } else if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getParent() == null) {
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.resetMainContent();
                } else {
                    throw new IllegalStateException("Invalid Content : " + content);
                }
                descriptor.setAvailable(true);
            } else {
                DockableDescriptor descriptor = MyDoggyTabbedContentManagerUI.this.toolWindowManager.getDockableDescriptor(content.getId());
                descriptor.setAvailable(false);
                MyDoggyTabbedContentManagerUI.this.contentValueAdjusting = true;
                try {
                    MyDoggyTabbedContentManagerUI.this.addUIForContent(content, this.minimizedContentUIMap.get(content));
                    content.setSelected(true);
                    MyDoggyTabbedContentManagerUI.this.componentInFocusRequest = MyDoggyTabbedContentManagerUI.this.findAndRequestFocus(content.getComponent());
                }
                finally {
                    MyDoggyTabbedContentManagerUI.this.contentValueAdjusting = false;
                    this.minimizedContentUIMap.remove(content);
                }
            }
        }
    }

    public class DetachedListener
    implements PropertyChangeListener {
        protected PropertyChangeSupport contentUIListener;
        protected Map<Content, Integer> detachedContentUIMap = new HashMap<Content, Integer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if ("detached.dispose".equals(evt.getPropertyName())) {
                Window window = SwingUtilities.windowForComponent(content.getComponent());
                window.setVisible(false);
                window.dispose();
                this.detachedContentUIMap.remove(content);
            } else if (((Boolean)evt.getNewValue()).booleanValue()) {
                MyDoggyTabbedContentManagerUI.this.valueAdjusting = true;
                try {
                    if (evt instanceof UserPropertyChangeEvent) {
                        UserPropertyChangeEvent userEvent = (UserPropertyChangeEvent)evt;
                        MultiSplitConstraint constraint = (MultiSplitConstraint)userEvent.getUserObject();
                        block2 : switch (constraint.getOnIndex()) {
                            case -2: {
                                for (Window window : SwingUtil.getTopContainers()) {
                                    ContentWindow contentWindow;
                                    if (!(window instanceof ContentWindow) || !(contentWindow = (ContentWindow)((Object)window)).containsDockable(constraint.getOnContent())) continue;
                                    this.removeContent(content);
                                    contentWindow.addDockable(content, content.getComponent(), null, constraint.getOnPosition());
                                    break block2;
                                }
                            }
                            default: {
                                for (Window window : SwingUtil.getTopContainers()) {
                                    ContentWindow contentWindow;
                                    if (!(window instanceof ContentWindow) || !(contentWindow = (ContentWindow)((Object)window)).containsDockable(constraint.getOnContent())) continue;
                                    this.removeContent(content);
                                    contentWindow.addDockable(content, content.getComponent(), constraint.getOnContent(), constraint.getOnPosition());
                                    break block2;
                                }
                            }
                        }
                        {
                            break;
                        }
                    }
                    Object contentUI = MyDoggyTabbedContentManagerUI.this.getContentUI(content);
                    Rectangle inBounds = MyDoggyTabbedContentManagerUI.this.toolWindowManager.getBoundsToScreen(content.getComponent().getBounds(), content.getComponent().getParent());
                    this.removeContent(content);
                    Frame parentFrame = MyDoggyTabbedContentManagerUI.this.toolWindowManager.getWindowAncestor() instanceof Frame ? (Frame)MyDoggyTabbedContentManagerUI.this.toolWindowManager.getWindowAncestor() : null;
                    Window dialog = contentUI.isAddToTaskBarWhenDetached() ? new ContentFrame(content, (ContentUI)contentUI, parentFrame, inBounds) : new ContentDialog(content, (ContentUI)contentUI, parentFrame, inBounds);
                    dialog.addWindowFocusListener(new MyDoggyContentManagerUI.ContentDialogFocusListener(content));
                    dialog.toFront();
                    dialog.setVisible(true);
                    MyDoggyTabbedContentManagerUI.this.componentInFocusRequest = MyDoggyTabbedContentManagerUI.this.findAndRequestFocus(dialog);
                }
                finally {
                    MyDoggyTabbedContentManagerUI.this.valueAdjusting = false;
                }
            } else {
                ContentWindow window = (ContentWindow)((Object)SwingUtilities.windowForComponent(content.getComponent()));
                window.removeDockable(content);
                if (window.getDockableCount() <= 0) {
                    window.setVisible(false);
                    window.dispose();
                }
                MyDoggyTabbedContentManagerUI.this.contentValueAdjusting = true;
                try {
                    int index = 0;
                    Integer constraint = SwingUtil.getAt(evt, 0, null);
                    index = constraint != null ? ((Integer)MyDoggyTabbedContentManagerUI.this.addUIForContent(content, constraint)).intValue() : ((Integer)MyDoggyTabbedContentManagerUI.this.addUIForContent(content, this.detachedContentUIMap.get(content))).intValue();
                    if (index != -1) {
                        MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setSelectedIndex(index);
                        MyDoggyTabbedContentManagerUI.this.componentInFocusRequest = MyDoggyTabbedContentManagerUI.this.findAndRequestFocus(MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getComponentAt(index));
                    }
                }
                finally {
                    MyDoggyTabbedContentManagerUI.this.contentValueAdjusting = false;
                    this.detachedContentUIMap.remove(content);
                }
            }
        }

        protected void removeContent(Content content) {
            if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getTabCount() != 0) {
                this.detachedContentUIMap.put(content, MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content));
            } else {
                this.detachedContentUIMap.put(content, -1);
            }
            int tabIndex = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
            if (tabIndex != -1) {
                MyDoggyTabbedContentManagerUI.this.tabbedContentPane.removeTabAt(tabIndex);
                if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getTabCount() == 0) {
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.resetMainContent();
                }
            } else if (MyDoggyTabbedContentManagerUI.this.tabbedContentPane.getParent() == null) {
                MyDoggyTabbedContentManagerUI.this.toolWindowManager.resetMainContent();
            } else {
                throw new IllegalStateException("Invalid Content : " + content);
            }
        }
    }

    public class MaximizedListener
    implements PropertyChangeListener {
        protected ByteArrayOutputStream tmpWorkspace;
        protected Component oldFucusOwner;
        protected boolean valudAdj;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.valudAdj) {
                return;
            }
            Content content = (Content)evt.getSource();
            if ("maximizedBefore".equals(evt.getPropertyName())) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    if (this.tmpWorkspace != null) {
                        this.valudAdj = true;
                        try {
                            MyDoggyTabbedContentManagerUI.this.toolWindowManager.getPersistenceDelegate().merge(new ByteArrayInputStream(this.tmpWorkspace.toByteArray()), MyDoggyTabbedContentManagerUI.this.resourceManager.getObject(PersistenceDelegate.MergePolicy.class, PersistenceDelegate.MergePolicy.UNION));
                        }
                        finally {
                            this.valudAdj = false;
                        }
                        this.tmpWorkspace = null;
                    }
                    this.tmpWorkspace = new ByteArrayOutputStream();
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.getPersistenceDelegate().save(this.tmpWorkspace, new MyDoggyContentManagerUI.ContentManagerUIPersistenceDelegateFilter());
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.getToolWindowGroup().setVisible(false);
                    this.oldFucusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    MyDoggyTabbedContentManagerUI.this.maximizedContent = content;
                }
            } else if (!((Boolean)evt.getNewValue()).booleanValue() && this.tmpWorkspace != null) {
                this.valudAdj = true;
                try {
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.getPersistenceDelegate().merge(new ByteArrayInputStream(this.tmpWorkspace.toByteArray()), MyDoggyTabbedContentManagerUI.this.resourceManager.getObject(PersistenceDelegate.MergePolicy.class, PersistenceDelegate.MergePolicy.UNION));
                    this.tmpWorkspace = null;
                }
                finally {
                    this.valudAdj = false;
                }
                this.tmpWorkspace = null;
                MyDoggyTabbedContentManagerUI.this.maximizedContent = null;
                if (this.oldFucusOwner != null) {
                    SwingUtil.requestFocus(this.oldFucusOwner);
                    this.oldFucusOwner = null;
                }
            }
        }
    }

    public class ToolTipTextListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setToolTipTextAt(index, (String)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class TitleListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (content.isDetached()) {
                SwingUtil.setWindowTitle(content.getComponent(), (String)evt.getNewValue());
            } else {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setTitleAt(index, (String)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public class ForegroundListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setForegroundAt(index, (Color)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class EnabledListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (content.isDetached()) {
                Window ancestor = SwingUtilities.windowForComponent(content.getComponent());
                ancestor.setEnabled((Boolean)evt.getNewValue());
            } else {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setEnabledAt(index, (Boolean)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class MnemonicListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setMnemonicAt(index, (Integer)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class IconListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setIconAt(index, (Icon)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class DisabledIconListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            if (content.isMinimized()) {
                return;
            }
            if (!content.isDetached()) {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setDisabledIconAt(index, (Icon)evt.getNewValue());
                } else if (MyDoggyTabbedContentManagerUI.this.isContentManagerEnabled() && MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() != content.getComponent()) {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }

    public class ComponentListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            Content content = (Content)evt.getSource();
            Component oldCmp = (Component)evt.getOldValue();
            Component newCmp = (Component)evt.getNewValue();
            if (content.isMinimized()) {
                return;
            }
            if (content.isDetached()) {
                ContentWindow contentWindow = (ContentWindow)((Object)SwingUtilities.windowForComponent(content.getComponent()));
                contentWindow.setComponent(content, newCmp);
            } else {
                int index = MyDoggyTabbedContentManagerUI.this.tabbedContentPane.indexOfContent(content);
                if (index != -1) {
                    MyDoggyTabbedContentManagerUI.this.tabbedContentPane.setComponentAt(index, newCmp);
                } else if (MyDoggyTabbedContentManagerUI.this.toolWindowManager.getMainContent() == oldCmp) {
                    MyDoggyTabbedContentManagerUI.this.toolWindowManager.setMainContent(newCmp);
                } else {
                    throw new IllegalStateException("Invalid content ui state.");
                }
            }
        }
    }
}

