/*
 * Decompiled with CFR 0.152.
 */
package org.noos.xing.mydoggy.plaf.ui.drag;

import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.noos.xing.mydoggy.AggregationPosition;
import org.noos.xing.mydoggy.Content;
import org.noos.xing.mydoggy.Dockable;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowManager;
import org.noos.xing.mydoggy.ToolWindowTab;
import org.noos.xing.mydoggy.plaf.ui.cmp.border.LineBorder;
import org.noos.xing.mydoggy.plaf.ui.drag.MyDoggyTransferable;
import org.noos.xing.mydoggy.plaf.ui.util.SwingUtil;

public class ToolWindowCommonMultiSplitDropTarget
extends DropTarget {
    public ToolWindowCommonMultiSplitDropTarget(JComponent component, ToolWindowManager toolWindowManager) throws HeadlessException {
        super(component, 2, new ToolWindowDropTargetListener(component, toolWindowManager));
    }

    public static class ToolWindowDropTargetListener
    implements DropTargetListener,
    PropertyChangeListener {
        protected ToolWindowManager toolWindowManager;
        protected int anchorIndex;
        protected JComponent component;
        protected ToolWindow onToolWindow;
        protected ToolWindowAnchor dragAnchor;
        protected Border oldBorder;
        protected Border dragBorder = new LineBorder(Color.BLUE, 3);

        public ToolWindowDropTargetListener(JComponent component, ToolWindowManager toolWindowManager) {
            this.component = component;
            this.toolWindowManager = toolWindowManager;
            this.component.addPropertyChangeListener("dragAnchor", this);
            this.component.addPropertyChangeListener("dragToolWindow", this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("dragAnchor".equals(propertyName)) {
                this.dragAnchor = (ToolWindowAnchor)((Object)evt.getNewValue());
            } else {
                this.onToolWindow = null;
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.onToolWindow = null;
                dtde.acceptDrag(dtde.getDropAction());
                if (this.component.getBorder() != this.dragBorder) {
                    this.oldBorder = this.component.getBorder();
                }
                this.putProperty("dragStart");
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.checkEvent(dtde)) {
                return;
            }
            Point location = dtde.getLocation();
            this.component.putClientProperty("dragOver", location);
            Component deepestCmp = SwingUtilities.getDeepestComponentAt(this.component, location.x, location.y);
            if (deepestCmp != null) {
                JComponent toolWindowContainer = (JComponent)SwingUtil.getParent(deepestCmp, "toolWindow.container.");
                if (toolWindowContainer != null) {
                    this.onToolWindow = (ToolWindow)toolWindowContainer.getClientProperty(ToolWindow.class);
                    this.anchorIndex = this.onToolWindow.getAnchorIndex();
                }
            } else {
                this.onToolWindow = null;
                this.anchorIndex = -1;
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (this.checkEvent(dtde)) {
                this.dragEnter(dtde);
            }
        }

        public void dragExit(DropTargetEvent dte) {
            this.onToolWindow = null;
            this.oldBorder = null;
            this.putProperty("dragExit");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void drop(DropTargetDropEvent dtde) {
            try {
                block55: {
                    block56: {
                        if (dtde.getDropAction() != 2) break block55;
                        if (!dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF)) break block56;
                        try {
                            block57: {
                                Transferable transferable = dtde.getTransferable();
                                ToolWindow toolWindow = this.toolWindowManager.getToolWindow(dtde.getTransferable().getTransferData(MyDoggyTransferable.TOOL_WINDOW_ID_DF));
                                if (toolWindow == null) break block57;
                                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF)) {
                                    ToolWindowTab tab = (ToolWindowTab)this.toolWindowManager.lookupDockable(transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF));
                                    tab.getOwner().removeToolWindowTab(tab);
                                    toolWindow = (ToolWindow)tab.getDockableDelegator();
                                }
                                if (toolWindow == this.onToolWindow) {
                                    return;
                                }
                                boolean oldAggregateMode = toolWindow.isAggregateMode();
                                toolWindow.setAggregateMode(true);
                                try {
                                    block59: {
                                        block58: {
                                            if (this.dragAnchor == null) break block58;
                                            switch (this.dragAnchor) {
                                                case LEFT: {
                                                    if (this.onToolWindow != null) {
                                                        toolWindow.setAnchor(this.dragAnchor, this.anchorIndex != -1 ? this.anchorIndex - 1 : -1);
                                                        toolWindow.aggregate(this.onToolWindow, AggregationPosition.LEFT);
                                                        break;
                                                    }
                                                    if (this.checkCondition(toolWindow)) {
                                                        toolWindow.setAnchor(this.dragAnchor, 0);
                                                        toolWindow.aggregate(AggregationPosition.LEFT);
                                                        break;
                                                    }
                                                    break block59;
                                                }
                                                case RIGHT: {
                                                    if (this.onToolWindow != null) {
                                                        toolWindow.setAnchor(this.dragAnchor, this.anchorIndex != -1 ? this.anchorIndex + 1 : -1);
                                                        toolWindow.aggregate(this.onToolWindow, AggregationPosition.RIGHT);
                                                        break;
                                                    }
                                                    if (this.checkCondition(toolWindow)) {
                                                        toolWindow.setAnchor(this.dragAnchor);
                                                        toolWindow.aggregate(AggregationPosition.RIGHT);
                                                        break;
                                                    }
                                                    break block59;
                                                }
                                                case BOTTOM: {
                                                    if (this.onToolWindow != null) {
                                                        toolWindow.setAnchor(this.dragAnchor, this.anchorIndex != -1 ? this.anchorIndex + 1 : -1);
                                                        toolWindow.aggregate(this.onToolWindow, AggregationPosition.BOTTOM);
                                                        break;
                                                    }
                                                    if (this.checkCondition(toolWindow)) {
                                                        toolWindow.setAnchor(this.dragAnchor);
                                                        toolWindow.aggregate(AggregationPosition.BOTTOM);
                                                        break;
                                                    }
                                                    break block59;
                                                }
                                                case TOP: {
                                                    if (this.onToolWindow != null) {
                                                        toolWindow.setAnchor(this.dragAnchor, this.anchorIndex != -1 ? this.anchorIndex - 1 : -1);
                                                        toolWindow.aggregate(this.onToolWindow, AggregationPosition.TOP);
                                                        break;
                                                    }
                                                    if (this.checkCondition(toolWindow)) {
                                                        toolWindow.setAnchor(this.dragAnchor, 0);
                                                        toolWindow.aggregate(AggregationPosition.TOP);
                                                        break;
                                                    }
                                                    break block59;
                                                }
                                            }
                                            break block59;
                                        }
                                        if (this.onToolWindow != null && toolWindow != this.onToolWindow) {
                                            this.onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                        } else {
                                            toolWindow.aggregate();
                                        }
                                    }
                                    toolWindow.setActive(true);
                                }
                                finally {
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                }
                                dtde.dropComplete(true);
                                return;
                            }
                            dtde.dropComplete(false);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            dtde.dropComplete(false);
                            return;
                        }
                    }
                    if (!dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF)) {
                        dtde.rejectDrop();
                        return;
                    }
                    try {
                        Content content = this.toolWindowManager.getContentManager().getContent(dtde.getTransferable().getTransferData(MyDoggyTransferable.CONTENT_ID_DF));
                        if (content != null) {
                            this.toolWindowManager.getContentManager().removeContent(content);
                            if (content.getDockableDelegator() != null) {
                                Dockable delegator = content.getDockableDelegator();
                                if (!(delegator instanceof ToolWindow)) return;
                                ToolWindow toolWindow = (ToolWindow)delegator;
                                if (toolWindow == this.onToolWindow) {
                                    return;
                                }
                                boolean oldAggregateMode = toolWindow.isAggregateMode();
                                toolWindow.setAggregateMode(true);
                                try {
                                    toolWindow.setAnchor(this.dragAnchor, this.anchorIndex);
                                    if (this.dragAnchor != null) {
                                        switch (this.dragAnchor) {
                                            case LEFT: {
                                                if (this.onToolWindow != null) {
                                                    toolWindow.aggregate(this.onToolWindow, AggregationPosition.LEFT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.LEFT);
                                                break;
                                            }
                                            case RIGHT: {
                                                if (this.onToolWindow != null) {
                                                    toolWindow.aggregate(this.onToolWindow, AggregationPosition.RIGHT);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.RIGHT);
                                                break;
                                            }
                                            case BOTTOM: {
                                                if (this.onToolWindow != null) {
                                                    toolWindow.aggregate(this.onToolWindow, AggregationPosition.BOTTOM);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.BOTTOM);
                                                break;
                                            }
                                            case TOP: {
                                                if (this.onToolWindow != null) {
                                                    toolWindow.aggregate(this.onToolWindow, AggregationPosition.TOP);
                                                    break;
                                                }
                                                toolWindow.aggregate(AggregationPosition.TOP);
                                                break;
                                            }
                                        }
                                    } else if (this.onToolWindow != null) {
                                        this.onToolWindow.addToolWindowTab(toolWindow).setSelected(true);
                                    } else {
                                        toolWindow.aggregate();
                                    }
                                    toolWindow.setActive(true);
                                }
                                finally {
                                    toolWindow.setAggregateMode(oldAggregateMode);
                                }
                                dtde.dropComplete(true);
                                return;
                            }
                            dtde.dropComplete(false);
                            return;
                        }
                        dtde.dropComplete(false);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        dtde.dropComplete(false);
                        return;
                    }
                }
                dtde.rejectDrop();
                return;
            }
            finally {
                this.putProperty("dragEnd");
                this.dragExit(dtde);
            }
        }

        protected void putProperty(String name) {
            Boolean value = (Boolean)this.component.getClientProperty(name);
            if (value != null) {
                this.component.putClientProperty(name, value == false);
            } else {
                this.component.putClientProperty(name, false);
            }
        }

        protected boolean checkEvent(DropTargetDragEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            try {
                if (transferable.isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_MANAGER) && transferable.getTransferData(MyDoggyTransferable.TOOL_WINDOW_MANAGER).equals(System.identityHashCode(this.toolWindowManager)) && dtde.getDropAction() == 2 && (dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_ID_DF) || dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.TOOL_WINDOW_TAB_ID_DF) || dtde.getTransferable().isDataFlavorSupported(MyDoggyTransferable.CONTENT_ID_DF))) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        protected boolean checkCondition(ToolWindow toolWindow) {
            return true;
        }
    }
}

