/*
 * Decompiled with CFR 0.152.
 */
package citbach1_1;

import citbach1_1.ParameterModel;
import citbach1_1.ParameterValuePair;
import citbach1_1.ParameterValuePairComparator;
import citbach1_1.QuadList;
import citbach1_1.TupleTable;
import java.util.Arrays;

class QuadTable
extends TupleTable {
    QuadList[][][][] table;
    ParameterModel parametermodel;

    QuadTable(ParameterModel parametermodel) {
        this.parametermodel = parametermodel;
        int n = parametermodel.size;
        this.table = new QuadList[n][n][n][n];
        int p0 = 0;
        while (p0 < n - 3) {
            int p1 = p0 + 1;
            while (p1 < n - 2) {
                int p2 = p1 + 1;
                while (p2 < n - 1) {
                    int p3 = p2 + 1;
                    while (p3 < n) {
                        assert (p0 < p1 && p1 < p2 && p2 < p3);
                        this.table[p0][p1][p2][p3] = new QuadList(parametermodel.range[p0], parametermodel.range[p1], parametermodel.range[p2], parametermodel.range[p3]);
                        ++p3;
                    }
                    ++p2;
                }
                ++p1;
            }
            ++p0;
        }
    }

    boolean get(int p1, byte v1, int p2, byte v2, int p3, byte v3, int p4, byte v4) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3), new ParameterValuePair(p4, v4)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        return this.table[pv[0].p][pv[1].p][pv[2].p][pv[3].p].list[this.getOffset(pv)];
    }

    void set(int p1, byte v1, int p2, byte v2, int p3, byte v3, int p4, byte v4) {
        ParameterValuePair[] pv = new ParameterValuePair[]{new ParameterValuePair(p1, v1), new ParameterValuePair(p2, v2), new ParameterValuePair(p3, v3), new ParameterValuePair(p4, v4)};
        Arrays.sort(pv, new ParameterValuePairComparator());
        this.table[pv[0].p][pv[1].p][pv[2].p][pv[3].p].list[this.getOffset((ParameterValuePair[])pv)] = true;
    }

    private int getOffset(ParameterValuePair[] pv) {
        int offset = pv[0].v;
        int i = 1;
        while (i < pv.length) {
            int width = 1;
            int j = 0;
            while (j < i) {
                width *= this.parametermodel.range[pv[j].p];
                ++j;
            }
            offset += pv[i].v * width;
            ++i;
        }
        return offset;
    }
}

