/*
 * Decompiled with CFR 0.152.
 */
package jdd.bdd;

import jdd.bdd.CacheEntry;
import jdd.bdd.NodeTable;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.math.Digits;
import jdd.util.math.HashFunctions;

public final class Cache {
    private CacheEntry[] entries;
    private int cache_bits;
    private int cache_size;
    private int cache_mask;
    private long num_access;
    private long last_access;
    private int num_clears;
    private int num_partial_clears;
    private int members;
    private int num_grows;
    private int possible_bins_count;

    public final int getSize() {
        return this.cache_size;
    }

    public final void invalidate_cache(NodeTable nodeTable) {
        this.invalidate_cache(nodeTable, this.cache_size);
    }

    public final void invalidate_cache(NodeTable nodeTable, int n) {
        if (this.possible_bins_count == 0) {
            return;
        }
        ++this.num_partial_clears;
        int n2 = 0;
        if (this.members == 1) {
            int n3 = 0;
            while (n3 < n) {
                if (!this.entries[n3].invalid()) {
                    if (!nodeTable.isValid(this.entries[n3].op1) || nodeTable.isValid(this.entries[n3].ret)) {
                        this.entries[n3].clear();
                    } else {
                        ++n2;
                    }
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                if (!this.entries[n4].invalid()) {
                    if (!(nodeTable.isValid(this.entries[n4].op1) && nodeTable.isValid(this.entries[n4].op2) && nodeTable.isValid(this.entries[n4].ret))) {
                        this.entries[n4].clear();
                    } else {
                        ++n2;
                    }
                }
                ++n4;
            }
        }
        if (n2 == 0) {
            this.possible_bins_count = 0;
        }
    }

    public final void free_or_grow(NodeTable nodeTable) {
        if (this.num_grows < 3 && this.computeLoadFactor() > 95.0) {
            this.grow_and_invalidate_cache(nodeTable);
            return;
        }
        this.invalidate_cache(nodeTable, this.cache_size);
    }

    private final void grow_and_invalidate_cache(NodeTable nodeTable) {
        ++this.cache_bits;
        int n = 1 << this.cache_bits;
        this.cache_mask = n - 1;
        ++this.num_grows;
        CacheEntry[] cacheEntryArray = new CacheEntry[n];
        int n2 = 0;
        while (n2 < this.cache_size) {
            cacheEntryArray[n2] = this.entries[n2];
            ++n2;
        }
        this.invalidate_cache(nodeTable, this.cache_size);
        n2 = this.cache_size;
        while (n2 < n) {
            cacheEntryArray[n2] = new CacheEntry();
            ++n2;
        }
        this.cache_size = n;
        this.entries = cacheEntryArray;
    }

    public final void invalidate_cache() {
        if (this.possible_bins_count == 0) {
            return;
        }
        ++this.num_clears;
        int n = 0;
        while (n < this.cache_size) {
            this.entries[n].clear();
            ++n;
        }
        this.possible_bins_count = 0;
    }

    public final void free_or_grow() {
        if (this.num_grows < 3 && this.computeLoadFactor() > 95.0) {
            this.grow_and_invalidate_cache();
            return;
        }
        this.invalidate_cache();
    }

    private final void grow_and_invalidate_cache() {
        ++this.cache_bits;
        int n = 1 << this.cache_bits;
        this.cache_mask = n - 1;
        ++this.num_grows;
        CacheEntry[] cacheEntryArray = new CacheEntry[n];
        int n2 = 0;
        while (n2 < this.cache_size) {
            cacheEntryArray[n2] = this.entries[n2];
            cacheEntryArray[n2].clear();
            ++n2;
        }
        n2 = this.cache_size;
        while (n2 < n) {
            cacheEntryArray[n2] = new CacheEntry();
            ++n2;
        }
        this.cache_size = n;
        this.entries = cacheEntryArray;
    }

    private static final int pair(int n, int n2) {
        return (n + n2) * (n + n2 + 1) / 2 + n;
    }

    private final int hash1(int n) {
        return n & this.cache_mask;
    }

    private final int hash2(int n, int n2) {
        return HashFunctions.hash_prime(n, n2) & this.cache_mask;
    }

    private final int hash3(int n, int n2, int n3) {
        return HashFunctions.hash_prime(n, n2, n3) & this.cache_mask;
    }

    public final CacheEntry access3(int n, int n2, int n3) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[this.hash3(n, n2, n3)];
    }

    public final CacheEntry access2(int n, int n2) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[this.hash2(n, n2)];
    }

    public final CacheEntry access1(int n) {
        ++this.num_access;
        ++this.possible_bins_count;
        return this.entries[n & this.cache_mask];
    }

    private final void insert3(byte by, int n, int n2, int n3) {
        CacheEntry cacheEntry = this.access3(by, n, n2);
        cacheEntry.type = by;
        cacheEntry.op1 = n;
        cacheEntry.op2 = n2;
        cacheEntry.ret = n3;
    }

    private final void insert2(byte by, int n, int n2) {
        CacheEntry cacheEntry = this.access2(by, n);
        cacheEntry.type = by;
        cacheEntry.op1 = n;
        cacheEntry.ret = n2;
    }

    private final void insert1(int n, int n2) {
        CacheEntry cacheEntry = this.access1(n);
        cacheEntry.op1 = n;
        cacheEntry.ret = n2;
    }

    private final int lookup3(byte by, int n, int n2) {
        CacheEntry cacheEntry = this.access3(by, n, n2);
        return cacheEntry.op1 == n && cacheEntry.op2 == n2 && cacheEntry.type == by ? cacheEntry.ret : -1;
    }

    private final int lookup2(byte by, int n) {
        CacheEntry cacheEntry = this.access2(by, n);
        return cacheEntry.op1 == n && cacheEntry.type == by ? cacheEntry.ret : -1;
    }

    private final int lookup1(int n) {
        CacheEntry cacheEntry = this.access1(n);
        return cacheEntry.op1 == n ? cacheEntry.ret : -1;
    }

    public final double computeLoadFactor() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.cache_size) {
            if (!this.entries[n2].invalid()) {
                ++n;
            }
            ++n2;
        }
        return (double)(n * 10000 / this.cache_size) / 100.0;
    }

    public final double computeHitRate() {
        long l = 0L;
        int n = 0;
        while (n < this.cache_size) {
            l += (long)this.entries[n].found;
            ++n;
        }
        return (double)((int)(l * 10000L / this.num_access)) / 100.0;
    }

    public final void showStats(String string) {
        if (this.num_access != 0L) {
            JDDConsole.out.print(string + "-cache ");
            JDDConsole.out.print("ld=" + this.computeLoadFactor() + "% ");
            JDDConsole.out.print("sz=");
            Digits.printNumber(this.cache_size);
            JDDConsole.out.print("accs=");
            Digits.printNumber(this.num_access);
            JDDConsole.out.print("clrs=" + this.num_clears + '/' + this.num_partial_clears + ' ');
            JDDConsole.out.print("hitr=" + this.computeHitRate() + "% ");
            if (this.num_grows > 0) {
                JDDConsole.out.print("grws=" + this.num_grows + ' ');
            }
            this.showDeviation();
            JDDConsole.out.println();
        }
    }

    private final void showDeviation() {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.cache_size) {
            int n5 = this.entries[n4].found;
            if (n5 > 0) {
                ++n3;
            }
            d += (double)n5;
            d2 += (double)(n5 * n5);
            n = Math.max(this.entries[n4].overwrite, n);
            n2 = Math.min(this.entries[n4].overwrite, n2);
            ++n4;
        }
        double d3 = Math.sqrt((d2 /= (double)this.cache_size) - (d /= (double)this.cache_size) * d);
        double d4 = Math.sqrt((1.0 - 1.0 / (double)this.cache_size) * (double)this.num_access / (double)this.cache_size);
        JDDConsole.out.print("use/exp=" + 100 * n3 / this.cache_size + '/' + (int)(100.0 * (1.0 - Math.pow(Math.E, -d))) + '%');
    }

    public final void check_cache(int[] nArray) {
        int n = 0;
        while (n < this.cache_size) {
            if (!this.entries[n].invalid() && nArray[this.entries[n].ret] < 0) {
                JDDConsole.out.println("Invalied cache entry at position " + n);
                JDDConsole.out.println(n + " --> " + this.entries[n].op1 + '/' + this.entries[n].op2 + '/' + this.entries[n].ret + "  " + this.entries[n].type);
                System.exit(20);
            }
            ++n;
        }
    }

    final void show_cache() {
        int n = 0;
        while (n < this.cache_size) {
            if (!this.entries[n].invalid()) {
                switch (this.members) {
                    case 1: {
                        JDDConsole.out.println(n + " --> " + this.entries[n].op1 + '/' + this.entries[n].ret);
                        break;
                    }
                    case 2: {
                        JDDConsole.out.println(n + " --> " + this.entries[n].op1 + '/' + this.entries[n].ret + "  " + this.entries[n].type);
                        break;
                    }
                    case 3: {
                        JDDConsole.out.println(n + " --> " + this.entries[n].op1 + '/' + this.entries[n].op2 + '/' + this.entries[n].ret + "  " + this.entries[n].type);
                        break;
                    }
                }
            }
            ++n;
        }
    }

    public static final void internal_test() {
        Test.start("Cache");
        Cache cache = new Cache(200, 3);
        cache.insert3((byte)2, 1, 2, 3);
        boolean bl = false;
        if (cache.lookup3((byte)2, 1, 2) == 3) {
            bl = true;
        }
        Test.check(bl, "lookup 3");
        cache.insert3((byte)2, 1, 2, 5);
        boolean bl2 = false;
        if (cache.lookup3((byte)2, 1, 2) == 5) {
            bl2 = true;
        }
        Test.check(bl2, "lookup overwritten with 5");
        boolean bl3 = false;
        if (cache.lookup3((byte)1, 1, 2) == -1) {
            bl3 = true;
        }
        Test.check(bl3, "non-existing entry 1");
        boolean bl4 = false;
        if (cache.lookup3((byte)2, 2, 2) == -1) {
            bl4 = true;
        }
        Test.check(bl4, "non-existing entry 2");
        boolean bl5 = false;
        if (cache.lookup3((byte)2, 2, 1) == -1) {
            bl5 = true;
        }
        Test.check(bl5, "non-existing entry 3");
        cache = new Cache(200, 2);
        cache.insert2((byte)2, 1, 3);
        boolean bl6 = false;
        if (cache.lookup2((byte)2, 1) == 3) {
            bl6 = true;
        }
        Test.check(bl6, "lookup 3");
        cache.insert2((byte)2, 1, 5);
        boolean bl7 = false;
        if (cache.lookup2((byte)2, 1) == 5) {
            bl7 = true;
        }
        Test.check(bl7, "lookup overwritten with 5");
        boolean bl8 = false;
        if (cache.lookup2((byte)1, 1) == -1) {
            bl8 = true;
        }
        Test.check(bl8, "non-existing entry 1");
        boolean bl9 = false;
        if (cache.lookup2((byte)2, 2) == -1) {
            bl9 = true;
        }
        Test.check(bl9, "non-existing entry 2");
        cache = new Cache(200, 1);
        cache.insert1(1, 3);
        boolean bl10 = false;
        if (cache.lookup1(1) == 3) {
            bl10 = true;
        }
        Test.check(bl10, "lookup 3");
        cache.insert1(1, 5);
        boolean bl11 = false;
        if (cache.lookup1(1) == 5) {
            bl11 = true;
        }
        Test.check(bl11, "lookup overwritten with 5");
        boolean bl12 = false;
        if (cache.lookup1(2) == -1) {
            bl12 = true;
        }
        Test.check(bl12, "non-existing entry 1");
        boolean bl13 = false;
        if (cache.lookup1(3) == -1) {
            bl13 = true;
        }
        Test.check(bl13, "non-existing entry 2");
        Test.end();
    }

    public Cache(int n, int n2) {
        boolean bl = false;
        if (n2 >= 1) {
            bl = true;
        }
        Test.check(bl, "Cache members must be greater than 0");
        boolean bl2 = false;
        if (n2 <= 3) {
            bl2 = true;
        }
        Test.check(bl2, "Cache members must be less than 4");
        this.cache_bits = n < 32 ? 5 : Digits.closest_log2(n);
        this.cache_size = 1 << this.cache_bits;
        this.cache_mask = this.cache_size - 1;
        this.members = n2;
        this.num_grows = 0;
        this.num_access = 0L;
        this.last_access = 0L;
        this.possible_bins_count = 0;
        this.num_partial_clears = 0;
        this.num_clears = 0;
        this.entries = new CacheEntry[this.cache_size];
        int n3 = 0;
        while (n3 < this.cache_size) {
            this.entries[n3] = new CacheEntry();
            ++n3;
        }
    }
}

