/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import java.util.BitSet;
import jdd.util.JDDConsole;
import jdd.util.Test;

public class BitMatrix {
    private BitSet set;
    private int cols;
    private int rows;

    public BitSet getSet() {
        return this.set;
    }

    public void set(int n, int n2) {
        this.set.set(n2 + n * this.cols, true);
    }

    public void clear(int n, int n2) {
        this.set.clear(n2 + n * this.cols);
    }

    public void flip(int n, int n2) {
        this.set.flip(n2 + n * this.cols);
    }

    public boolean get(int n, int n2) {
        return this.set.get(n2 + n * this.cols);
    }

    public void clear() {
        this.set.clear();
    }

    public int sum() {
        return this.set.cardinality();
    }

    public void show() {
        int n = 0;
        while (n < this.rows) {
            int n2 = 0;
            while (n2 < this.cols) {
                if (n2 != 0) {
                    JDDConsole.out.print(" ");
                }
                JDDConsole.out.print(this.get(n, n2) ? "1" : "0");
                ++n2;
            }
            JDDConsole.out.println();
            ++n;
        }
    }

    public static void internal_test() {
        Test.start("BitMatrix");
        BitMatrix bitMatrix = new BitMatrix(3, 3);
        Test.checkEquality(bitMatrix.sum(), 0, "Matrix empty");
        Test.check(bitMatrix.get(1, 1) ^ true, "(1,1) = false");
        bitMatrix.set(1, 1);
        Test.checkEquality(bitMatrix.sum(), 1, "Matrix has 1 elemnt");
        Test.check(bitMatrix.get(1, 1), "(1,1) = true");
        bitMatrix.clear(1, 1);
        Test.checkEquality(bitMatrix.sum(), 0, "Matrix empty");
        Test.check(bitMatrix.get(1, 1) ^ true, "(1,1) = false (2)");
        bitMatrix.flip(2, 2);
        Test.check(bitMatrix.get(2, 2), "(2,2) = true");
        bitMatrix.flip(2, 2);
        Test.check(bitMatrix.get(2, 2) ^ true, "(2,2) = false");
        Test.end();
    }

    public BitMatrix(int n, int n2) {
        this.set = new BitSet(n * n2);
        this.rows = n;
        this.cols = n2;
    }
}

