/*
 * Decompiled with CFR 0.152.
 */
package jdd.util.math;

import jdd.util.JDDConsole;

public class Matrix {
    private double[] data;
    private int rows;
    private int cols;
    private int total;

    public int numOfCols() {
        return this.cols;
    }

    public int numOfRows() {
        return this.rows;
    }

    public double[] getRaw() {
        return this.data;
    }

    public double get(int n, int n2) {
        return this.data[n + n2 * this.cols];
    }

    public void set(int n, int n2, double d) {
        this.data[n + n2 * this.cols] = d;
    }

    public void setAll(double d) {
        int n = 0;
        while (n < this.total) {
            this.data[n] = d;
            ++n;
        }
    }

    public boolean equals(Matrix matrix) {
        if (matrix.rows != this.rows || matrix.cols != this.cols) {
            return false;
        }
        int n = 0;
        while (n < this.total) {
            if (matrix.data[n] != this.data[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void add(double d) {
        int n = 0;
        while (n < this.total) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    public void sub(double d) {
        int n = 0;
        while (n < this.total) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    public void add(Matrix matrix) {
        int n = 0;
        while (n < this.total) {
            int n2 = n;
            this.data[n2] = this.data[n2] + matrix.data[n];
            ++n;
        }
    }

    public void sub(Matrix matrix) {
        int n = 0;
        while (n < this.total) {
            int n2 = n;
            this.data[n2] = this.data[n2] - matrix.data[n];
            ++n;
        }
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix.cols != this.rows || matrix.rows != this.cols) {
            return null;
        }
        Matrix matrix2 = new Matrix(this.rows, this.cols);
        int n = 0;
        while (n < this.cols) {
            int n2 = 0;
            while (n2 < this.rows) {
                int n3 = n + n2 * this.cols;
                matrix2.data[n3] = 0.0;
                int n4 = 0;
                while (n4 < this.rows) {
                    int n5 = n3;
                    matrix2.data[n5] = matrix2.data[n5] + this.get(n, n4) * matrix.get(n4, n2);
                    ++n4;
                }
                ++n2;
            }
            ++n;
        }
        return matrix2;
    }

    public void show() {
        int n = 0;
        JDDConsole.out.println();
        int n2 = 0;
        while (n2 < this.rows) {
            int n3 = 0;
            while (n3 < this.cols) {
                if (n3 != 0) {
                    JDDConsole.out.print("\t");
                }
                JDDConsole.out.print("" + this.data[n++]);
                ++n3;
            }
            JDDConsole.out.println();
            ++n2;
        }
    }

    public Matrix(int n, int n2, double d) {
        this(n, n2);
        this.setAll(d);
    }

    public Matrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.total = n * n2;
        this.data = new double[this.total];
    }

    public Matrix(Matrix matrix) {
        this.rows = matrix.rows;
        this.cols = matrix.cols;
        this.total = matrix.total;
        this.data = new double[this.total];
        System.arraycopy(matrix.data, 0, this.data, 0, this.data.length);
    }
}

