/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.GraphXMLHandler;
import jdd.graph.Node;
import jdd.graph.WeightedGraph;
import jdd.util.BitStream;
import jdd.util.FileUtility;
import jdd.util.JDDConsole;
import jdd.util.Test;
import jdd.util.XMLHelper;
import org.xml.sax.helpers.DefaultHandler;

public class GraphIO {
    public static void saveEdgeList(Graph graph, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("# Generated by jdd.graph.GraphIO.saveEdgeList()");
            Enumeration enumeration = graph.getEdges().elements();
            while (enumeration.hasMoreElements()) {
                Edge edge = (Edge)enumeration.nextElement();
                printStream.println(edge.n1.getLabel() + "\t" + edge.n2.getLabel() + "\t" + edge.weight);
            }
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save graph to " + string + ":" + iOException);
        }
    }

    public static Graph loadEdgeList(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            WeightedGraph weightedGraph = new WeightedGraph();
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (string2 == null || string2.length() <= 0 || string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (string5 != null) {
                    double d = Double.parseDouble(string5);
                    Node node = (Node)hashMap.get(string3);
                    Node node2 = (Node)hashMap.get(string4);
                    if (node == null) {
                        node = weightedGraph.addNode();
                        node.setLabel(string3);
                        hashMap.put(string3, node);
                    }
                    if (node2 == null) {
                        node2 = weightedGraph.addNode();
                        node2.setLabel(string4);
                        hashMap.put(string4, node2);
                    }
                    weightedGraph.addEdge(node, node2, d);
                    continue;
                }
                JDDConsole.out.println("BAD line: '" + string2 + "'");
                bufferedReader.close();
                return null;
            }
            bufferedReader.close();
            return weightedGraph;
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to load graph from " + string + ":" + iOException);
            return null;
        }
    }

    public static void saveDIMACS(Graph graph, String string) {
        try {
            Object object;
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("c Generated by jdd.graph.GraphIO.saveDIMACS()");
            printStream.println("p edge " + graph.numOfNodes() + " " + graph.numOfEdges());
            int n = 0;
            Enumeration enumeration = graph.getNodes().elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                ((Node)object).extra1 = n++;
            }
            enumeration = graph.getEdges().elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                printStream.println("e " + (1 + ((Edge)object).n1.extra1) + " " + (1 + ((Edge)object).n2.extra1));
            }
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save graph to " + string + ":" + iOException);
        }
    }

    public static Graph loadDIMACS(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            Graph graph = new Graph(false);
            boolean bl = true;
            Node[] nodeArray = null;
            while (bufferedReader.ready()) {
                String string2 = bufferedReader.readLine();
                if (string2 == null || string2.length() <= 0 || string2.charAt(0) == 'c') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ");
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("p") && bl) {
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    int n = Integer.parseInt(string5);
                    nodeArray = new Node[n];
                    for (int i = 0; i < n; ++i) {
                        nodeArray[i] = graph.addNode();
                    }
                    bl = false;
                    continue;
                }
                if (string3.equals("v") && !bl) continue;
                if (string3.equals("e") && !bl) {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    int n2 = Integer.parseInt(stringTokenizer.nextToken());
                    graph.addEdge(nodeArray[n - 1], nodeArray[n2 - 1]);
                    continue;
                }
                JDDConsole.out.println("warning: ignoring line '" + string2 + "'");
            }
            bufferedReader.close();
            return graph;
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to load graph from " + string + ":" + iOException);
            return null;
        }
    }

    public static Graph loadBinaryDIMACS(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            Graph graph = new Graph(false);
            String string2 = bufferedReader.readLine();
            int n = Integer.parseInt(string2);
            while ((string2 = bufferedReader.readLine()).charAt(0) != 'p') {
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t ");
            Test.check(stringTokenizer.nextToken().equals("p"), "not DIAMCS format (need 'p ...')");
            Test.check(stringTokenizer.nextToken().equals("edge"), "not DIAMCS format (need 'p edge ...')");
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            Node[] nodeArray = new Node[n2];
            for (int i = 0; i < n2; ++i) {
                nodeArray[i] = graph.addNode();
            }
            bufferedReader.close();
            FileInputStream fileInputStream = new FileInputStream(string);
            while (((InputStream)fileInputStream).read() != 10) {
            }
            ((InputStream)fileInputStream).skip(n);
            BitStream bitStream = new BitStream(fileInputStream);
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!bitStream.next()) continue;
                    graph.addEdge(nodeArray[i], nodeArray[j]);
                }
                bitStream.next();
                bitStream.skipByte();
            }
            if (graph.numOfEdges() * 2 != n3) {
                JDDConsole.out.println("File '" + string + "'probably corrupted, expected " + n3 + " edges, found " + 2 * graph.numOfEdges());
            }
            return graph;
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to load graph from " + string + ":" + iOException);
            return null;
        }
    }

    public static void saveXML(Graph graph, String string) {
        try {
            Object object;
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            printStream.println("\t<graph directed=\"" + (graph.isDirected() ? 1 : 0) + "\">");
            printStream.println("\t\t<nodes>");
            Enumeration enumeration = graph.getNodes().elements();
            while (enumeration.hasMoreElements()) {
                object = (Node)enumeration.nextElement();
                printStream.print("\t\t\t<node id=\"" + ((Node)object).id + "\" label=\"" + ((Node)object).getLabel() + "\" flags=\"" + ((Node)object).flags + "\" ");
                printStream.println("/>");
            }
            printStream.println("\t\t</nodes>");
            printStream.println("\t\t<edges>");
            enumeration = graph.getEdges().elements();
            while (enumeration.hasMoreElements()) {
                object = (Edge)enumeration.nextElement();
                printStream.print("\t\t\t<edge from=\"" + ((Edge)object).n1.id + "\" to=\"" + ((Edge)object).n2.id + "\" " + " weight=\"" + ((Edge)object).weight + "\"" + " label=\"" + ((Edge)object).getLabel() + "\"" + " flags=\"" + ((Edge)object).flags + "\" ");
                printStream.println("/>");
            }
            printStream.println("\t\t</edges>");
            printStream.println("\t</graph>");
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("Unable to save graph to " + string + ":" + iOException);
        }
    }

    public static Graph loadXML(String string) {
        try {
            SAXParser sAXParser = XMLHelper.getParser();
            GraphXMLHandler graphXMLHandler = new GraphXMLHandler();
            sAXParser.parse(new File(string), (DefaultHandler)graphXMLHandler);
            return graphXMLHandler.g;
        }
        catch (Exception exception) {
            JDDConsole.out.println("Unable to load graph from " + string + ":" + exception);
            return null;
        }
    }

    public static void internal_test() {
        Test.start("GraphIO");
        Graph graph = GraphIO.loadEdgeList("data/c3.pcg");
        Test.checkEquality(graph.numOfNodes(), 53, "nodes in c3.pcg");
        Test.checkEquality(graph.numOfEdges(), 246, "edges in c3.pcg");
        GraphIO.saveDIMACS(graph, "data/c3.DIMACS");
        Graph graph2 = GraphIO.loadDIMACS("data/c3.DIMACS");
        Test.checkEquality(graph2.numOfNodes(), 53, "nodes in c3.DIMACS");
        Test.checkEquality(graph2.numOfEdges(), 246, "edges in c3.DIMACS");
        FileUtility.delete("data/c3.DIMACS");
        GraphIO.saveXML(graph2, "data/c3.xml");
        Graph graph3 = GraphIO.loadXML("data/c3.xml");
        Test.checkEquality(graph3.numOfNodes(), 53, "nodes in c3.xml");
        Test.checkEquality(graph3.numOfEdges(), 246, "edges in c3.xml");
        FileUtility.delete("data/c3.xml");
        Test.end();
    }
}

