/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.AttributeExplorer;
import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.GraphIO;
import jdd.graph.Node;
import jdd.graph.Partition;
import jdd.util.Test;

public class StronglyConnectedComponent {
    private static int num;
    private static int tos;
    private static Node[] stack;
    private static Partition partition;

    public static Partition tarjan(Graph graph, Node node) {
        AttributeExplorer.setAllNodesExtra1(graph, -1);
        num = 0;
        tos = 0;
        if (stack == null || stack.length < graph.numOfNodes()) {
            stack = new Node[graph.numOfNodes()];
        }
        Partition partition = StronglyConnectedComponent.partition = new Partition(graph);
        do {
            StronglyConnectedComponent.tarjan_visit(node);
        } while ((node = AttributeExplorer.findExtra1(graph, -1)) != null);
        StronglyConnectedComponent.partition = null;
        return partition;
    }

    private static int tarjan_visit(Node node) {
        Node node2;
        StronglyConnectedComponent.stack[StronglyConnectedComponent.tos++] = node;
        node.extra1 = num++;
        int n = node.extra1;
        Edge edge = node.firstOut;
        while (edge != null) {
            node2 = edge.n2;
            edge = edge.next;
            int n2 = node2.extra1 == -1 ? StronglyConnectedComponent.tarjan_visit(node2) : node2.extra1;
            if (n2 >= n) continue;
            n = n2;
        }
        if (n == node.extra1) {
            partition.newPartition();
            node2 = null;
            do {
                node2 = stack[--tos];
                node2.extra1 = Integer.MAX_VALUE;
                partition.addToPartition(node2);
            } while (node2 != node);
        }
        return n;
    }

    public static void internal_test() {
        Test.start("StronglyConnectedComponent");
        Graph graph = GraphIO.loadEdgeList("data/tarjan.pcg");
        Partition partition = StronglyConnectedComponent.tarjan(graph, graph.findNode("V1"));
        Test.checkEquality(partition.classes(), 4, "num of partitions");
        Test.check(!partition.inSamePartition(graph.findNode("V1"), graph.findNode("V2")));
        Test.check(!partition.inSamePartition(graph.findNode("V8"), graph.findNode("V2")));
        Test.check(partition.inSamePartition(graph.findNode("V7"), graph.findNode("V3")));
        Test.check(partition.inSamePartition(graph.findNode("V7"), graph.findNode("V5")));
        Test.check(partition.inSamePartition(graph.findNode("V4"), graph.findNode("V6")));
        Test.check(partition.inSamePartition(graph.findNode("V4"), graph.findNode("V3")));
        graph = GraphIO.loadEdgeList("data/nuutila.pcg");
        partition = StronglyConnectedComponent.tarjan(graph, graph.findNode("v1"));
        Test.checkEquality(partition.classes(), 7, "num of partitions (2)");
        Test.check(partition.inSamePartition(graph.findNode("v1"), graph.findNode("v2")));
        Test.check(partition.inSamePartition(graph.findNode("v8"), graph.findNode("v7")));
        Test.check(!partition.inSamePartition(graph.findNode("v13"), graph.findNode("v14")));
        Test.end();
    }

    static {
        stack = null;
        partition = null;
    }
}

