/*
 * Decompiled with CFR 0.152.
 */
package jdd.zdd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import jdd.bdd.NodeTable;
import jdd.util.Allocator;
import jdd.util.Dot;
import jdd.util.JDDConsole;
import jdd.util.NodeName;

public class ZDDPrinter {
    private static NodeTable nt;
    private static PrintStream ps;
    private static final int NODE_MASK = Integer.MAX_VALUE;
    private static final int DOT_MARK = Integer.MIN_VALUE;
    private static boolean had_0;
    private static boolean had_1;
    private static NodeName nn;
    private static char[] set_chars;
    private static int max;
    private static int count;

    private static void helpGC() {
        nt = null;
        ps = null;
        nn = null;
    }

    static void print(int n, NodeTable nodeTable, NodeName nodeName) {
        if (n == 0) {
            JDDConsole.out.println("0. " + nodeName.zero());
        } else if (n == 1) {
            JDDConsole.out.println("1. " + nodeName.one());
        } else {
            nt = nodeTable;
            nn = nodeName;
            ZDDPrinter.print_rec(n);
            nodeTable.unmark_tree(n);
            ZDDPrinter.helpGC();
            JDDConsole.out.println();
        }
    }

    private static void print_rec(int n) {
        if (n == 0 || n == 1) {
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        JDDConsole.out.println("" + n + ". " + nn.variable(nt.getVar(n)) + ": " + nt.getLow(n) + ", " + nt.getHigh(n));
        nt.mark_node(n);
        ZDDPrinter.print_rec(nt.getLow(n));
        if (nt.getLow(n) != nt.getHigh(n)) {
            ZDDPrinter.print_rec(nt.getHigh(n));
        }
    }

    static void printDot(String string, int n, NodeTable nodeTable, NodeName nodeName) {
        try {
            ps = new PrintStream(new FileOutputStream(string));
            ps.println("digraph G {");
            ps.println("\tcenter = true;");
            ps.println("\tnodesep = 0.05;");
            had_1 = false;
            had_0 = false;
            nt = nodeTable;
            nn = nodeName;
            ps.println("\tinit__ [label=\"\", style=invis, height=0, width=0];");
            ps.println("\tinit__ -> " + n + ";");
            ZDDPrinter.printDot_rec(n);
            if (had_0 && had_1) {
                ps.println("\t{ rank = same; 0; 1;}");
            }
            if (had_0) {
                ps.println("\t0 [shape=box, label=\"" + nodeName.zeroShort() + "\", style=filled, height=0.3, width=0.3];");
            }
            if (had_1) {
                ps.println("\t1 [shape=box, label=\"" + nodeName.oneShort() + "\", style=filled, height=0.3, width=0.3];\n");
            }
            ps.println("}\n");
            nodeTable.unmark_tree(n);
            ps.close();
            Dot.showDot(string);
            ZDDPrinter.helpGC();
        }
        catch (IOException iOException) {
            JDDConsole.out.println("ZDDPrinter.printDOT failed: " + iOException);
        }
    }

    private static void printDot_rec(int n) {
        if (n == 0) {
            had_0 = true;
            return;
        }
        if (n == 1) {
            had_1 = true;
            return;
        }
        if (nt.isNodeMarked(n)) {
            return;
        }
        int n2 = nt.getLow(n);
        int n3 = nt.getHigh(n);
        int n4 = nt.getVar(n);
        nt.mark_node(n);
        ps.println("\t" + n + "[label=\"" + nn.variable(n4) + "\"];");
        ps.println("\t" + n + "-> " + n2 + " [style=dotted];");
        ps.println("\t" + n + "-> " + n3 + " [style=filled];");
        ZDDPrinter.printDot_rec(n2);
        if (n2 != n3) {
            ZDDPrinter.printDot_rec(n3);
        }
    }

    static void printSet(int n, NodeTable nodeTable, NodeName nodeName) {
        if (n < 2) {
            if (nodeName != null) {
                JDDConsole.out.println(n == 0 ? nodeName.zero() : nodeName.one());
            } else {
                JDDConsole.out.println(n == 0 ? "empty" : "base");
            }
        } else {
            int n2 = 2 + nodeTable.getVar(n);
            if (set_chars == null || set_chars.length < n2) {
                set_chars = Allocator.allocateCharArray(n2);
            }
            count = 0;
            nn = nodeName;
            nt = nodeTable;
            JDDConsole.out.print("{ ");
            ZDDPrinter.printSet_rec(n, 0, nodeTable.getVar(n));
            JDDConsole.out.println(" }");
            ZDDPrinter.helpGC();
        }
    }

    private static void printSet_rec(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        if (n == 1 && n3 < 0) {
            if (count != 0) {
                JDDConsole.out.print(", ");
            }
            ++count;
            if (nn != null) {
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (set_chars[i] != '1') continue;
                    JDDConsole.out.print(nn.variable(n2 - i - 1));
                    ++n4;
                }
                if (n4 == 0) {
                    JDDConsole.out.print(nn.one());
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    JDDConsole.out.print(set_chars[i]);
                }
            }
            return;
        }
        if (nt.getVar(n) <= --n3) {
            ZDDPrinter.set_chars[n2] = 48;
            ZDDPrinter.printSet_rec(n, n2 + 1, n3);
            return;
        }
        ZDDPrinter.set_chars[n2] = 48;
        ZDDPrinter.printSet_rec(nt.getLow(n), n2 + 1, n3);
        ZDDPrinter.set_chars[n2] = 49;
        ZDDPrinter.printSet_rec(nt.getHigh(n), n2 + 1, n3);
    }

    static {
        set_chars = null;
    }
}

