/*
   Copyright 02/22/2015, 07/18/2016

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.
*/

#include "config.h" /* Auto-generated */
#include "include/headers.h"
#include "prototypes/options.h"

int main(int argc, char *argv[]) {
  char combined[WHOLE_MAIN_ARR_LEN];
  char *all = combined;

  if (-1 == (sysconf(_SC_CLK_TCK))) {
    FPRINTF("%s\n", "Error: sysconf() failed");
    return EXIT_FAILURE;
  }

  if (1 == argc) {
    parse_konf(all, NULL);
  }
  else if (3 == argc) {
    if (STREQ(argv[1], "--conf")) {
      parse_konf(all, argv[2]);
    }
    else {
      parse_opts(argc, argv, all);
    }
  }
  else {
    parse_opts(argc, argv, all);
  }

  if ('\0' != combined[0]) {
#if defined (HAVE_X11_XLIB_H) && WITH_DWM == 1
    set_status(combined);
#else
    fprintf(stdout, "%s\n", combined);
#endif /* HAVE_X11_XLIB_H && WITH_DWM */
  }

  return EXIT_SUCCESS;
}
