/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.app.ReqParser;
import jp.oarts.pirka.core.app.Tools;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.res.PirkaFileDownloader;
import jp.oarts.pirka.core.res.PirkaFileDownloaderFromBytes;
import jp.oarts.pirka.core.res.PirkaImageDownloader;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.FatalErrorDefaultWindow;
import jp.oarts.pirka.core.win.PirkaFatalErrorWindow;
import jp.oarts.pirka.core.win.PirkaWindow;
import jp.oarts.pirka.core.win.SessionTimeoutDefaultWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryPoint
extends HttpServlet
implements Serializable,
EntryPointIF {
    public static final String REQ_PIRKA_MARK = "__PIRKA__";
    public static final String REQ_LINK = "__PIRKA__LINK__";
    public static final String REQ_FORM = "__PIRKA__FORM__";
    public static final String REQ_IMAGE = "__PIRKA__IMG__";
    public static final String REQ_INSTANCE = "__PIRKA__INS__";
    public static final String REQ_SERIALNO = "__PIRKA__SNO__";
    private static final String SESSION_PIRKA_MARK = "__PIRKA__";
    private static final String SESSION_INSTANCE = "__PIRKA__INSTANCE__";
    private static final String SESSION_MAX_INSTANCE_NO = "__PIRKA__MAX_INSTANCE_NO__";
    private static final String SESSION_SERIALNO = "__PIRKA__SERIAL_NO__";
    private static final String SESSION_ERROR_FLAG = "__PIRKA__ERROR_FLAG__";
    static /* synthetic */ Class class$0;

    @Deprecated
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.serviceMain(req, res);
    }

    @Deprecated
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.serviceMain(req, res);
    }

    @Deprecated
    public void serviceMain(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block16: {
            try {
                boolean newSessionFlag = false;
                HttpSession session = req.getSession(false);
                if (session == null) {
                    newSessionFlag = true;
                    session = req.getSession(true);
                }
                PirkaThreadMap.setEntryPointObject(this);
                PirkaThreadMap.setServletPartam(req, res, session);
                PirkaRespons pirkaRespons = null;
                try {
                    HashMap<String, String[]> reqMap = new HashMap<String, String[]>();
                    ArrayList<Long> uploadFileList = new ArrayList<Long>();
                    ReqParser.parser(req, reqMap, uploadFileList);
                    try {
                        pirkaRespons = reqMap.containsKey(REQ_IMAGE) ? this.serviceMainImageProc(newSessionFlag, session, req, res, reqMap, uploadFileList) : (this.isOldServletMode() ? this.serviceMainOldServletProc(newSessionFlag, session, req, res, reqMap, uploadFileList) : this.serviceMainProc(newSessionFlag, session, req, res, reqMap, uploadFileList));
                    }
                    finally {
                        PirkaUploadManager.deleteFile(uploadFileList);
                    }
                }
                catch (Throwable e) {
                    pirkaRespons = this.getFatalErrorWindow();
                    if (pirkaRespons instanceof PirkaFatalErrorWindow) {
                        ((PirkaFatalErrorWindow)((Object)pirkaRespons)).setError(e);
                    }
                    this.setErrorFlag(PirkaThreadMap.getSession(), true);
                }
                if (pirkaRespons == null) break block16;
                pirkaRespons.remakeHeader(res);
                ServletOutputStream out = null;
                try {
                    out = res.getOutputStream();
                    if (pirkaRespons != null) {
                        pirkaRespons.writeRespons((OutputStream)out);
                        out.flush();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                PirkaThreadMap.removeEntryPointObject();
                PirkaThreadMap.removeServletParam();
            }
        }
    }

    @Deprecated
    protected PirkaRespons serviceMainImageProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        PirkaRespons respons = new PirkaFileDownloaderFromBytes("", new byte[0]);
        if (session != null) {
            String imageName = this.getSingleReqParam(reqMap, REQ_IMAGE);
            String instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
            if (imageName != null && instanceNo != null) {
                PirkaImage image;
                byte[] buffer;
                FieldItem fieldItem;
                String className;
                PirkaWindow window;
                String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                if (sessionSerialNo != null && reqSerialNo != null && reqSerialNo.equals(sessionSerialNo) && (window = this.getWindowObjectFromSession(session, instanceNo)) != null && (className = this.getClassNameFromSerialNo(reqSerialNo)) != null && className.equals(window.getClass().getName()) && (fieldItem = window.getRootFieldItem(imageName)) != null && fieldItem.getCtrl() != null && fieldItem.getCtrl().getImage() != null && (buffer = (image = fieldItem.getCtrl().getImage()).getImage()) != null) {
                    respons = new PirkaImageDownloader(image.getMimeType(), buffer);
                }
            }
        }
        return respons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected PirkaRespons serviceMainProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        HttpSession httpSession = session;
        synchronized (httpSession) {
            return this.serviceMainProcAsync(newSessionFlag, session, req, res, reqMap, uploadFileList);
        }
    }

    @Deprecated
    protected PirkaRespons serviceMainProcAsync(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        String instanceNo;
        PirkaRespons nextWindow;
        block34: {
            boolean initWindowFlag;
            boolean actionMethodNoCallFlag;
            block32: {
                block30: {
                    block33: {
                        block31: {
                            nextWindow = null;
                            instanceNo = "";
                            actionMethodNoCallFlag = false;
                            initWindowFlag = false;
                            if (!newSessionFlag) break block30;
                            if (!this.isErrorFlag(session)) break block31;
                            initWindowFlag = true;
                            break block32;
                        }
                        if (!reqMap.containsKey("__PIRKA__")) break block33;
                        nextWindow = this.getSessionTimeoutWindow();
                        this.setErrorFlag(session, true);
                        break block34;
                    }
                    initWindowFlag = true;
                    break block32;
                }
                if (this.isErrorFlag(session)) {
                    initWindowFlag = true;
                } else if (!reqMap.containsKey("__PIRKA__")) {
                    initWindowFlag = true;
                }
            }
            if (initWindowFlag) {
                session.invalidate();
                session = req.getSession(true);
                PirkaThreadMap.setServletPartam(req, res, session);
                instanceNo = "1";
                session.setAttribute(SESSION_MAX_INSTANCE_NO, (Object)1);
                this.setErrorFlag(session, false);
                nextWindow = this.getInitWindow(reqMap);
            } else {
                instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
                if (instanceNo == null) {
                    Integer newInstanceNo = (Integer)session.getAttribute(SESSION_MAX_INSTANCE_NO);
                    if (newInstanceNo == null || !(newInstanceNo instanceof Integer)) {
                        throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u6700\u5927\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    }
                    newInstanceNo = newInstanceNo + 1;
                    session.setAttribute(SESSION_MAX_INSTANCE_NO, (Object)newInstanceNo);
                    instanceNo = newInstanceNo.toString();
                    nextWindow = this.getSubWindow(reqMap);
                } else {
                    String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                    String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                    if (sessionSerialNo == null || reqSerialNo == null) {
                        nextWindow = this.getSessionTimeoutWindow();
                        this.setErrorFlag(session, true);
                    } else {
                        if (!reqSerialNo.equals(sessionSerialNo)) {
                            nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                            if (nextWindow == null) {
                                throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 ");
                            }
                            return nextWindow;
                        }
                        nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                        if (nextWindow == null) {
                            throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 ");
                        }
                        String className = this.getClassNameFromSerialNo(reqSerialNo);
                        if (className == null || !className.equals(nextWindow.getClass().getName())) {
                            throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3068\u30ea\u30af\u30a8\u30b9\u30c8\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u9055\u3044\u307e\u3059 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                        }
                        this.clearErrorFlag(((PirkaWindow)nextWindow).getRootFieldMap());
                        ((PirkaWindow)nextWindow).getErrorMessageStocker().clear();
                        String actionName = this.getActionName((PirkaWindow)nextWindow, reqMap);
                        FieldItem actionFieldItem = null;
                        if (actionName != null) {
                            actionFieldItem = ((PirkaWindow)nextWindow).getRootFieldItem(actionName);
                        }
                        if (actionFieldItem != null) {
                            this.setActionLoopIndex((PirkaWindow)nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
                        } else {
                            ((PirkaWindow)nextWindow).setActionLoopIndex(new int[0]);
                        }
                        String mark = this.getSingleReqParam(reqMap, "__PIRKA__");
                        PirkaWindow oldWindow = nextWindow;
                        if (REQ_FORM.equals(mark)) {
                            this.getReqValue(((PirkaWindow)nextWindow).getFieldMap(), reqMap);
                            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                            if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                                try {
                                    ((PirkaWindow)nextWindow).check();
                                }
                                catch (AutoCheckRuntimeException e) {
                                    actionMethodNoCallFlag = true;
                                }
                            }
                        } else {
                            nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                        }
                        if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
                            try {
                                nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
                            }
                            catch (AutoCheckRuntimeException e) {
                                // empty catch block
                            }
                        }
                        if (nextWindow == null) {
                            PirkaWindow returnWindow = oldWindow.getReturnWindow();
                            nextWindow = returnWindow != null ? returnWindow : oldWindow;
                        } else if (!(nextWindow instanceof PirkaFileDownloader) && nextWindow != oldWindow) {
                            ((PirkaWindow)nextWindow).setReturnWindow(oldWindow);
                            Class<?> nextWindowClass = nextWindow.getClass();
                            PirkaWindow tempWindow = (PirkaWindow)nextWindow;
                            while ((tempWindow = tempWindow.getReturnWindow()) != null) {
                                Class<?> tempWindowClass = tempWindow.getClass();
                                if (tempWindowClass != nextWindowClass) continue;
                                ((PirkaWindow)nextWindow).setReturnWindow(tempWindow.getReturnWindow());
                                break;
                            }
                        }
                    }
                }
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(((PirkaWindow)nextWindow).getFieldMap());
            ((PirkaWindow)nextWindow).fixField();
            String newSerialNo = this.createSerialNo((PirkaWindow)nextWindow);
            this.setSerialNoToSession(session, instanceNo, newSerialNo);
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo(instanceNo);
            ((PirkaWindow)nextWindow).setWindowBaseData(windowBaseData);
            this.setWindowObjectToSession(session, instanceNo, (PirkaWindow)nextWindow);
        }
        return nextWindow;
    }

    @Deprecated
    protected PirkaRespons serviceMainOldServletProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        PirkaRespons nextWindow = null;
        String instanceNo = "";
        boolean actionMethodNoCallFlag = false;
        boolean initWindowGlag = false;
        if (newSessionFlag) {
            initWindowGlag = true;
        }
        if (initWindowGlag) {
            session.invalidate();
            session = req.getSession(true);
            PirkaThreadMap.setServletPartam(req, res, session);
            instanceNo = "1";
            session.setAttribute(SESSION_MAX_INSTANCE_NO, (Object)1);
            nextWindow = this.getInitWindow(reqMap);
            this.sendRedirect(req, res, (PirkaWindow)nextWindow, instanceNo);
            return null;
        }
        instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
        if (instanceNo == null) {
            Integer newInstanceNo = (Integer)session.getAttribute(SESSION_MAX_INSTANCE_NO);
            if (newInstanceNo == null || !(newInstanceNo instanceof Integer)) {
                throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u6700\u5927\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            newInstanceNo = newInstanceNo + 1;
            session.setAttribute(SESSION_MAX_INSTANCE_NO, (Object)newInstanceNo);
            instanceNo = newInstanceNo.toString();
            nextWindow = this.getSubWindow(reqMap);
        } else {
            String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
            String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
            if (reqSerialNo == null) {
                nextWindow = this.getSessionTimeoutWindow();
                this.setErrorFlag(session, true);
            } else if (sessionSerialNo == null || !sessionSerialNo.equals(reqSerialNo)) {
                String className = this.getClassNameFromSerialNo(reqSerialNo);
                nextWindow = this.cleateWindowObject(className);
                if (nextWindow == null) {
                    throw new RuntimeException("\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 " + className);
                }
            } else {
                nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                if (nextWindow == null) {
                    throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                }
                String className = this.getClassNameFromSerialNo(reqSerialNo);
                if (className == null || !className.equals(nextWindow.getClass().getName())) {
                    throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3068\u30ea\u30af\u30a8\u30b9\u30c8\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u9055\u3044\u307e\u3059 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                }
                this.clearErrorFlag(nextWindow.getRootFieldMap());
                nextWindow.getErrorMessageStocker().clear();
                String actionName = this.getActionName((PirkaWindow)nextWindow, reqMap);
                FieldItem actionFieldItem = null;
                if (actionName != null) {
                    actionFieldItem = nextWindow.getRootFieldItem(actionName);
                }
                if (actionFieldItem != null) {
                    this.setActionLoopIndex((PirkaWindow)nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
                } else {
                    nextWindow.setActionLoopIndex(new int[0]);
                }
                String mark = this.getSingleReqParam(reqMap, "__PIRKA__");
                PirkaWindow oldWindow = nextWindow;
                if (REQ_FORM.equals(mark)) {
                    this.getReqValue(nextWindow.getFieldMap(), reqMap);
                    nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                    if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                        try {
                            nextWindow.check();
                        }
                        catch (AutoCheckRuntimeException e) {
                            actionMethodNoCallFlag = true;
                        }
                    }
                } else {
                    nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                }
                if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
                    try {
                        nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
                    }
                    catch (AutoCheckRuntimeException autoCheckRuntimeException) {
                        // empty catch block
                    }
                }
                if (nextWindow != oldWindow) {
                    if (nextWindow == null) {
                        nextWindow = oldWindow;
                    } else if (!(nextWindow instanceof PirkaFileDownloader)) {
                        this.sendRedirect(req, res, (PirkaWindow)nextWindow, instanceNo);
                        return null;
                    }
                }
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(nextWindow.getFieldMap());
            nextWindow.fixField();
            String newSerialNo = this.createSerialNo((PirkaWindow)nextWindow);
            this.setSerialNoToSession(session, instanceNo, newSerialNo);
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo(instanceNo);
            nextWindow.setWindowBaseData(windowBaseData);
            this.setWindowObjectToSession(session, instanceNo, (PirkaWindow)nextWindow);
        }
        return nextWindow;
    }

    private boolean isErrorFlag(HttpSession session) {
        Boolean ret = (Boolean)session.getAttribute(SESSION_ERROR_FLAG);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    private void setErrorFlag(HttpSession session, boolean errorFlag) {
        session.setAttribute(SESSION_ERROR_FLAG, (Object)errorFlag);
    }

    private void sendRedirect(HttpServletRequest req, HttpServletResponse res, PirkaWindow nextWindow, String instanceNo) throws IOException {
        String newSerialNo = this.createSerialNo(nextWindow);
        StringBuilder sb = new StringBuilder();
        sb.append(req.getRequestURL());
        sb.append('?');
        sb.append(REQ_INSTANCE);
        sb.append('=');
        sb.append(instanceNo);
        sb.append('&');
        sb.append(REQ_SERIALNO);
        sb.append('=');
        sb.append(newSerialNo);
        res.sendRedirect(sb.toString());
    }

    private void clearErrorFlag(Map<String, FieldItem> rootFieldMap) {
        for (String fieldName : rootFieldMap.keySet()) {
            rootFieldMap.get(fieldName).setErrorFlag(false);
        }
    }

    private void setActionLoopIndex(PirkaWindow window, String actionName, int loopDeepLevel) {
        int[] index = null;
        if (loopDeepLevel == 0) {
            index = new int[]{};
        } else {
            String[] deeps = actionName.split("\\$");
            index = new int[loopDeepLevel];
            int i = 0;
            while (i < index.length) {
                int ix = i + 1;
                if (ix <= deeps.length) {
                    try {
                        index[i] = Integer.parseInt(deeps[ix]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    index[i] = 0;
                }
                ++i;
            }
        }
        window.setActionLoopIndex(index);
    }

    private String getActionName(PirkaWindow window, Map<String, String[]> reqMap) {
        for (String name : reqMap.keySet()) {
            CtrlProcesser ctrlProcesser;
            HtmlCtrlParts ctrlParts;
            FieldItem fieldItem;
            int index = name.indexOf(46);
            if (index >= 0) {
                name = name.substring(0, index);
            }
            if ((fieldItem = window.getRootFieldItem(name)) == null || (ctrlParts = fieldItem.getCtrl()) == null || (ctrlProcesser = ctrlParts.getCtrlProcesser()) == null || !ctrlProcesser.isActionCtrl()) continue;
            return name;
        }
        return null;
    }

    private PirkaRespons callEventAction(PirkaWindow window, String name) {
        CtrlProcesser ctrlProcesser;
        HtmlCtrlParts ctrlParts;
        FieldItem fieldItem = window.getRootFieldItem(name);
        if (fieldItem != null && (ctrlParts = fieldItem.getCtrl()) != null && (ctrlProcesser = ctrlParts.getCtrlProcesser()) != null && ctrlProcesser.isActionCtrl()) {
            Method method = PirkaInfoPool.getMethod(window, ctrlParts.getBaseName());
            if (method == null) {
                return window;
            }
            try {
                if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)window, new Object[0]);
                    return window;
                }
                return (PirkaRespons)method.invoke((Object)window, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AutoCheckRuntimeException) {
                    throw (AutoCheckRuntimeException)e.getCause();
                }
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
        }
        return window;
    }

    private PirkaRespons callAction(PirkaWindow window, String name) {
        Method method = PirkaInfoPool.getMethod(window, name);
        if (method == null) {
            return window;
        }
        try {
            if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                method.invoke((Object)window, new Object[0]);
                return window;
            }
            return (PirkaRespons)method.invoke((Object)window, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AutoCheckRuntimeException) {
                throw (AutoCheckRuntimeException)e.getCause();
            }
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
    }

    private void getReqValue(FieldMap fieldMap, Map<String, String[]> reqMap) {
        this.getReqValueMain(fieldMap, reqMap, "");
    }

    private void getReqValueMain(FieldMap fieldMap, Map<String, String[]> reqMap, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            Object loop;
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            if (fieldItem.getCtrl().getCtrlProcesser().isInputCtrl()) {
                String reqFieldName = null;
                reqFieldName = fieldItem.getCtrl().getCtrlProcesser().isGroupItem() ? String.valueOf(fieldItem.getCtrl().getBaseName()) + this.changeSuffix(suffix, fieldItem.getCtrl().getGroupLevel()) : String.valueOf(fieldItem.getCtrl().getBaseName()) + suffix + fieldItem.getCtrl().getSuffixName();
                String[] values = reqMap.get(reqFieldName);
                fieldItem.getCtrl().getCtrlProcesser().setReq(reqMap, reqFieldName, fieldItem, values);
            } else if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && (loop = fieldItem.getValue()) != null && loop instanceof List) {
                List list = (List)loop;
                int index = 0;
                while (index < list.size()) {
                    this.getReqValueMain((FieldMap)list.get(index), reqMap, String.valueOf(suffix) + '$' + index);
                    ++index;
                }
            }
            ++n;
        }
    }

    private String changeSuffix(String suffix, int groupLevel) {
        if (groupLevel <= 0) {
            return suffix;
        }
        int index = suffix.length();
        int i = 0;
        while (i < groupLevel) {
            if ((index = suffix.lastIndexOf(36, index - 1)) <= 0) {
                return "";
            }
            ++i;
        }
        return suffix.substring(0, index);
    }

    private PirkaWindow getWindowObjectFromSession(HttpSession session, String InstanceNo) {
        return (PirkaWindow)session.getAttribute(SESSION_INSTANCE + InstanceNo);
    }

    private void setWindowObjectToSession(HttpSession session, String InstanceNo, PirkaWindow windowObject) {
        session.setAttribute(SESSION_INSTANCE + InstanceNo, (Object)windowObject);
    }

    private String getSingleReqParam(Map<String, String[]> map, String key) {
        String[] strings = map.get(key);
        if (strings == null || strings.length <= 0) {
            return null;
        }
        return strings[0];
    }

    private String createSerialNo(PirkaWindow windowObject) {
        return Tools.encodePsw(String.valueOf(windowObject.getClass().getName()) + "$" + System.currentTimeMillis());
    }

    private String getClassNameFromSerialNo(String serialNo) {
        if (serialNo == null) {
            return null;
        }
        String decodeSerialNo = Tools.decodePsw(serialNo);
        int index = decodeSerialNo.indexOf(36);
        if (index <= 0) {
            return null;
        }
        return decodeSerialNo.substring(0, index);
    }

    private void setSerialNoToSession(HttpSession session, String instanceNo, String serialNo) {
        HashMap<String, String> instanceMap = (HashMap<String, String>)session.getAttribute(SESSION_SERIALNO);
        if (instanceMap == null) {
            instanceMap = new HashMap<String, String>();
            session.setAttribute(SESSION_SERIALNO, instanceMap);
        }
        instanceMap.put(instanceNo, serialNo);
    }

    private String getSerialNoFromSession(HttpSession session, String instanceNo) {
        Map instanceMap = (Map)session.getAttribute(SESSION_SERIALNO);
        if (instanceMap == null) {
            return null;
        }
        return (String)instanceMap.get(instanceNo);
    }

    private PirkaWindow cleateWindowObject(String className) {
        PirkaWindow windowObject = null;
        try {
            Class<?> classObject = Class.forName(className);
            Object newObject = classObject.newInstance();
            if (newObject instanceof PirkaWindow) {
                windowObject = (PirkaWindow)newObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return windowObject;
    }

    private void changeLabelErrorFlag(FieldMap fieldMap) {
        this.changeLabelErrorFlagMain(fieldMap, fieldMap, "");
    }

    private void changeLabelErrorFlagMain(FieldMap baseFieldMap, FieldMap fieldMap, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            String forId = fieldItem.getCtrl().getOptionMap().get("for");
            if (forId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    forId = String.valueOf(forId) + suffix;
                }
                boolean errorFlag = this.isErrorId(baseFieldMap, forId);
                fieldItem.setErrorFlag(errorFlag);
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    this.changeLabelErrorFlagMain(baseFieldMap, childMap, String.valueOf(suffix) + '$' + index);
                    ++index;
                }
            }
            ++n;
        }
    }

    private boolean isErrorId(FieldMap baseFieldMap, String id) {
        return this.isErrorIdMain(baseFieldMap, id, "");
    }

    private boolean isErrorIdMain(FieldMap baseFieldMap, String id, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = baseFieldMap.getFieldNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fieldName = stringArray[n];
            FieldItem fieldItem = baseFieldMap.getFieldItem(fieldName);
            String targetId = fieldItem.getCtrl().getOptionMap().get("id");
            if (targetId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    targetId = String.valueOf(targetId) + suffix;
                }
                if (id.equals(targetId) && fieldItem.isErrorFlag()) {
                    return true;
                }
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    if (this.isErrorIdMain(childMap, id, String.valueOf(suffix) + '$' + index)) {
                        return true;
                    }
                    ++index;
                }
            }
            ++n;
        }
        return false;
    }

    @Override
    public void putSession(String keyName, Object object) {
        HttpSession session = PirkaThreadMap.getSession();
        if (session != null) {
            session.putValue(keyName, object);
        }
    }

    @Override
    public Object getSession(String keyName) {
        HttpSession session = PirkaThreadMap.getSession();
        if (session == null) {
            return null;
        }
        return session.getAttribute(keyName);
    }

    protected HttpServletRequest getHttpServletRequest() {
        return PirkaThreadMap.getServletReq();
    }

    protected HttpServletResponse getHttpServletResponse() {
        return PirkaThreadMap.getServletRes();
    }

    @Override
    public String getUrlAlias() {
        HttpServletRequest req = this.getHttpServletRequest();
        if (req != null) {
            return req.getRequestURI();
        }
        return this.getClass().getName();
    }

    protected abstract PirkaWindow getInitWindow(Map<String, String[]> var1);

    protected PirkaWindow getSubWindow(Map<String, String[]> reqMap) {
        return null;
    }

    protected PirkaWindow getSessionTimeoutWindow() {
        return new SessionTimeoutDefaultWindow();
    }

    protected PirkaWindow getFatalErrorWindow() {
        return new FatalErrorDefaultWindow();
    }

    @Override
    public boolean isOldServletMode() {
        return false;
    }

    @Override
    public Map<String, CtrlProcesser> getCtrlProcesserMap() {
        return null;
    }

    @Override
    public Class getPirkaMessageEnumClass() {
        return null;
    }

    @Override
    public String getResourceHtmlFileCharset() {
        return "MS932";
    }

    @Override
    public String getHtmlStringCharset() {
        return "MS932";
    }

    @Override
    public String getResponsHeaderCharset() {
        return "Shift-jis";
    }
}

