/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputImageProcesser
extends CtrlProcesser {
    @Override
    public boolean isUseChild() {
        return false;
    }

    @Override
    public boolean isLoop() {
        return false;
    }

    @Override
    public boolean isSwitch() {
        return false;
    }

    @Override
    public boolean isInputCtrl() {
        return false;
    }

    @Override
    public boolean isActionCtrl() {
        return true;
    }

    @Override
    public boolean isGroupItem() {
        return false;
    }

    @Override
    public boolean isCheckCtrl() {
        return false;
    }

    @Override
    public boolean isFormatCtrl() {
        return false;
    }

    @Override
    public void setValue(Object data, FieldItem fieldItem) {
        if (data == null || !(data instanceof String)) {
            throw new RuntimeException("\u6307\u5b9a\u3055\u308c\u305f\u5024\u306f\u30bb\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093 String\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u30bb\u30c3\u30c8\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        fieldItem.setValue((String)data);
    }

    @Override
    public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
    }

    @Override
    public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag) {
        StringBuilder sb = new StringBuilder();
        if (ctrl.getImage() == null) {
            sb.append('<');
            sb.append(ctrl.getTagName());
            sb.append(this.createOptionString(ctrl.getTypeOption(), String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, ctrl.getOptionMap(), ctrl.isSuffix()));
            sb.append(">");
        } else {
            sb.append('<');
            sb.append(ctrl.getTagName());
            sb.append(this.createOptionString(ctrl.getTypeOption(), String.valueOf(ctrl.getName()) + loopSuffix, loopSuffix, ctrl.getOptionMap(), windowBaseData, ctrl.isSuffix()));
            sb.append(">");
        }
        return sb.toString();
    }

    protected String createOptionString(String type, String name, String loopSuffix, Map<String, String> optionMap, boolean isSuffix) {
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(" type=\"");
            sb.append(type);
            sb.append("\"");
        }
        if (name != null && name.length() > 0) {
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
        }
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("name")) continue;
            this.addOption(sb, optionMap, key, isSuffix, loopSuffix);
        }
        return sb.toString();
    }

    protected String createOptionString(String type, String name, String loopSuffix, Map<String, String> optionMap, WindowBaseData windowBaseData, boolean isSuffix) {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        StringBuilder sb = new StringBuilder();
        if (type != null && type.length() > 0) {
            sb.append(" type=\"");
            sb.append(type);
            sb.append("\"");
        }
        if (name != null && name.length() > 0) {
            sb.append(" name=\"");
            sb.append(name);
            sb.append("\"");
        }
        sb.append(" src=\"");
        sb.append(entryPoint.getUrlAlias());
        sb.append('?');
        sb.append("__PIRKA__IMG__");
        sb.append('=');
        sb.append(name);
        sb.append('&');
        sb.append("__PIRKA__INS__");
        sb.append('=');
        sb.append(windowBaseData.getInstanceNo());
        sb.append('&');
        sb.append("__PIRKA__SNO__");
        sb.append('=');
        sb.append(windowBaseData.getSerialNo());
        sb.append("\"");
        for (String key : optionMap.keySet()) {
            if (key.equalsIgnoreCase("type") || key.equalsIgnoreCase("name") || key.equalsIgnoreCase("src")) continue;
            this.addOption(sb, optionMap, key, isSuffix, loopSuffix);
        }
        return sb.toString();
    }
}

