package jp.oarts.example.addressbook3.view;

import java.util.Arrays;
import java.util.HashMap;

import org.seasar.dao.NotSingleRowUpdatedRuntimeException;

import jp.oarts.example.addressbook3.dao.AddressDao;
import jp.oarts.example.addressbook3.dto.Address;
import jp.oarts.example.addressbook3.tools.S2;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * AhXꗗ
 */
public class AddressBookList extends PirkaWindow {
	
	/**
	 * f[^ێ
	 */
	private HashMap<Integer, Address> dataMap;
	
	/**
	 * RXgN^
	 */
	public AddressBookList() {
		dataMap = new HashMap<Integer, Address>();
	}
	
	/**
	 * `O
	 */
	public void preDraw() {
		AddressDao dao = (AddressDao)S2.getComponent(AddressDao.class);
		FieldMap map = getFieldMap();
		map.clearFieldMap("loop");
		Address[] list = dao.getList();
		renewDataMap(list);
		setBeanList(Arrays.asList(list), map, "loop");
	}
	
	/**
	 * ێf[^XVB
	 * @param list
	 */
	private void renewDataMap(Address[] list) {
		dataMap.clear();
		for (Address address : list) {
			dataMap.put(address.getId(), address);
		}
	}
	
	/**
	 * ǉ
	 * @return o^ҏW
	 */
	public PirkaWindow add() {
		return new NewAddressBook(null);
	}

	/**
	 * ҏW
	 * @return o^ҏW
	 */
	public PirkaWindow edit() {
		PirkaWindow result = null;
		FieldMap map = getFieldMap();
		for (int ii = 0; ii < map.getFieldMapSize("loop"); ii++) {
			FieldMap line = map.getFieldMap("loop", ii);
			if (line.getValueBoolean("checkbox")) {
				Address target = dataMap.get(line.getValueInt("id"));
				if (target != null) {
					result = new NewAddressBook(target);
					break;
				}
			}
		}
		return result;
	}

	/**
	 * 폜
	 */
	public void delete() {
		AddressDao dao = (AddressDao)S2.getComponent(AddressDao.class);
		FieldMap map = getFieldMap();
		for (int ii = 0; ii < map.getFieldMapSize("loop"); ii++) {
			FieldMap line = map.getFieldMap("loop", ii);
			if (line.getValueBoolean("checkbox")) {
				Address target = dataMap.get(line.getValueInt("id"));
				if (target != null) {
					try {
						dao.delete(target);
					} catch (NotSingleRowUpdatedRuntimeException ex) {
						// ȗ
					}
				}
			}
		}
	}

	/**
	 * ēǍ
	 */
	public void reload() {
		// preDrawōĕ`
	}

}
