package jp.oarts.pirka.sample;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import jp.oarts.pirka.sample.s01.Sample01;
import jp.oarts.pirka.sample.s02.Sample02;
import jp.oarts.pirka.sample.s03.Sample03;
import jp.oarts.pirka.sample.s04.Sample04;
import jp.oarts.pirka.sample.s05.Sample05;
import jp.oarts.pirka.sample.s06.Sample06;
import jp.oarts.pirka.sample.s07.Sample07;
import jp.oarts.pirka.sample.s08.Sample08;
import jp.oarts.pirka.sample.s09.Sample09;
import jp.oarts.pirka.sample.s10.Sample10;
import jp.oarts.pirka.sample.s11.Sample11;
import jp.oarts.pirka.sample.s12.SubWin01;
import jp.oarts.pirka.sample.s13.Ajax01;
import jp.oarts.pirka.sample.s14.Ajax02;

public class InstructionData implements Serializable {

	private static Map<Integer, InstructionData> InstructionDataMap;

	static {

		InstructionDataMap = new TreeMap<Integer, InstructionData>();

		InstructionDataMap.put(1001, new InstructionData( //
				"ƂJ^ȃTv", "", "point1001.txt", //
				Sample01.class, //
				new SourceData("Sample01.html", "/jp/oarts/pirka/sample/s01/Sample01.html", "TvʂHTMLt@C"), //
				new SourceData("Sample01.java", "/jp/oarts/pirka/sample/s01/Sample01.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1002, new InstructionData( //
				"AJ[ł̃Cxg", "", "point1002.txt", //
				Sample01.class, //
				new SourceData("Sample01.html", "/jp/oarts/pirka/sample/s01/Sample01.html", "TvʂHTMLt@C"), //
				new SourceData("Sample01.java", "/jp/oarts/pirka/sample/s01/Sample01.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1003, new InstructionData( //
				"Submit{^̃Cxg", "", "point1003.txt", //
				Sample01.class, //
				new SourceData("Sample01.html", "/jp/oarts/pirka/sample/s01/Sample01.html", "TvʂHTMLt@C"), //
				new SourceData("Sample01.java", "/jp/oarts/pirka/sample/s01/Sample01.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1004, new InstructionData( //
				"ϐ̕\", "", "point1004.txt", //
				Sample01.class, //
				new SourceData("Sample01.html", "/jp/oarts/pirka/sample/s01/Sample01.html", "TvʂHTMLt@C"), //
				new SourceData("Sample01.java", "/jp/oarts/pirka/sample/s01/Sample01.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1008, new InstructionData( //
				"URLύX@", "", "point1008.txt", //
				null, //
				new SourceData("ReverseLookupEntryPoint.java", "/jp/oarts/pirka/sample/ReverseLookupEntryPoint.src", "TvGg[|CgJava\[Xt@C"), //
				new SourceData("web.xml", "/jp/oarts/pirka/sample/web.xml", "TvGg[|Cgweb.xml") //
				));

		InstructionDataMap.put(1101, new InstructionData( //
				"eLXgGA̎g", "", "point1101.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1102, new InstructionData( //
				"eLXg͂̎g", "", "point1102.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1103, new InstructionData( //
				"pX[h̎g", "", "point1103.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1104, new InstructionData( //
				"WI{^̎g", "", "point1104.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1105, new InstructionData( //
				"`FbN{bNX̎g", "", "point1105.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1106, new InstructionData( //
				"ZNgj[^Xg{bNX̎g", "", "point1106.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1107, new InstructionData( //
				"getBean̎g", "", "point1107.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1108, new InstructionData( //
				"setBean̎g", "", "point1108.txt", //
				Sample02.class, //
				new SourceData("Sample02.html", "/jp/oarts/pirka/sample/s02/Sample02.html", "TvʂHTMLt@C"), //
				new SourceData("Sample02.java", "/jp/oarts/pirka/sample/s02/Sample02.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample02Bean.java", "/jp/oarts/pirka/sample/s02/Sample02Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1109, new InstructionData( //
				"[v̎g", "", "point1109.txt", //
				Sample03.class, //
				new SourceData("Sample03.html", "/jp/oarts/pirka/sample/s03/Sample03.html", "TvʂHTMLt@C"), //
				new SourceData("Sample03.java", "/jp/oarts/pirka/sample/s03/Sample03.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample03Bean.java", "/jp/oarts/pirka/sample/s03/Sample03Bean.src", "f[^o͗pBeanJava\[Xt@C") //
				));

		InstructionDataMap.put(1201, new InstructionData( //
				"\E\̎g", "", "point1201.txt", //
				Sample04.class, //
				new SourceData("Sample04.html", "/jp/oarts/pirka/sample/s04/Sample04.html", "TvʂHTMLt@C"), //
				new SourceData("Sample04.java", "/jp/oarts/pirka/sample/s04/Sample04.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1202, new InstructionData( //
				"EChEIuWFNg̍ėp@", "", "point1202.txt", //
				Sample05.class, //
				new SourceData("Sample05.html", "/jp/oarts/pirka/sample/s05/Sample05.html", "TvʂHTMLt@C"), //
				new SourceData("Sample05.java", "/jp/oarts/pirka/sample/s05/Sample05.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample05s2.html", "/jp/oarts/pirka/sample/s05/Sample05s2.html", "ʂHTMLt@C"), //
				new SourceData("Sample05s2.java", "/jp/oarts/pirka/sample/s05/Sample05s2.src", "ʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1210, new InstructionData( //
				"preDrawɂāiHTML쐬OCxgj", "", "point1210.txt", //
				Sample05.class, //
				new SourceData("Sample05.html", "/jp/oarts/pirka/sample/s05/Sample05.html", "TvʂHTMLt@C"), //
				new SourceData("Sample05.java", "/jp/oarts/pirka/sample/s05/Sample05.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample05s2.html", "/jp/oarts/pirka/sample/s05/Sample05s2.html", "ʂHTMLt@C"), //
				new SourceData("Sample05s2.java", "/jp/oarts/pirka/sample/s05/Sample05s2.src", "ʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1310, new InstructionData( //
				"Javascript\[X̓Io͕@", "", "point1310.txt", //
				Sample06.class, //
				new SourceData("Sample06.html", "/jp/oarts/pirka/sample/s06/Sample06.html", "TvʂHTMLt@C"), //
				new SourceData("Sample06.java", "/jp/oarts/pirka/sample/s06/Sample06.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1320, new InstructionData( //
				"IC[W̍", "", "point1320.txt", //
				Sample07.class, //
				new SourceData("Sample07.html", "/jp/oarts/pirka/sample/s07/Sample07.html", "TvʂHTMLt@C"), //
				new SourceData("Sample07.java", "/jp/oarts/pirka/sample/s07/Sample07.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1330, new InstructionData( //
				"t@C_E[hʂ̍", "", "point1330.txt", //
				Sample08.class, //
				new SourceData("Sample08.html", "/jp/oarts/pirka/sample/s08/Sample08.html", "TvʂHTMLt@C"), //
				new SourceData("Sample08.java", "/jp/oarts/pirka/sample/s08/Sample08.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1340, new InstructionData( //
				"t@CAbv[hʂ̍", "", "point1340.txt", //
				Sample09.class, //
				new SourceData("Sample09.html", "/jp/oarts/pirka/sample/s09/Sample09.html", "TvʂHTMLt@C"), //
				new SourceData("Sample09.java", "/jp/oarts/pirka/sample/s09/Sample09.src", "TvʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1400, new InstructionData( //
				"`FbN̎w@", "", "point1400.txt", //
				Sample10.class, //
				new SourceData("Sample10.html", "/jp/oarts/pirka/sample/s10/Sample10.html", "TvʂHTMLt@C"), //
				new SourceData("Sample10.java", "/jp/oarts/pirka/sample/s10/Sample10.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample10Ok.html", "/jp/oarts/pirka/sample/s10/Sample10Ok.html", "OKʂHTMLt@C"), //
				new SourceData("Sample10Ok.java", "/jp/oarts/pirka/sample/s10/Sample10Ok.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1401, new InstructionData( //
				"`FbÑXLbv@", "", "point1401.txt", //
				Sample10.class, //
				new SourceData("Sample10.html", "/jp/oarts/pirka/sample/s10/Sample10.html", "TvʂHTMLt@C"), //
				new SourceData("Sample10.java", "/jp/oarts/pirka/sample/s10/Sample10.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample10Ok.html", "/jp/oarts/pirka/sample/s10/Sample10Ok.html", "OKʂHTMLt@C"), //
				new SourceData("Sample10Ok.java", "/jp/oarts/pirka/sample/s10/Sample10Ok.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1402, new InstructionData( //
				"`FbN𐏎Ăяo@", "", "point1402.txt", //
				Sample10.class, //
				new SourceData("Sample10.html", "/jp/oarts/pirka/sample/s10/Sample10.html", "TvʂHTMLt@C"), //
				new SourceData("Sample10.java", "/jp/oarts/pirka/sample/s10/Sample10.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample10Ok.html", "/jp/oarts/pirka/sample/s10/Sample10Ok.html", "OKʂHTMLt@C"), //
				new SourceData("Sample10Ok.java", "/jp/oarts/pirka/sample/s10/Sample10Ok.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1403, new InstructionData( //
				"onPreɂāiʎOCxgj", "", "point1403.txt", //
				Sample10.class, //
				new SourceData("Sample10.html", "/jp/oarts/pirka/sample/s10/Sample10.html", "TvʂHTMLt@C"), //
				new SourceData("Sample10.java", "/jp/oarts/pirka/sample/s10/Sample10.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample10Ok.html", "/jp/oarts/pirka/sample/s10/Sample10Ok.html", "OKʂHTMLt@C"), //
				new SourceData("Sample10Ok.java", "/jp/oarts/pirka/sample/s10/Sample10Ok.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1404, new InstructionData( //
				"Javascriptsubmitł̃Cxg", "", "point1404.txt", //
				Sample10.class, //
				new SourceData("Sample10.html", "/jp/oarts/pirka/sample/s10/Sample10.html", "TvʂHTMLt@C"), //
				new SourceData("Sample10.java", "/jp/oarts/pirka/sample/s10/Sample10.src", "TvʂJava\[Xt@C"), //
				new SourceData("Sample10Ok.html", "/jp/oarts/pirka/sample/s10/Sample10Ok.html", "OKʂHTMLt@C"), //
				new SourceData("Sample10Ok.java", "/jp/oarts/pirka/sample/s10/Sample10Ok.src", "OKʂJava\[Xt@C") //
				));

		InstructionDataMap.put(1410, new InstructionData( //
				"d[ṽWI{^̎g", "", "point1410.txt", //
				Sample11.class, //
				new SourceData("Sample11.html", "/jp/oarts/pirka/sample/s11/Sample11.html", "TvʂHTMLt@C"), //
				new SourceData("Sample11.java", "/jp/oarts/pirka/sample/s11/Sample11.src", "TvʂJava\[Xt@C") //
				));
		
		InstructionDataMap.put(1500, new InstructionData( //
				"EChE̕\@", "", "point1500.txt", //
				SubWin01.class, //
				new SourceData("ReverseLookupEntryPoint.java", "/jp/oarts/pirka/sample/ReverseLookupEntryPoint.src", "Gg[|CgJava\[Xt@C"), //
				new SourceData("SubWin01.html", "/jp/oarts/pirka/sample/s12/SubWin01.html", "TvʂHTMLt@C"), //
				new SourceData("SubWin01.java", "/jp/oarts/pirka/sample/s12/SubWin01.src", "TvʂJava\[Xt@C"), //
				new SourceData("SubWin02.html", "/jp/oarts/pirka/sample/s12/SubWin02.html", "Tu A-1HTMLt@C"), //
				new SourceData("SubWin02.java", "/jp/oarts/pirka/sample/s12/SubWin02.src", "Tu A-1Java\[Xt@C"), //
				new SourceData("SubWin03.html", "/jp/oarts/pirka/sample/s12/SubWin03.html", "Tu BHTMLt@C"), //
				new SourceData("SubWin03.java", "/jp/oarts/pirka/sample/s12/SubWin03.src", "Tu BJava\[Xt@C"), //
				new SourceData("SubWin04.html", "/jp/oarts/pirka/sample/s12/SubWin04.html", "Tu A-2HTMLt@C"), //
				new SourceData("SubWin04.java", "/jp/oarts/pirka/sample/s12/SubWin04.src", "Tu A-2Java\[Xt@C"), //
				new SourceData("SubWin05.html", "/jp/oarts/pirka/sample/s12/SubWin05.html", "Tu A-3HTMLt@C"), //
				new SourceData("SubWin05.java", "/jp/oarts/pirka/sample/s12/SubWin05.src", "Tu A-3Java\[Xt@C") //
				));

		InstructionDataMap.put(1600, new InstructionData( //
				"AjaxgXV@", "", "point1600.txt", //
				Ajax01.class, //
				new SourceData("Ajax01.html", "/jp/oarts/pirka/sample/s13/Ajax01.html", "TvʂHTMLt@C"), //
				new SourceData("Ajax01.java", "/jp/oarts/pirka/sample/s13/Ajax01.src", "TvʂJava\[Xt@C"), //
				new SourceData("AjaxZipDB.java", "/jp/oarts/pirka/sample/s13/AjaxZipDB.src", "X֔ԍ}X^Java\[Xt@C") //
				));
		
		InstructionDataMap.put(1610, new InstructionData( //
				"Ajaxge[u̕XV@", "", "point1610.txt", //
				Ajax02.class, //
				new SourceData("Ajax02.html", "/jp/oarts/pirka/sample/s14/Ajax02.html", "TvʂHTMLt@C"), //
				new SourceData("Ajax02.java", "/jp/oarts/pirka/sample/s14/Ajax02.src", "TvʂJava\[Xt@C"), //
				new SourceData("AjaxZipDB.java", "/jp/oarts/pirka/sample/s13/AjaxZipDB.src", "X֔ԍ}X^Java\[Xt@C") //
				));

		InstructionDataMap.put(1700, new InstructionData( //
				"JUnitł̎eXg@", "", "point1700.txt", //
				null, //
				new SourceData("JUnitTestSample.java", "/jp/oarts/pirka/test/batch/JUnitTestSample.src", "JUnitJava\[Xt@C") //
				));

	}

	/**
	 * f[^̎擾
	 * @param no	ԍ
	 * @return	f[^		
	 */
	public static InstructionData getInstructionData(int no) {
		return InstructionDataMap.get(no);
	}

	/**
	 * f[^̃L[Zbg擾<BR>
	 * ̃Zbg͏Ƀ\[gĂ
	 * 
	 * @return		L[Zbg
	 */
	public static Set<Integer> getInstructionDataKeySet() {
		return InstructionDataMap.keySet();
	}

	/**	Tv	*/
	private String sampleName;

	/**	Tv	*/
	private String gaiyou;

	/**	|Cgt@C	*/
	private String pointFileName;

	/**	TvNXispj	*/
	private Class sampleClass;

	/**	\[XXg	*/
	private List<SourceData> sourceList;

	/**
	 * RXgN^
	 * 
	 * @param sampleName		Tv
	 * @param gaiyou			Tv
	 * @param pointFileName	|Cgt@C
	 * @param sampleClass		TvNXispj
	 * @param sourceData		\[XXg
	 */
	private InstructionData(String sampleName, String gaiyou, String pointFileName, Class sampleClass, SourceData... sourceData) {
		//		this.no = no;
		this.sampleName = sampleName;
		this.gaiyou = gaiyou;
		this.pointFileName = pointFileName;
		this.sampleClass = sampleClass;

		sourceList = new ArrayList<SourceData>();
		for (SourceData source : sourceData) {
			sourceList.add(source);
		}
	}

	/**
	 * @return gaiyou ߂܂B
	 */
	public String getGaiyou() {
		return gaiyou;
	}

	/**
	 * @param gaiyou ݒ肷 gaiyouB
	 */
	public void setGaiyou(String gaiyou) {
		this.gaiyou = gaiyou;
	}

	/**
	 * @return pointFileName ߂܂B
	 */
	public String getPointFileName() {
		return pointFileName;
	}

	/**
	 * @param pointFileName ݒ肷 pointFileNameB
	 */
	public void setPointFileName(String pointFileName) {
		this.pointFileName = pointFileName;
	}

	/**
	 * @return sampleClass ߂܂B
	 */
	public Class getSampleClass() {
		return sampleClass;
	}

	/**
	 * @param sampleClass ݒ肷 sampleClassB
	 */
	public void setSampleClass(Class sampleClass) {
		this.sampleClass = sampleClass;
	}

	/**
	 * @return sampleName ߂܂B
	 */
	public String getSampleName() {
		return sampleName;
	}

	/**
	 * @param sampleName ݒ肷 sampleNameB
	 */
	public void setSampleName(String sampleName) {
		this.sampleName = sampleName;
	}

	/**
	 * @return sourceList ߂܂B
	 */
	public List<SourceData> getSourceList() {
		return sourceList;
	}

	/**
	 * @param sourceList ݒ肷 sourceListB
	 */
	public void setSourceList(List<SourceData> sourceList) {
		this.sourceList = sourceList;
	}

}
