package jp.oarts.pirka.sample.s07;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import javax.imageio.ImageIO;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.win.PirkaWindow;

/**
 * pirka Tv bҁ@C[W
 */
public class Sample07 extends PirkaWindow {

	/**
	 * RXgN^
	 */
	public Sample07() {
		FieldMap field = getFieldMap();
		field.setImage("imageItem", new ImageSample(0));
	}

	/**
	 * `{^
	 */
	public void draw() {

		FieldMap field = getFieldMap();
		//	ۂ`悷񐔂擾
		int count = field.getValueInt("count");
		//	C[WIuWFNgo^
		field.setImage("imageItem", new ImageSample(count));

	}

	/**
	 * TṽC[WNX
	 */
	class ImageSample extends PirkaImage {

		/**	ۂ̕`	*/
		int count;

		/**
		 * RXgN^
		 * @param count	ۂ̕`
		 */
		public ImageSample(int count) {
			this.count = count;
		}

		@Override
		public byte[] getImage() throws IOException {
			int width = 400;
			int height = 400;

			BufferedImage img = new BufferedImage(width, height, BufferedImage.TYPE_3BYTE_BGR);
			ByteArrayOutputStream baos = null;
			Graphics2D g = null;
			try {
				g = (Graphics2D) img.createGraphics();
				paint(g, width, height, count);
				baos = new ByteArrayOutputStream();
				ImageIO.write(img, "png", baos);
				baos.flush();

			} finally {
				if (g != null) {
					g.dispose();
					g = null;
				}
				img = null;
				if (baos != null) {
					baos.close();
				}
			}
			return baos.toByteArray();

		}
		
		/**
		 * C[W`悵܂
		 * @param g2			OtBN2D
		 * @param width		
		 * @param height		c
		 * @param drawCount	̕`搔
		 */
		private void paint(Graphics2D g2, int width, int height, int drawCount) {

			int r = 20;
			g2.setColor(new Color(0, 0, 0));
			g2.fillRect(0, 0, width, height);

			for (int i = 0; i < drawCount; i++) {
				switch ((int) (4 * Math.random())) {
				case 0:
					g2.setColor(new Color(0xff, 0xc0, 0xc0));
					break;
				case 1:
					g2.setColor(new Color(0xc0, 0xff, 0xc0));
					break;
				case 2:
					g2.setColor(new Color(0xc0, 0xc0, 0xff));
					break;
				case 3:
					g2.setColor(new Color(0xf0, 0xf0, 0xf0));
					break;
				}

				int x = (int) ((width - r) * Math.random());
				int y = (int) ((height - r) * Math.random());
				g2.fillOval(x, y, r, r);
			}
		}

		@Override
		public String getMimeType() {
			return PirkaImage.MIME_TYPE_PNG;
		}
	}
	
	/**
	 * ߂郊N
	 * 
	 * @return
	 */
	public PirkaWindow returnWindow() {
		return null;
	}

}
