package jp.oarts.pirka.test.view;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.PirkaChecker;
import jp.oarts.pirka.core.util.check.PirkaCheckerLength;
import jp.oarts.pirka.core.util.check.PirkaCheckerString;
import jp.oarts.pirka.core.util.check.PirkaCheckerStringChars;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.converter.DataConverterDefined;
import jp.oarts.pirka.core.util.format.DateFieldFormat;
import jp.oarts.pirka.core.util.format.DateTimeFieldFormat;
import jp.oarts.pirka.core.util.format.NumericFieldFormat;
import jp.oarts.pirka.core.util.format.TimeFieldFormat;
import jp.oarts.pirka.core.win.PirkaWindow;

public class CtrlTest11 extends PirkaWindow {

	private static final Converter[] getConverter = new Converter[] { new Converter("item11", "ItemData11"), new Converter("item12", "ItemData12", DataConverterDefined.DATE),
			new Converter("item02", DataConverterDefined.DATE) };

	private static final Converter[] setConverter = new Converter[] { new Converter("item11", "item999") };

	public void execButton() {
		FieldMap field = getFieldMap();

		StringBuilder sb = new StringBuilder();
		Map<String, Object> dto = getDto(field.getValueBoolean("inputOnly"), getConverter);
		printDto(sb, dto, "");

		Map<String, Object> newDto = new HashMap<String, Object>();
		newDto.put("msg", sb.toString());
		setDto(newDto);
	}

	public void exec2Button() {
		FieldMap field = getFieldMap();

		Integer loopCount = field.getValueInt("item05");
		Map<String, Object> dto = new HashMap<String, Object>();
		if (loopCount != null) {
			List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
			long dateMilliSec = System.currentTimeMillis();
			for (int i = 0; i < loopCount; i++) {
				Map<String, Object> newDto = new HashMap<String, Object>();
				newDto.put("item999", i + 1);
				newDto.put("item12", new Date(dateMilliSec));
				dateMilliSec += 24 * 3600 * 1000L;
				newDto.put("item13", (i % 2) == 0 ? true : false);
				newDto.put("item14", "14-" + ((i % 2) + 1));
				newDto.put("item15", "" + ((i % 2) + 1));

				list.add(newDto);
			}
			dto.put("loop", list);
		} else {
			dto.put("loop", null);
		}
		dto.put("returnButton", "߂{^");
		setDto(dto, field.getValueBoolean("inputOnly"), setConverter);

		// t̃tH[}bgݒ
		for (int i = 0; i < field.getFieldMapSize("loop"); i++) {
			FieldMap loopFieldMap = field.getFieldMap("loop", i);
			loopFieldMap.setFormat("item12", new DateFieldFormat("yyyyNMMdd"));
		}
	}

	/** DTO̕\쐬 */
	private void printDto(StringBuilder sb, Map<String, Object> orgDto, String marge) {
		TreeMap<String, Object> dto = new TreeMap<String, Object>();
		dto.putAll(orgDto);
		for (String name : dto.keySet()) {
			Object value = dto.get(name);
			sb.append(marge);
			if (value == null) {
				sb.append(name);
				sb.append(" = ");
				sb.append("null");
			} else if (value instanceof List) {
				sb.append("loop\n");
				sb.append("\n");
				for (Map<String, Object> childDto : (List<Map<String, Object>>) value) {
					printDto(sb, childDto, marge + "  ");
					sb.append("\n");
				}
			} else if (value instanceof Boolean) {
				sb.append(name);
				sb.append(" = ");
				sb.append((Boolean) value ? "true" : "false");
			} else if (value instanceof Date) {
				sb.append(name);
				sb.append(" = ");
				sb.append((new SimpleDateFormat("yyyy/MM/dd")).format((Date) value));
			} else {
				sb.append(name);
				sb.append(" = \"");
				sb.append(value.toString());
				sb.append("\"");
			}
			sb.append("\n");
		}
	}

	public PirkaWindow returnButton() {
		return null;
	}
}
