package jp.oarts.pirka.core.ctrl.proc.def;

import java.util.List;
import java.util.Map;

import jp.oarts.pirka.core.ajax.AjaxScript;
import jp.oarts.pirka.core.analyzer.html.HtmlTools;
import jp.oarts.pirka.core.app.EntryPoint;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * SCRIPT^OvZbT[
 * 
 * @author ito
 * 
 */
public class ScriptProcesser extends CtrlProcesser {

	private static final String COMMON_AJAX_SCRIPT_KEY = "COMMON_AJAX_SCRIPT_KEY";

	private String commonAjaxScript //
	= "\tfunction createHttpRequest(){\n" //
			+ "\t\tif(window.ActiveXObject){\n" //
			+ "\t\t\ttry{\n" //
			+ "\t\t\t\treturn new ActiveXObject(\"Msxml2.XNLHTTP\")\n"//
			+ "\t\t\t}catch(e){\n" //
			+ "\t\t\t\ttry{\n" //
			+ "\t\t\t\t\treturn new ActiveXObject(\"Microsoft.XMLHTTP\")\n"//
			+ "\t\t\t\t}catch(e2){\n" //
			+ "\t\t\t\t\treturn null\n" //
			+ "\t\t\t\t}\n" //
			+ "\t\t\t}\n" //
			+ "\t\t}else if(window.XMLHttpRequest){\n" //
			+ "\t\t\treturn new XMLHttpRequest()\n" //
			+ "\t\t}else{\n" //
			+ "\t\t\treturn null;\n" //
			+ "\t\t}\n" //	
			+ "\t}\n" //
			+ "\n" //
			+ "\tfunction escapeUnicode(str) {\n" //
			+ "\t\treturn str.replace(/[^ -~]|[\\s@?/&%+\\\\]/g, function(m) {\n" //
			+ "\t\t\tvar cd = m.charCodeAt(0);\n" //
			+ "\t\t\t\treturn '\\\\u' + ((cd < 0x10)? '000' :\n" // 
			+ "\t\t\t\t\t\t\t\t(cd < 0x100)? '00' :\n" //
			+ "\t\t\t\t\t\t\t\t(cd < 0x1000)? '0' : '') + cd.toString(16);\n" //
			+ "\t\t});\n" //
			+ "\t}\n\n";


	/**
	 * HTMLp[cXg̎^O̎qp[c̃^O鎞trueԂ
	 * 
	 * @return true=qp[c̃^O
	 */
	@Override
	public boolean isUseChild() {
		return true;
	}

	/**
	 * [v^O̎tureԂ
	 * 
	 * @return true=[v^O
	 */
	@Override
	public boolean isLoop() {
		return false;
	}

	/**
	 * XCb`^O̎tureԂ
	 * 
	 * @return true=XCb`^O
	 */
	public boolean isSwitch() {
		return false;
	}

	/**
	 * uEUœ͂sȂ^ÔƂrtueԂ
	 * 
	 * @return true=uEUœ
	 */
	@Override
	public boolean isInputCtrl() {
		return false;
	}

	/**
	 * uEU[̃ANVƂtureԂ
	 * 
	 * @return true=ANV
	 */
	@Override
	public boolean isActionCtrl() {
		return false;
	}

	/**
	 * O[sOsȂ^OiWI{^Ȃǁj̊evf̎tureԂ
	 * 
	 * @return true=O[sOvf
	 */
	public boolean isGroupItem() {
		return false;
	}

	/**
	 * `FbNsȂRg[̎tureԂ
	 * 
	 * @return true=`FbNsȂRg[
	 */
	public boolean isCheckCtrl() {
		return false;
	}

	/**
	 * tH[}bg\ȃRg[̎tureԂ
	 * 
	 * @return true=tH[}bg\ȃRg[
	 */
	public boolean isFormatCtrl() {
		return false;
	}

	/**
	 * f[^̃ZbgsȂ
	 * 
	 * @param data
	 */
	public void setValue(Object data, FieldItem fieldItem) {
		if (data == null || !(data instanceof String)) {
			throw new RuntimeException("w肳ꂽl̓Zbgł܂ StringIuWFNgZbgĂ");
		}

		fieldItem.setValue((String) data);
	}

	/**
	 * l͂
	 * 
	 * @param ctrl
	 *            Rg[
	 * @param list
	 *            ̃^OHTMLp[c̃Xg
	 */
	@Override
	public void analyzeInitValue(HtmlCtrlParts ctrl, List<HtmlParts> list) {
		ctrl.setDefaultValue(HtmlTools.toSimpleString(list));
		ctrl.setWebSafe(false);
	}

	/**
	 * ^O쐬
	 * 
	 * @param ctrl
	 *            Rg[p[c
	 * @param loopSuffix
	 *            [vTtBbNX
	 * @param value
	 *            l
	 * @param checked
	 *            `FbNl
	 * @param windowBaseData
	 *            ʃf[^
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @param errorFlag
	 *            G[tO true=G[
	 * @param workMap
	 *            Ɨp}bv
	 * 
	 * @return 쐬ꂽ^O
	 */
	public String makeStartTag(HtmlCtrlParts ctrl, String loopSuffix, String value, boolean checked, WindowBaseData windowBaseData, //
			ErrorMessageManagerIF errorMessageManager, ErrorMessageStocker errorMessageStocker, boolean errorFlag, Map<String, Object> workMap) {

		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		StringBuilder sb = new StringBuilder();

		sb.append('<');
		sb.append(ctrl.getTagName());
		sb.append(createOptionString(ctrl.getTypeOption(), ctrl.getName() + loopSuffix, loopSuffix, null, ctrl.isSuffix(), ctrl.getOptionMap()));
		sb.append(">");

		if (ctrl.getAjaxScript() == null) {
			sb.append(value);
		} else {
			AjaxScript ajaxScript = ctrl.getAjaxScript();
			sb.append("\n\t<!--\n");
			if (!workMap.containsKey(COMMON_AJAX_SCRIPT_KEY)) {
				workMap.put(COMMON_AJAX_SCRIPT_KEY, COMMON_AJAX_SCRIPT_KEY);
				sb.append(commonAjaxScript);
			}
			sb.append("\tfunction ");
			sb.append(ctrl.getName());
			sb.append("(asyncFlag, data){\n");

			sb.append(ajaxScript.getPreScript());

			sb.append("\t\tvar sendData=\"");
			sb.append(EntryPoint.REQ_PIRKA_MARK);
			sb.append('=');
			sb.append(EntryPoint.REQ_AJAX);
			sb.append('&');
			sb.append(EntryPoint.REQ_AJAX);
			sb.append('=');
			sb.append(ctrl.getName());
			sb.append('&');
			sb.append(EntryPoint.REQ_INSTANCE);
			sb.append('=');
			sb.append(windowBaseData.getInstanceNo());
			sb.append('&');
			sb.append(EntryPoint.REQ_SERIALNO);
			sb.append('=');
			sb.append("\"+");
			
			sb.append("escapeUnicode(\"");
			sb.append(windowBaseData.getSerialNo());
			sb.append("\");\n");

			sb.append("\t\tfor(var key in data){\n");
			sb.append("\t\t\tsendData = sendData + \"&\" + escapeUnicode(key) + \"=\" + escapeUnicode(data[key]);\n");
			sb.append("\t\t}\n");

			sb.append("\t\tvar httpobj= createHttpRequest();\n");

			

			sb.append("\t\thttpobj.open(\"POST\", \"");
			sb.append(entryPoint.getUrlAlias());
			sb.append("\", ");
			//sb.append(ajaxScript.isAsync());
			sb.append("asyncFlag");
			sb.append(");\n");
			sb.append("\t\thttpobj.setRequestHeader(\"Content-Type\" , \"application/x-www-form-urlencoded\");\n");
			sb.append("\t\thttpobj.onreadystatechange=function(){\n");

			//sb.append("alert('res='+httpobj.responseText);\n");			
			
			sb.append("\t\t\tif(httpobj.readyState==4){\n");
			sb.append("\t\t\t\tif(httpobj.status == 200 && httpobj.responseText!=''){\n");
			sb.append("\t\t\tvar response = eval('(' + httpobj.responseText + ')');\n");
			sb.append(ajaxScript.getResScript());
			sb.append("\t\t\t\t}else{\n");
			sb.append(ajaxScript.getErrScript());
			sb.append("\t\t\t}\n");
			sb.append("\t\t\t}\n");
			sb.append("\t\t};\n");

			sb.append("\t\thttpobj.send(sendData);\n");
			sb.append("\t}\n");

			sb.append("\t// -->\n");
		}
		return sb.toString();
	}

}
