package jp.oarts.pirka.core.util.check;

import java.io.Serializable;

import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.kernel.FieldMap;

/**
 * `FbNe[NXۃNX<BR>
 * ̃NXhNX쐬͒l̃`FbNyѕϊs܂B<BR>
 * ̃NX̓XbhZ[tłȂ΂Ȃ܂B
 * 
 * @author ito
 * 
 */
public abstract class CheckAndTeller implements Serializable {

	/** tB[h}bv */
	private FieldMap fieldMap;

	/** G[bZ[WXgbJ[ */
	private ErrorMessageStocker errorMessageStocker;

	/**
	 * `FbNsȂ܂B<BR>
	 * ̃\bhI[o[ChēƎ̃`FbNϊ쐬ĂB<BR>
	 * `FbNɃG[addError\bhFieldMapsetErrorgp<BR>
	 * G[o^Kv܂B<BR>
	 * ܂AG[falseK߂悤ɂĂB<BR>
	 * 
	 * 
	 * @return true=Afalse=G[
	 */
	public abstract boolean check();

	/**
	 * tB[h}bv擾܂B
	 * 
	 * @return tB[h}bv
	 */
	public FieldMap getFieldMap() {
		// return PirkaKernel.getFieldMapObjct();
		return fieldMap;
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(String message) {
		errorMessageStocker.addError(message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(PirkaMessage message) {
		errorMessageStocker.addError(message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            G[bZ[Wɕ\鐳ȃtB[h(̕񂪂̂܂܉ʂɕ\܂)
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(String fieldName, String message) {
		errorMessageStocker.addError(fieldName, message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            G[bZ[Wɕ\鐳ȃtB[h(̕񂪂̂܂܉ʂɕ\܂)
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(String fieldName, PirkaMessage message) {
		errorMessageStocker.addError(fieldName, message);
	}

	/**
	 * G[bZ[WXgbJ[̃Zbg
	 * 
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 */
	@Deprecated
	public void setErrorMessageStocker(ErrorMessageStocker errorMessageStocker) {
		this.errorMessageStocker = errorMessageStocker;
	}

	/**
	 * tBh}bvݒ肵܂B
	 * 
	 * @param fieldMap
	 *            tBh}bv
	 */
	@Deprecated
	protected void setFieldMap(FieldMap fieldMap) {
		this.fieldMap = fieldMap;
	}

}
