package jp.oarts.pirka.core.util.check;

/**
 * ͕`FbJ[
 * 
 * @author ito
 *
 */
public class PirkaCheckerLength implements Checker {

	/** Œ茅w */
	public static final MODE JUST = MODE.JUST;

	/** ͈͎w */
	public static final MODE RANGE = MODE.RANGE;

	/** `FbN[h */
	private MODE mode;

	/** z */
	private int[] lengths;

	/**
	 * RXgN^
	 * 
	 * @param mode
	 *            `FbN[h
	 * @param lengths
	 *             <BR>
	 *            l͂Ă鎞̂݃`FbNsȂ܂<BR>
	 *            `FbN[h͈͎ŵƂ͌͋w肵Ȃ΂Ȃ܂B̂Ƃ1,3,6,9Ǝw肷1`36`9͈̔͂ƂȂ܂B<BR>
	 *            `FbN[hŒ茅̂Ƃ̌w\łB̂Ƃ1,3,6,9Ǝw肷1,3,6,9̌ƂȂ܂B
	 */
	public PirkaCheckerLength(MODE mode, int... lengths) {
		if (lengths.length <= 0) {
			throw new RuntimeException("`FbŇw肳Ă܂");
		}
		if (mode == RANGE && (lengths.length % 2) == 1) {
			throw new RuntimeException("`FbNŔ͈͎w(RANGE)̂ƂɎwł錅͋łȂ΂΂܂");
		}
		this.mode = mode;
		this.lengths = lengths;
	}

	/**
	 * `FbNsȂ܂B
	 * 
	 * @param value
	 *            `FbNsȂ
	 * @throws PirkaCheckException
	 *             G[
	 */
	public void check(String value) throws PirkaCheckException {
		int valueLength = value.length();
		if (valueLength <= 0) {
			return;
		}
		if (mode == JUST) {
			for (int length : lengths) {
				if (valueLength == length) {
					return;
				}
			}
			StringBuilder sb = new StringBuilder();
			sb.append("Ɍ肪܂ ͉\Ȍ");
			boolean first = true;
			for (int length : lengths) {
				if (!first) {
					sb.append(", ");
				}
				first = false;
				sb.append(length);
			}
			sb.append("ł");
			throw new PirkaCheckException(sb.toString());
		} else {
			for (int i = 0; i < lengths.length; i += 2) {
				if (lengths[i] <= valueLength && valueLength <= lengths[i + 1]) {
					return;
				}
			}
			StringBuilder sb = new StringBuilder();
			sb.append("Ɍ肪܂ ͉\Ȍ");
			for (int i = 0; i < lengths.length; i += 2) {
				if (i > 0) {
					sb.append(", ");
				}
				sb.append(lengths[i]);
				sb.append("`");
				sb.append(lengths[i + 1]);
			}
			sb.append("ł");
			throw new PirkaCheckException(sb.toString());
		}

	}

	/**	`FbN[h	*/
	private enum MODE {
		/** Œ茅 */
		JUST,

		/** ͈ */
		RANGE,

	}

}
