package jp.oarts.pirka.core.win;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.oarts.pirka.core.analyzer.html.HtmlLoopFieldMapAnalyzer;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.err.DefaultErrorMessageManager;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaMakeHtml;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheck;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.CheckerStocker;
import jp.oarts.pirka.core.util.check.PirkaMessage;
import jp.oarts.pirka.core.util.converter.BeanConverter;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.converter.DtoConverter;
import jp.oarts.pirka.core.util.field.FieldItem;

/**
 * PirkaŎgpłEBhENX̊NX
 * 
 * @author ito
 * 
 */
public abstract class PirkaWindow extends PirkaRespons {

	/** KwtB[h}bv */
	private FieldMap stratumFieldMap;

	/** KwĂȂtB[h}bv */
	private Map<String, FieldItem> rootFieldMap;

	/** [vtB[h}bv */
	private Map<String, FieldMap> loopFieldMap;

	/** ftHgtB[h}bv */
	private Map<String, FieldItem> defaultFieldMap;

	/** O[v}bv */
	private Map<String, String> groupFieldMap;

	/** `FbJ[XgbJ[ */
	private CheckerStocker checkerStocker;

	/** G[bZ[W}l[W[ */
	private ErrorMessageManagerIF errorMessageManager;

	/** G[bZ[WXgbJ[ */
	private ErrorMessageStocker errorMessageStocker;

	/** `FbNŔG[ */
	private int autoCheckErrorCount;

	/** ʃf[^ */
	private WindowBaseData windowBaseData;

	/** ߂EChE */
	private PirkaWindow returnWindow;

	/** ANV[vCfbNX */
	private int[] actionLoopIndex;

	/** ̃IuWFNgHTMLt@Ci\[Xt@Cj */
	private String htmlFileName;

	/**
	 * RXgN^
	 */
	protected PirkaWindow() {
		this(null);
	}

	/**
	 * RXgN^
	 * 
	 * @param htmlFileName
	 *            HTMLt@Ci\[Xt@Cj
	 */
	protected PirkaWindow(String htmlFileName) {

		if (htmlFileName == null) {
			htmlFileName = getDefaultHtmlFileName();
		}
		this.htmlFileName = htmlFileName;
		FieldMap fieldMap = (FieldMap) PirkaInfoPool.getFieldMap(htmlFileName);

		if (fieldMap == null) {
			throw new RuntimeException("HTMLt@C̉͂Ɏs܂ " + htmlFileName);
		}

		stratumFieldMap = (FieldMap) fieldMap.clone();
		String[] fieldNames = stratumFieldMap.getFieldNames();
		for (String fieldName : fieldNames) {
			FieldItem fieldItem = stratumFieldMap.getFieldItem(fieldName);
			if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
				fieldItem.setValue(new ArrayList<FieldMap>());
			}
		}
		rootFieldMap = stratumFieldMap.getRootMap();

		loopFieldMap = new HashMap<String, FieldMap>();
		defaultFieldMap = new HashMap<String, FieldItem>();
		groupFieldMap = new HashMap<String, String>();
		HtmlLoopFieldMapAnalyzer.getLoopFieldMap((FieldMap) fieldMap.clone(), loopFieldMap, defaultFieldMap, groupFieldMap);

		checkerStocker = new CheckerStocker();
		errorMessageStocker = new ErrorMessageStocker();
		autoCheckErrorCount = 0;
		returnWindow = null;
		errorMessageManager = DefaultErrorMessageManager.MANAGER;
		actionLoopIndex = new int[0];
	}

	// f[^o͗p /////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * tB[h}bv擾܂B
	 * 
	 * @return tB[h}bv
	 */
	public FieldMap getFieldMap() {
		return stratumFieldMap;
	}

	/**
	 * [vŎgptB[h}bvVKɍ쐬܂B<BR>
	 * FieldMap#addFieldMap\bhł͂ō쐬ꂽtB[h}bvgpĂBB
	 * 
	 * @param loopFieldName
	 *            [vtB[h
	 * @return w肳ꂽ[vtB[hɑΉVK쐬ꂽtB[h}bv
	 */
	public FieldMap createLoopFieldMap(String loopFieldName) {
		return (FieldMap) loopFieldMap.get(loopFieldName).cloneLoop();
	}

	/**
	 * [vŎgpftHg̃tB[h}bv擾܂B<BR>
	 * ̃\bhŎ擾tB[h}bv̊etB[hɐݒ肵l
	 * tH[}bg₻̑ݒcreateLoopFieldMap\bhō쐬
	 * tBh}bṽftHglƂȂ܂B<BR>
	 * ܂setDto\bhAsetBeanList\bhŃf[^i[[vɂp܂B<BR>
	 * ̃\bhŎ擾tB[h}bvFieldMap#addFieldMap\bhɂ
	 * gpł܂B<BR>
	 * 
	 * @param loopFieldName
	 *            [vtB[h
	 * @return w肳ꂽ[vtB[hɑΉftHg̃[vtB[h}bv
	 */
	public FieldMap getDefaultLoopFieldMap(String loopFieldName) {
		return (FieldMap) loopFieldMap.get(loopFieldName);
	}

	/**
	 * ʏ̕\E̓f[^DTOIuWFNg쐬܂B<BR>
	 * 擾MapύXł͉ʕ\ɂ͔f܂B<BR>
	 * ʂɔfƂɂ͕KsetDto\bhgpĉB<BR>
	 * {Iɂ̓`FbN{bNXȊO̓͏StringIuWFNgA`FbN{bNXBooleanIuWFNg<BR>
	 * ƂĒli[܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂȂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[w肵ĂB
	 * 
	 * @param converters
	 *            Ro[^[
	 * @return DTO
	 */
	public Map<String, Object> getDto(Converter... converters) {
		return DtoConverter.getDto(stratumFieldMap, converters);
	}

	/**
	 * ʏ̕\E̓f[^DTOIuWFNg쐬܂B<BR>
	 * 擾MapύXł͉ʕ\ɂ͔f܂B<BR>
	 * ʂɔfƂɂ͕KsetDto\bhgpĉB<BR>
	 * {Iɂ̓`FbN{bNXȊO̓͏StringIuWFNgA`FbN{bNXBooleanIuWFNg<BR>
	 * ƂĒli[܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂȂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[w肵ĂB
	 * 
	 * @param converters
	 *            Ro[^[
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo܂
	 * @return DTO
	 */
	public Map<String, Object> getDto(boolean inputCtrlOnly, Converter... converters) {
		return DtoConverter.getDto(stratumFieldMap, inputCtrlOnly, converters);
	}

	/**
	 * DTOIuWFNgʂ̊etB[hɔf܂B<BR>
	 * [vListIuWFNgMapIuWFNgi[悤ɂ܂B<BR>
	 * ڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * ڂ݂lnull̎̓[v0񃋁[vA`FbN{bNXfalseȂ͋󕶎Zbg܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param dto
	 *            DTO
	 * @param converters
	 *            Ro[^[
	 */
	public void setDto(Map<String, Object> dto, Converter... converters) {
		DtoConverter.setDto(this, dto, stratumFieldMap, converters);
	}

	/**
	 * DTOIuWFNgʂ̊etB[hɔf܂B<BR>
	 * [vListIuWFNgMapIuWFNgi[悤ɂ܂B<BR>
	 * ڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * ڂ݂lnull̎̓[v0񃋁[vA`FbN{bNXfalseȂ͋󕶎Zbg܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * tB[h̕ύX⑼̃NXIuWFNgɕύXMapIuWFNg쐬Ƃ<BR>
	 * Ro[^[ݒ肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * 
	 * @param dto
	 *            DTO
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݔf܂
	 * @param converters
	 *            Ro[^[
	 */
	public void setDto(Map<String, Object> dto, boolean inputCtrlOnly, Converter... converters) {
		DtoConverter.setDto(this, dto, stratumFieldMap, inputCtrlOnly, converters);
	}

	/**
	 * ʏ̕\E̓f[^BeanIuWFNg֊i[܂B<BR>
	 * [vf[^͑ΏۊOƂȂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanObject
	 *            f[^i[BeanIuWFNg
	 * @param converters
	 *            Ro[^[
	 */
	public void getBean(Object beanObject, Converter... converters) {
		BeanConverter.getBean(beanObject, stratumFieldMap, converters);
	}

	/**
	 * ʏ̕\E̓f[^BeanIuWFNg֊i[܂B<BR>
	 * [vf[^͑ΏۊOƂȂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanObject
	 *            f[^i[BeanIuWFNg
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo܂
	 * @param converters
	 *            Ro[^[
	 */
	public void getBean(Object beanObject, boolean inputCtrlOnly, Converter... converters) {
		BeanConverter.getBean(beanObject, stratumFieldMap, inputCtrlOnly, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^ListIuWFNgVKɍ쐬܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanClass
	 *            ListɊi[BeanIuWFNg̃NX ̃NX̓p[^̃pubNȃRXgN^gp\Ȃ
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 * @return Beani[ĂListIuWFNg
	 */
	public List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		return BeanConverter.getBeanList(beanClass, fieldMap, loopFieldName, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^ListIuWFNgVKɍ쐬܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanClass
	 *            ListɊi[BeanIuWFNg̃NX ̃NX̓p[^̃pubNȃRXgN^gp\Ȃ
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo܂
	 * @param converters
	 *            Ro[^[
	 * @return Beani[ĂListIuWFNg
	 */
	public List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {
		return BeanConverter.getBeanList(beanClass, fieldMap, loopFieldName, inputCtrlOnly, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^listɊi[ĂBeanIuWFNgXV܂B<BR>
	 * listBeanIuWFNglooptB[h̃[vقȂ鎞͏l̗vfXVsȂ܂B<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgłȂΓۏ؂܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 */
	public void getBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		BeanConverter.getBeanList(list, fieldMap, loopFieldName, converters);
	}

	/**
	 * FieldMapIuWFNg̎w肳ꂽ[vtB[hɊi[Ăf[^listɊi[ĂBeanIuWFNgXV܂B<BR>
	 * listBeanIuWFNglooptB[h̃[vقȂ鎞͏l̗vfXVsȂ܂B<BR>
	 * listBeanIuWFNg͑SēNX̃IuWFNgłȂΓۏ؂܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXBeanIuWFNg֊i[Ƃ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo܂
	 * @param converters
	 *            Ro[^[
	 */
	public void getBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {
		BeanConverter.getBeanList(list, fieldMap, loopFieldName, inputCtrlOnly, converters);
	}

	/**
	 * BeanIuWFNg̓eʂ̊etB[hɔf܂B<BR>
	 * [v͑ΏۊOƂ܂B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXƂ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanObject
	 *            BeanObject
	 * @param converters
	 *            Ro[^[
	 */
	public void setBean(Object beanObject, Converter... converters) {
		BeanConverter.setBean(this, beanObject, stratumFieldMap, converters);
	}

	/**
	 * BeanIuWFNg̓eʂ̊etB[hɔf܂B<BR>
	 * [v͑ΏۊOƂ܂B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXƂ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param beanObject
	 *            BeanObject
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo܂
	 * @param converters
	 *            Ro[^[
	 */
	public void setBean(Object beanObject, boolean inputCtrlOnly, Converter... converters) {
		BeanConverter.setBean(this, beanObject, stratumFieldMap, inputCtrlOnly, converters);
	}

	/**
	 * ListɊi[ĂBeanIuWFNg̓ew肳ꂽ[vtB[hFieldMapIuWFNg֊i[܂B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXƂ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param converters
	 *            Ro[^[
	 */
	public void setBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter... converters) {
		BeanConverter.setBeanList(this, list, fieldMap, loopFieldName, converters);
	}

	/**
	 * ListɊi[ĂBeanIuWFNg̓ew肳ꂽ[vtB[hFieldMapIuWFNg֊i[܂B<BR>
	 * Beanɍڂ݂ȂꍇtB[h}bv̒l̒u͍sȂ܂B<BR>
	 * Select^Oł̕ITABŋ؂ꂽStringƂ܂B<BR>
	 * BeanIuWFNg̃o[̌^StringABooleanAIntegerALongADateATimeAtimestampABigDecimal̎ɂ
	 * ϊs܂B
	 * tB[h̕ύX⑼̃NXĨuWFNgɕύXƂ<BR>
	 * Ro[^[w肷邱Ƃɂ\ƂȂ܂B
	 * 
	 * @param list
	 *            BeanIuWFNgi[Ă郊Xg
	 * @param fieldMap
	 *            tB[h}bvIuWFNg
	 * @param loopFieldName
	 *            [ṽtB[h
	 * @param inputCtrlOnly
	 *            true=̓f[^̂ݒo̎
	 * @param converters
	 *            Ro[^[
	 */
	public void setBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter... converters) {
		BeanConverter.setBeanList(this, list, fieldMap, loopFieldName, inputCtrlOnly, converters);
	}

	/**
	 * ANV\bhĂяoꂽCxg̃[vCfbNX擾܂B<BR>
	 * [ṽ{^NbNꂽƂԖڂ̃{^NbNꂽCfbNXƂĎ擾ł܂B
	 * 
	 * @return ANV[vCfbNX [vÕCxg̓TCY0AԊÕ[vCfbNX0AȉɂȂقǃCfbNX܂
	 */
	public int[] getActionLoopIndex() {
		return actionLoopIndex;
	}

	/**
	 * [vCfbNX̐ݒ<BR>
	 * t[[N̓ReigpȂeXgɎgpʏ͎gp܂B
	 * 
	 * @param actionLoopIndex
	 *            ANV[vCfbNX
	 */
	@Deprecated
	public void setActionLoopIndex(int[] actionLoopIndex) {
		this.actionLoopIndex = actionLoopIndex;
	}

	// `FbJ[///////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * `FbJ[ǉ܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param checker
	 *            `FbJ[
	 */
	protected void addCheck(String fieldName, Checker... checker) {
		isCheckField(fieldName);
		checkerStocker.addCheck(fieldName, checker);
	}

	/**
	 * `FbJ[ǉ܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            G[bZ[W
	 * @param checker
	 *            `FbJ[
	 */
	protected void addCheck(String fieldName, String message, Checker... checker) {
		isCheckField(fieldName);
		checkerStocker.addCheck(fieldName, message, checker);
	}

	/**
	 * `FbJ[ǉ܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            PirkabZ[W
	 * @param checker
	 *            `FbJ[
	 */
	protected void addCheck(String fieldName, PirkaMessage message, Checker... checker) {
		isCheckField(fieldName);
		checkerStocker.addCheck(fieldName, message, checker);
	}

	/**
	 * `FbNe[ǉ܂B
	 * 
	 * @param checckAndTeller
	 *            `FbNe[
	 */
	protected void addCheck(CheckAndTeller... checckAndTeller) {
		checkerStocker.addCheck(checckAndTeller);
	}

	/**
	 * u[J[ǉ܂B
	 */
	protected void addErrorCheckBreak() {
		checkerStocker.addErrorChaeckBreak();
	}

	/**
	 * ^[i[ǉ܂B
	 */
	protected void addErrorCheckReturner() {
		checkerStocker.addErrorChaeckReturner();
	}

	/**
	 * o^ĂSẴ`FbJ[NA܂B
	 */
	protected void clearCheck() {
		checkerStocker.clearCheck();
	}

	/**
	 * `FbJ[o^łtB[hmF܂B<BR>
	 * `FbJ[o^łȂtB[ĥƂ̓^CG[
	 * 
	 * @param fieldName
	 *            tB[h
	 * 
	 */
	private void isCheckField(String fieldName) {
		FieldItem fieldItem = defaultFieldMap.get(fieldName);
		if (fieldItem == null) {
			throw new RuntimeException("ȃtB[hw肳܂ " + fieldName);
		}
		if (!fieldItem.getCtrl().getCtrlProcesser().isInputCtrl()) {
			throw new RuntimeException("̓tB[hȊÕtB[hw肳܂ " + fieldName);
		}
	}

	/**
	 * `FbJ[XgbJ[擾܂B
	 * 
	 * @return `FbJ[XgbJ[
	 */
	@Deprecated
	public CheckerStocker getCheckerStocker() {
		return checkerStocker;
	}

	// `FbN ///////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ͒l̃`FbNsȂ܂B<BR>
	 * ̃`FbN͎`FbNƓłB<BR>
	 * `FbJ[Ƃă^[i[o^ĂĂG[<BR>
	 * ANV\bhȂ̂̃\bhĂяoȍ~͍̏sȂ܂B<BR>
	 * onElse\bhȂǂŃ`FbNKvȎɂ͂̃\bhgpĂB
	 * 
	 * @return true=Afalse=G[L
	 */
	public boolean check() throws AutoCheckRuntimeException {
		autoCheckErrorCount = 0;
		AutoCheck autoCheck = new AutoCheck();
		autoCheckErrorCount = autoCheck.runCheck(checkerStocker, rootFieldMap, stratumFieldMap, errorMessageStocker);
		if (autoCheck.isReturn()) {
			throw new AutoCheckRuntimeException();
		}
		return autoCheckErrorCount == 0;
	}

	/**
	 * `FbN܂check\bhŔG[擾܂B
	 * 
	 * @return G[
	 */
	protected int getAutoCheckErrorCount() {
		return autoCheckErrorCount;
	}

	// G[bZ[W ///////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * G[bZ[W}l[W[o^܂B<BR>
	 * Ǝ̃G[bZ[W\G[sƂɎgp܂B
	 * 
	 * @param errorMessageManager
	 *            G[bZ[W}l[W[
	 */
	public void setErrorMessageManager(ErrorMessageManagerIF errorMessageManager) {
		this.errorMessageManager = errorMessageManager;
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(String message) {
		errorMessageStocker.addError(message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(PirkaMessage message) {
		errorMessageStocker.addError(message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            G[bZ[Wɕ\tB[h
	 * @param message
	 *            G[bZ[W
	 */
	protected void addError(String fieldName, String message) {
		errorMessageStocker.addError(fieldName, message);
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @param message
	 *            G[bZ[Wɕ\G[bZ[W
	 */
	protected void addError(String fieldName, PirkaMessage message) {
		errorMessageStocker.addError(fieldName, message);
	}

	/**
	 * ZbVɔCӂ̃IuWFNgo^܂B<BR>
	 * 炩̗RɂT[ubgReiɃZbV݂ȂƂiZbV^CAEgj͓o^܂B
	 * 
	 * @param keyName
	 *            ۑIuWFNg擾ƂɎgp閼O
	 * @param object
	 *            ۑIuWFNg
	 */
	protected void putSession(String keyName, Object object) {
		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		entryPoint.putSession(keyName, object);
	}

	/**
	 * ZVwꂽIuWFNg擾܂B<BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂B
	 * 
	 * @param keyName
	 *            IuWFNgʂ閼O
	 * @return IuWFNg
	 */
	protected Object getSession(String keyName) {
		EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
		return entryPoint.getSession(keyName);
	}
	
	
	/**
	 * T[ubgNGXg擾܂B<BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂܂B ʏ͎gp܂B
	 * 
	 * @return T[ubgNGXg
	 */
	protected HttpServletRequest getHttpServletRequest() {
		return PirkaThreadMap.getServletReq();
	}

	/**
	 * T[ubgX|X擾܂B <BR>
	 * T[ubgŝݎ擾\łB<BR>
	 * sȊOnull߂܂B<BR>
	 * ʏ͎gp܂B
	 * 
	 * @return T[ubgX|X
	 */
	@Deprecated
	protected HttpServletResponse getHttpServletResponse() {
		return PirkaThreadMap.getServletRes();
	}

	// eXgp ///////////////////////////////////////////////////////////////////////////////////////////////////////////

	// gp֎~\bh /////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/**
	 * ʃf[^ݒ肵܂B
	 * 
	 * @param windowBaseData
	 *            ʃf[^
	 */
	@Deprecated
	public void setWindowBaseData(WindowBaseData windowBaseData) {
		this.windowBaseData = windowBaseData;
	}

	/**
	 * ʃf[^擾܂B
	 * 
	 * @return ʃf[^
	 */
	@Deprecated
	public WindowBaseData getWindowBaseData() {
		return windowBaseData;
	}

	/**
	 * uEUɑMHTMLo͂܂B<BR>
	 * 
	 * @param os
	 *            AEgvbgXg[
	 */
	@Deprecated
	public void writeRespons(OutputStream os) throws IOException {
		String html = PirkaMakeHtml.makeHtml(this, errorMessageManager, errorMessageStocker);
		os.write(html.getBytes(PirkaThreadMap.getEntryPointObjct().getHtmlStringCharset()));
	}

	/**
	 * HTTPX|Xwb_č쐬܂B
	 * 
	 * @param res
	 *            X|X
	 */
	@Deprecated
	public void remakeHeader(HttpServletResponse res) {
		res.setContentType("text/html; charset=" + PirkaThreadMap.getEntryPointObjct().getResponsHeaderCharset());
		res.setHeader("Cache-Control", "no-cache");
		res.setHeader("Pragma", "no-cache");
	}

	/**
	 * tB[hŒ艻܂B
	 */
	@Deprecated
	public void fixField() {
		rootFieldMap = stratumFieldMap.getRootMap();

	}

	/**
	 * [gtB[h}bv擾܂B
	 * 
	 * @return tB[h}bv
	 */
	@Deprecated
	public Map<String, FieldItem> getRootFieldMap() {
		return rootFieldMap;
	}

	/**
	 * [gtB[hACe擾܂B
	 * 
	 * @param fieldName
	 *            tB[h
	 * @return tB[hACe
	 */
	@Deprecated
	public FieldItem getRootFieldItem(String fieldName) {
		return rootFieldMap.get(fieldName);
	}

	/**
	 * ߂̃EChEIuWFNgo^܂B
	 * 
	 * @param returnWindow
	 *            ߂̃EChEIuWFNg
	 */
	@Deprecated
	public void setReturnWindow(PirkaWindow returnWindow) {
		this.returnWindow = returnWindow;
	}

	/**
	 * ߂̃EChEIuWFNg擾܂B
	 * 
	 * @return ߂̃EChEIuWFNg
	 */
	@Deprecated
	public PirkaWindow getReturnWindow() {
		return returnWindow;
	}

	/**
	 * G[bZ[WXgbJ[擾܂B
	 * 
	 * @return G[bZ[WXgbJ[
	 */
	@Deprecated
	public ErrorMessageStocker getErrorMessageStocker() {
		return errorMessageStocker;
	}

	/**
	 * ftHĝ̃NXɑΉHTMLt@C擾܂B
	 * 
	 * @return HTMLt@CipbP[WtCj
	 */
	private String getDefaultHtmlFileName() {
		return "/" + getClass().getName().replace('.', '/') + ".html";
	}

	/**
	 * ̃IuWFNgɑΉHTMLt@C擾܂B
	 * 
	 * @return HTMLt@CipbP[WtCj
	 */
	@Deprecated
	public String getHtmlFileName() {
		return htmlFileName;
	}

	// /////////////////////////////////////////////////////////////////////////////////////////////////////////////

}
