package jp.oarts.pirka.core.analyzer.html;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import jp.oarts.pirka.core.general.HtmlParts;
import jp.oarts.pirka.core.general.HtmlPartsType;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;

/**
 * HTML̃CN[h
 * 
 * HTMLt@CɋLڂĂȉ̍\̃Rg̃RgɋLqĂ t@CHTML𔲂oCN[hiWJj
 * 
 * <!--#include dir="" packege="" file="" -->
 * 
 * 
 *  HTMLt@CƂĈꂽ̃t@Ci[fBNgi΃pXA΃pXj ΃fBNgw肳ƃCN[hRgLڂĂt@C̑΂ƂȂ
 * 
 *  HTML\[Xt@CƂĈꂽ̃t@Ci[pP[W
 * 
 *  HTMLt@CAgqhtml̏ꍇ͂̃t@Cbody^O̓̂݃CN[h
 * 
 * ӁI <!--#include dir="" packege="" file="" -->̉߂̓^O\𖳎čsȂ܂B
 * 
 * @author ito
 * 
 */
public class HtmlIncludeAnalyzer implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -663258848497282089L;

	/** CN[hRgJn */
	private static final String INCLUDE_START_STRING = "<!--#include";

	/** CN[hRgI */
	private static final String INCLUDE_END_STRING = "-->";

	/** CN[hRgfBNgw葮 */
	private static final String DIR_STRING = "dir";

	/** CN[hRgpbP[Ww葮 */
	private static final String PACKEGE_STRING = "packege";

	/** CN[hRgt@Cw葮 */
	private static final String FILE_STRING = "file";

	/** CN[hRgbody^Ỗ݂CN[hsȂt@C̊gqi.tj */
	private static final String HTML_FILE_SAFIX = ".html";

	/**
	 * w肳ꂽHTMLt@C̃CN[hWJXgO߂
	 * 
	 * @param file
	 *            t@C
	 * @return WJꂽHTMLt@CC[W
	 */
	public static String include(File file) throws IOException {
		HtmlIncludeAnalyzer myObject = new HtmlIncludeAnalyzer();

		return myObject.includeMain(file);
	}

	// /**
	// * w肳ꂽHTMLt@C̃CN[hWJXgO߂
	// *
	// * @param packegeNmae
	// * pbP[W
	// * @param resourceName
	// * \[X
	// * @return WJꂽHTMLt@CC[W
	// */
	// public static String include(String packegeNmae, String resourceName) throws IOException {
	// HtmlInclude myObject = new HtmlInclude();
	//
	// return myObject.includeMain(packegeNmae, resourceName);
	// }

	/**
	 * w肳ꂽHTMLt@C̃CN[hWJXgO߂
	 * 
	 * @param resourceName
	 *            \[X
	 * @return WJꂽHTMLt@CC[W
	 */
	public static String include(String resourceName) throws IOException {
		HtmlIncludeAnalyzer myObject = new HtmlIncludeAnalyzer();

		return myObject.includeMain(resourceName);
	}

	/**
	 * CN[hJn
	 * 
	 * @param file
	 *            t@C
	 * @return CN[hWJꂽ
	 * @throws IOException
	 */
	private String includeMain(File file) throws IOException {

		return includeMain(new HtmlRealFile(file));
	}

	/**
	 * CN[hJn
	 * 
	 * @param resourceName
	 *            \[XipbP[W܂ށj
	 * @return CN[hWJꂽ
	 * @throws IOException
	 */
	// private String includeMain(String packegeName, String file) throws IOException {
	private String includeMain(String file) throws IOException {

		// return includeMain(new HtmlResourceFile(packegeName, file));
		return includeMain(new HtmlResourceFile(file));
	}

	/**
	 * CN[hJn
	 * 
	 * @return CN[hWJꂽ
	 * @throws IOException
	 */
	private String includeMain(HtmlFile htmlFile) throws IOException {

		// HTMLt@CċAIɓWĴh߂̃X^bN
		Stack<HtmlFile> stack = new Stack<HtmlFile>();
		stack.push(htmlFile);

		// WJꂽi[XgOobt@ */
		StringBuilder sb = new StringBuilder();

		// CN[hWJCĂ
		includeMain(sb, htmlFile, stack, true);

		return sb.toString();
	}

	/**
	 * CN[hWJCiċNĂяoj
	 * 
	 * @param sb
	 *            WJʊi[XgOobt@
	 * @param file
	 *            HTMLt@C
	 * @param stack
	 *            X^bN
	 * @param fullIncludeFlag
	 *            true=t@C̑SCN[hAfalse=t@CBody^Ô݃CN[h
	 * @throws IOException
	 */
	private void includeMain(StringBuilder sb, HtmlFile file, Stack<HtmlFile> stack, boolean fullIncludeFlag) throws IOException {

		int index = 0;
		int indexNext = 0;

		String htmlStr = file.toFileImage();
		if (!fullIncludeFlag) {
			htmlStr = getBody(htmlStr);
		}

		while (true) {
			index = htmlStr.indexOf(INCLUDE_START_STRING, indexNext);
			if (index < 0) {
				break;
			}
			if (index > indexNext) {
				sb.append(htmlStr.substring(indexNext, index));
				indexNext = index;
			}
			int indexCommentEnd = htmlStr.indexOf(INCLUDE_END_STRING, index);
			if (indexCommentEnd < 0) {
				break;
			}

			String comment = htmlStr.substring(indexNext, indexCommentEnd);
			indexNext = indexCommentEnd + INCLUDE_END_STRING.length();

			Map<String, String> map = HtmlTools.getOptionMap(comment);

			String dir = map.get(DIR_STRING);
			String packageName = map.get(PACKEGE_STRING);
			String fileName = map.get(FILE_STRING);
			if (dir == null || dir.length() <= 0 || packageName == null || packageName.length() <= 0 || fileName == null || fileName.length() <= 0) {
				throw new RuntimeException("HTMLt@C̃CN[h̏ɂ܂肪܂ " + comment);
			}

			HtmlFilePath filePath = new HtmlFilePath(dir, packageName, fileName);
			HtmlFile includeFile = file.createHtmlFile(filePath);

			if (stack.contains(includeFile)) {
				sb.append(comment);
				sb.append(INCLUDE_END_STRING);
			} else {
				stack.push(includeFile);
				if (fileName != null && fileName.length() > HTML_FILE_SAFIX.length() //
						&& HTML_FILE_SAFIX.equalsIgnoreCase(fileName.substring(fileName.length() - HTML_FILE_SAFIX.length()))) {
					includeMain(sb, includeFile, stack, false);
				} else {
					includeMain(sb, includeFile, stack, true);
				}
				stack.pop();
			}
		}

		if (indexNext < htmlStr.length()) {
			sb.append(htmlStr.substring(indexNext));
		}
	}

	/**
	 * HTMLt@CC[W̕BODY^Oň͂܂ꂽ擾B <BR>
	 * ̂ƂRgAEgꂽBODY^O͑ΏۊOƂB
	 * 
	 * @param htmlStr
	 *            HTMLt@CC[W̕
	 * @return BODY^Oň͂܂ꂽ
	 * @throws IOException
	 */
	protected String getBody(String htmlStr) throws IOException {

		Reader r = null;
		try {
			r = new StringReader(htmlStr);
			ArrayList<HtmlParts> htmlPartsList = HtmlSplitAnalyzer.getHtmlParts(r);

			HtmlParts bodyParts = searchTag(htmlPartsList, "body");
			if (bodyParts != null) {
				List<HtmlParts> chaildList = bodyParts.getChild();
				if (chaildList != null) {
					return HtmlTools.makeHtmlString(chaildList);
				}

			}
			return "";
		} finally {
			if (r != null) {
				r.close();
			}
		}
	}

	/**
	 * HTMLp[cXgw肳ꂽ^OꂷB
	 * 
	 * @param htmlPartsList
	 *            HTMLp[cXg
	 * @param tagName
	 *            ^O
	 * @return ꂽHTMLp[c
	 * @throws IOException
	 */
	protected HtmlParts searchTag(List<HtmlParts> htmlPartsList, String tagName) {

		tagName = tagName.toLowerCase();
		for (HtmlParts parts : htmlPartsList) {

			if (parts.getType() == HtmlPartsType.TAG) {
				// System.out.println(parts.getTagName());
				if (tagName.equalsIgnoreCase(parts.getTagName())) {
					return parts;
				} else {
					List<HtmlParts> chaildList = parts.getChild();
					if (chaildList != null) {
						HtmlParts seachParts = searchTag(chaildList, tagName);
						if (seachParts != null) {
							return seachParts;
						}
					}
				}
			}
		}
		return null;
	}

	/**
	 * 镶w肳ꂽ̃CfbNX擾Bp͑啶Ə𓯂̂ƂČB
	 * 
	 * @param targetString
	 *            镶
	 * @param searchString
	 *            
	 * @param fromIndex
	 *            Jnʒui0IWj
	 * @return -1 Ȃ
	 */
	public int indexIgnoreCaseOf(String targetString, String searchString, int fromIndex) {
		if (targetString == null || targetString.equals("")) {
			return -1;
		}
		if (searchString == null || searchString.equals("")) {
			return -1;
		}
		if (0 > (targetString.length() - searchString.length())) {
			return -1;
		}
		if (fromIndex < 0) {
			fromIndex = 0;
		}
		searchString = searchString.toLowerCase(); // p"searchString"̑SĂ̔pp/𔼊ppɂ
		int len = (targetString.length() - searchString.length());
		for (int index = fromIndex; index <= len; index++) {
			if (Character.toLowerCase(targetString.charAt(index)) == searchString.charAt(0) && loop(targetString, searchString, index)) {
				return index;
			}
		}
		return -1;
	}

	/**
	 * 
	 * @param targetString
	 * @param searchString
	 * @param index
	 * @return true=
	 */
	private static boolean loop(String targetString, String searchString, int index) {

		for (int j = 1; j < searchString.length(); j++) {
			if (Character.toLowerCase(targetString.charAt(index + j)) != searchString.charAt(j)) {
				return false;
			}
		}
		return true;
	}

	/**
	 * HTMLt@CpX
	 */
	class HtmlFilePath {
		/** fBNg */
		public String dir;

		/** pbP[W */
		public String pakageName;

		/** t@C */
		public String fileNmae;

		/**
		 * RXgN^
		 * 
		 * @param dir
		 *            fBNg
		 * @param pakageName
		 *            pbP[W
		 * @param fileNmae
		 *            t@C
		 */
		public HtmlFilePath(String dir, String pakageName, String fileNmae) {
			this.dir = dir;
			this.pakageName = pakageName;
			this.fileNmae = fileNmae;
		}
	}

	/**
	 * HTMLt@CC^[tF[X
	 * 
	 */
	interface HtmlFile {

		/**
		 * t@C̓eStringƂĎo
		 * 
		 * @return t@C̓e
		 */
		public String toFileImage() throws IOException;

		/**
		 * w肳ꂽHTMLt@CpXVHTMLt@CpX쐬
		 * 
		 * @param htmlFilePath
		 *            HTMLt@CpX
		 * @return VHTMLt@CpX
		 * @throws IOException
		 */
		public HtmlFile createHtmlFile(HtmlFilePath htmlFilePath) throws IOException;

	}

	/**
	 * HTMLt@Cit@Cj
	 */
	class HtmlRealFile implements HtmlFile {

		/** t@C */
		private File file;

		/**
		 * RXgN^
		 * 
		 * @param file
		 *            t@CIuWFNg
		 */
		public HtmlRealFile(File file) throws IOException {
			this.file = file.getCanonicalFile();
		}

		/**
		 * t@C̓eStringƂĎo
		 * 
		 * @return t@C̓e
		 */
		public String toFileImage() throws IOException {

			byte[] buffer = new byte[4096];
			BufferedInputStream bis = null;
			ByteArrayOutputStream baos = null;

			try {
				bis = new BufferedInputStream(new FileInputStream(file));
				baos = new ByteArrayOutputStream();

				while (true) {
					int length = bis.read(buffer);
					if (length <= 0) {
						break;
					}
					baos.write(buffer, 0, length);
				}
				baos.flush();
				// return new String(baos.toByteArray(), "JISAutoDetect");
				// return new String(baos.toByteArray(), PirkaThreadMap.getEntryPointObjct().getResourceHtmlFileCharset());
				return new String(baos.toByteArray()); // t@C̏ꍇOS̃LN^Zbggp

			} finally {
				if (baos != null) {
					baos.close();
				}
				if (bis != null) {
					bis.close();
				}
			}
		}

		/**
		 * w肳ꂽHTMLt@CpXVHTMLt@CpX쐬 ΃pXE΃pXӎč\z
		 * 
		 * @param htmlFilePath
		 *            HTMLt@CpX
		 * @return VHTMLt@CpX
		 * @throws IOException
		 */
		public HtmlFile createHtmlFile(HtmlFilePath htmlFilePath) throws IOException {

			File newDir = new File(htmlFilePath.dir);
			File baseDir = null;

			if (newDir.isAbsolute()) {
				baseDir = newDir;
			} else {
				baseDir = new File(file.getParentFile(), htmlFilePath.dir);
			}

			return (HtmlFile) (new HtmlRealFile(new File(baseDir, htmlFilePath.fileNmae)));
		}

		/**
		 * w肳IuWFNgIuWFNgƓsȂ
		 * 
		 * @param object
		 *            IuWFNg
		 * @return true=
		 */
		public boolean equals(Object object) {
			if (object == null || !(object instanceof HtmlRealFile)) {
				return false;
			}
			return file.equals(((HtmlRealFile) object).file);

		}
	}

	/**
	 * HTMLt@Ci\[Xt@Cj
	 */
	class HtmlResourceFile implements HtmlFile {

		// /** pbP[W */
		// private String packegeName;

		// /** pbP[WfBNg */
		// private String packegeDir;

		/** \[Xt@C */
		private String file;

		/**
		 * RXgN^
		 * 
		 * @param file
		 *            \[Xt@C
		 */
		// public HtmlResourceFile(String packegeName, String file) {
		public HtmlResourceFile(String file) {
			// packegeDir = "/" + packegeName.replace('.', '/') + "/";
			this.file = file;
		}

		/**
		 * t@C̓eStringƂĎo
		 * 
		 * @return t@C̓e
		 */
		public String toFileImage() throws IOException {

			byte[] buffer = new byte[4096];
			BufferedInputStream bis = null;
			ByteArrayOutputStream baos = null;

			try {
				// URL url = HtmlInclude.class.getResource(packegeDir + file);
				URL url = HtmlIncludeAnalyzer.class.getResource(file);
				if (url == null) {
					throw new IOException("\[Xt@C܂ file=" + file);
				}
				bis = new BufferedInputStream(url.openStream());
				// bis = new BufferedInputStream(getClass().getResourceAsStream(file));
				baos = new ByteArrayOutputStream();

				while (true) {
					int length = bis.read(buffer);
					if (length <= 0) {
						break;
					}
					baos.write(buffer, 0, length);
				}
				baos.flush();
				// return new String(baos.toByteArray(), "JISAutoDetect");
				return new String(baos.toByteArray(), PirkaThreadMap.getEntryPointObjct().getResourceHtmlFileCharset());

			} finally {
				if (baos != null) {
					baos.close();
				}
				if (bis != null) {
					bis.close();
				}
			}
		}

		/**
		 * w肳ꂽHTMLt@CpXVHTMLt@CpX쐬
		 * 
		 * @param htmlFilePath
		 *            HTMLt@CpX
		 * @return VHTMLt@CpX
		 * @throws IOException
		 */
		public HtmlFile createHtmlFile(HtmlFilePath htmlFilePath) {

			// return (HtmlFile) (new HtmlResourceFile(htmlFilePath.pakageName, htmlFilePath.fileNmae));
			return (HtmlFile) (new HtmlResourceFile(htmlFilePath.fileNmae));
		}

		/**
		 * w肳IuWFNgIuWFNgƓsȂ
		 * 
		 * @param object
		 *            IuWFNg
		 * @return true=
		 */
		public boolean equals(Object object) {
			if (object == null || !(object instanceof HtmlResourceFile)) {
				return false;
			}
			return file.equals(((HtmlResourceFile) object).file);

		}
	}

	/**
	 * eXgpC
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			// System.out.println("--- HTML\[Xt@CeXg---------------------------");
			// System.out.println(include("jp.oarts.pirka.core.analyzer.test.test1.html"));
			// // System.out.println(include("jp.oarts.pirka.core.analyzer.test.test1.html"));
			// System.out.println("");
			System.out.println("--- HTMLt@CeXg---------------------------");
			System.out.println(include(new File("E:/Job/oa/make/pirka/test/include/test1.html")));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
