package jp.oarts.pirka.core.err;

import java.util.List;

import jp.oarts.pirka.core.analyzer.html.HtmlTools;

/**
 * pirkaftHg̃G[bZ[W}l[W[
 * 
 * @author ito
 * 
 */
public class DefaultErrorMessageManager implements ErrorMessageManagerIF {

	/** CX^X */
	public static final DefaultErrorMessageManager MANAGER = new DefaultErrorMessageManager();

	/**
	 * G[bZ[WXgbJ[ɒ~ĂG[\p̃G[bZ[W쐬܂B
	 * 
	 * @param errorMessageStocker
	 *            G[bZ[WXgbJ[
	 * @return \p̃G[bZ[W
	 */
	public String createErrorMessage(ErrorMessageStocker errorMessageStocker) {

		StringBuilder sb = new StringBuilder();
		List<ErrorMessageItem> list = errorMessageStocker.getErrorMessageList();

		for (ErrorMessageItem item : list) {
			if (sb.length() > 0) {
				sb.append("<br>");
			}

			if (item.getFieldName() != null && item.getFieldName().length() > 0) {
				sb.append(HtmlTools.webStringWithSpace(item.getFieldName()));
				sb.append(HtmlTools.webStringWithSpace(" F "));
			}
			if (item.getPirkaMessage() == null) {
				sb.append(HtmlTools.webStringWithSpace(item.getMessage()));
			} else {
				String code = item.getPirkaMessage().getErrorCode();
				String message = item.getPirkaMessage().getErrorMessage();
				if (code == null || code.length() <= 0) {
					sb.append(HtmlTools.webStringWithSpace(message));
				} else {
					sb.append(HtmlTools.webStringWithSpace(code));
					sb.append(HtmlTools.webStringWithSpace(" "));
					sb.append(HtmlTools.webStringWithSpace(message));
				}
			}
		}

		return sb.toString();
	}

	/**
	 * createErrorMessage\bhō쐬ꂽG[bZ[WHTML^O܂܂ȂtrueԂ܂B<BR>
	 * HTML^OiƂ΃e[uȂǁj܂ޏꍇfalseԂB<BR>
	 * falseԂ͓ꕶ̕ϊsȂꂸɃuEU[ɑM̂Œӂ邱ƁB
	 */
	public boolean isWebSafeErrorMessage() {
		return false;
	}

	/**
	 * G[tB[h̃X^C擾܂B ftHgbackground-color: #ff8080łB
	 * 
	 * @return G[tB[h̃X^C
	 */
	public String getNgStyle() {
		return "background-color: #ff8080";
	}

	/**
	 * G[tB[hɑΉ郉x̃X^C擾܂B ftHgcolor: #ff8080łB
	 * 
	 * @return G[x̃X^C
	 */
	public String getNgLabelStyle() {
		return "color: #ff8080";
	}

}
