package jp.oarts.pirka.core.err;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.util.check.PirkaMessage;

/**
 * G[bZ[WXgbJ[<BR>
 * ̃NX̃IuWFNgɃG[bZ[Wi[܂B
 * 
 * @author ito
 * 
 */
public class ErrorMessageStocker implements Serializable {

	/** G[bZ[WXg */
	private List<ErrorMessageItem> errorList;

	/** PirkabZ[WNXIuWFNg */
	private Class pirkaMessageClass;

	/**
	 * RXgN^
	 */
	public ErrorMessageStocker() {
		errorList = new ArrayList<ErrorMessageItem>();
		pirkaMessageClass = PirkaThreadMap.getEntryPointObjct().getPirkaMessageEnumClass();
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	public void addError(String message) {
		if (pirkaMessageClass != null) {
			throw new RuntimeException("PirkaMessageo^Ă邽߂̃\bh͎gpł܂");
		}
		errorList.add(new ErrorMessageItem(message));
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param message
	 *            G[bZ[W
	 */
	public void addError(PirkaMessage message) {
		if (pirkaMessageClass == null) {
			throw new RuntimeException("PirkaMessageo^̂߂̃\bh͎gpł܂");
		}
		if (pirkaMessageClass != message.getClass()) { // NXIuWFNg̔r
			throw new RuntimeException("o^ꂽPirkaMessageƈႢ܂");
		}
		errorList.add(new ErrorMessageItem(message));
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            G[bZ[Wɕ\tB[h
	 * @param message
	 *            G[bZ[W
	 */
	public void addError(String fieldName, String message) {
		if (pirkaMessageClass != null) {
			throw new RuntimeException("PirkaMessageo^Ă邽߂̃\bh͎gpł܂");
		}
		errorList.add(new ErrorMessageItem(fieldName, message));
	}

	/**
	 * G[bZ[Wǉ܂B
	 * 
	 * @param fieldName
	 *            G[bZ[Wɕ\tB[h
	 * @param message
	 *            G[bZ[W
	 */
	public void addError(String fieldName, PirkaMessage message) {
		if (pirkaMessageClass == null) {
			throw new RuntimeException("PirkaMessageo^̂߂̃\bh͎gpł܂");
		}
		if (pirkaMessageClass != message.getClass()) { // NXIuWFNg̔r
			throw new RuntimeException("o^ꂽPirkaMessageƈႢ܂");
		}
		errorList.add(new ErrorMessageItem(fieldName, message));
	}

	/**
	 * o^ĂSG[bZ[WNA܂B
	 * 
	 */
	public void clear() {
		errorList.clear();
	}

	/**
	 * G[Xg擾܂B
	 * 
	 * @return G[Xg
	 */
	public List<ErrorMessageItem> getErrorMessageList() {
		return errorList;
	}
}
