/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import jp.oarts.pirka.core.kernel.TempFileManager;

public class DefaultTempFileManager
implements TempFileManager {
    private static DefaultTempFileManager object = new DefaultTempFileManager();
    private Map<Long, File> tempFileMap = new HashMap<Long, File>();

    private DefaultTempFileManager() {
    }

    public static DefaultTempFileManager getInstance() {
        return object;
    }

    public synchronized OutputStream getOutputStream(long fileId) throws IOException {
        File tempFile = File.createTempFile("Pirka" + fileId, "tmp");
        this.tempFileMap.put(fileId, tempFile);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));
        return bos;
    }

    public synchronized InputStream getInputStream(long fileId) throws IOException {
        File file = this.tempFileMap.get(fileId);
        FileInputStream fis = new FileInputStream(file);
        return fis;
    }

    public void delete(long fileId) throws IOException {
        if (this.tempFileMap.containsKey(fileId)) {
            File file = this.tempFileMap.get(fileId);
            this.tempFileMap.remove(fileId);
            file.delete();
        }
    }
}

