package jp.oarts.pirka.core.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import jp.oarts.pirka.core.kernel.TempFileManager;

/**
 * pirkaW̃e|[t@C}l[W[C^[tF[X<BR>
 * Javãe|[t@CgpĎĂ
 * 
 * @author ito
 * 
 */
public class DefaultTempFileManager implements TempFileManager {

	// B̎IuWFNg
	private static DefaultTempFileManager object = new DefaultTempFileManager();

	// e|[t@C}bv
	private Map<Long, File> tempFileMap = new HashMap<Long, File>();

	/**
	 * new֎~̃RXgN^
	 */
	private DefaultTempFileManager() {
		// Ȃ
	}

	/**
	 * CX^X̎擾
	 * 
	 * @return CX^X
	 */
	public static DefaultTempFileManager getInstance() {
		return object;
	}

	/**
	 * w肳ꂽt@CIDɑΉe|[t@Cۑ̈쐬A<BR>
	 * ̗̈ւ̃t@Co͗p̃AEgvbgXg[߂B<BR>
	 * AEgvbgXg[̃N[Y͎gp҂̐ӔCōsƁB
	 * ܂Ãb\bh͕̃Xbh瓯ɌĂяoĂ͂ȂB
	 * 
	 * @param fileId
	 *            t@CID
	 * @return AEgvbgXg[
	 * @throws IOException
	 *             G[ɃX[
	 */
	public synchronized OutputStream getOutputStream(long fileId) throws IOException {

		File tempFile = File.createTempFile("Pirka" + fileId, "tmp");
		tempFileMap.put(fileId, tempFile);
		OutputStream bos = new BufferedOutputStream(new FileOutputStream(tempFile));

		return bos;
	}

	/**
	 * w肳ꂽt@CIDɑΉe|[t@Cۑ̈f[^ǂݏo߂<BR>
	 * CvbgXg[߂B<BR>
	 * ȑOgetOutputStream\bhŎ擾ꂽAEgvbgXg[<BR>
	 * ݂st@CIDłdelete\bhō폜ĂȂt@CID̂<BR>
	 * w\łB<BR>
	 * gp҂͓t@CIDpĕ񂱂̃\bhĂяoĂ͂ȂB<BR>
	 * CvbgXg[̃N[Y͎gp҂̐ӔCōsƁB
	 * ܂Ãb\bh͕̃Xbh瓯ɌĂяoĂ͂ȂB
	 * 
	 * @param fileId
	 *            t@CID
	 * @return CvbgXg[
	 * @throws IOException
	 *             G[ɃX[
	 */
	public synchronized InputStream getInputStream(long fileId) throws IOException {

		File file = tempFileMap.get(fileId);
		FileInputStream fis = new FileInputStream(file);

		return fis;
	}

	/**
	 * w肳ꂽt@CIDɑΉe|[t@Cۑ̈JB<BR>
	 * ɊJꂽt@CIDw肳ꂽƂ͉sȂB
	 * ܂Ãb\bh͕̃Xbh瓯ɌĂяoĂ͂ȂB
	 * 
	 * @param fileId
	 *            t@CID
	 * @throws IOException
	 *             G[
	 */
	public void delete(long fileId) throws IOException {
		if (tempFileMap.containsKey(fileId)) {
			File file = tempFileMap.get(fileId);
			tempFileMap.remove(fileId);
			file.delete();
		}
	}

}
