package jp.oarts.pirka.core.util.format;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * lf[^̃tH[}b^[
 * 
 * @author ito
 * 
 */
public class NumericFieldFormat implements FieldFormat {

	/**  */
	private String fomatString;

	/**
	 * RXgN^
	 * 
	 * @param fomatString
	 *            ijava.text.DecimalFormat̏j
	 */
	public NumericFieldFormat(String fomatString) {
		this.fomatString = fomatString;
	}

	/**
	 * ꂽ\p̕ɕϊ܂B<BR>
	 * ꂽ̒l\p̕ɕϊłȂƂnull߂܂B
	 * 
	 * @param value
	 *            
	 * @return \p̕
	 */
	public String format(String value) {

		BigDecimal bigValue = PirkaFormatUtil.parseBigDecimal(value);
		if (bigValue == null) {
			return null;
		}

		DecimalFormat df = new DecimalFormat(fomatString);
		return df.format(bigValue);
	}

}
