/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.app;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.oarts.pirka.core.ajax.ResponseData;
import jp.oarts.pirka.core.app.DefaultReqCharacterConverter;
import jp.oarts.pirka.core.app.DefaultStringConverter;
import jp.oarts.pirka.core.app.DefaultTempFileManager;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.app.ReqParser;
import jp.oarts.pirka.core.app.Tools;
import jp.oarts.pirka.core.ctrl.proc.CtrlProcesser;
import jp.oarts.pirka.core.general.HtmlCtrlParts;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaImage;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.kernel.PirkaUploadManager;
import jp.oarts.pirka.core.kernel.TempFileManager;
import jp.oarts.pirka.core.res.PirkaFileDownloader;
import jp.oarts.pirka.core.res.PirkaFileDownloaderFromBytes;
import jp.oarts.pirka.core.res.PirkaImageDownloader;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.check.message.PirkaStandardMessageManagerIF;
import jp.oarts.pirka.core.util.converter.ReqCharacterConverter;
import jp.oarts.pirka.core.util.converter.StringConverter;
import jp.oarts.pirka.core.util.field.FieldItem;
import jp.oarts.pirka.core.win.FatalErrorDefaultWindow;
import jp.oarts.pirka.core.win.PirkaFatalErrorWindow;
import jp.oarts.pirka.core.win.PirkaWindow;
import jp.oarts.pirka.core.win.SessionTimeoutDefaultWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntryPoint
extends HttpServlet
implements Serializable,
EntryPointIF {
    public static final String REQ_PIRKA_MARK = "__PIRKA__";
    public static final String REQ_LINK = "__PIRKA__LINK__";
    public static final String REQ_FORM = "__PIRKA__FORM__";
    public static final String REQ_IMAGE = "__PIRKA__IMG__";
    public static final String REQ_AJAX = "__PIRKA__AJAX__";
    public static final String REQ_INSTANCE = "__PIRKA__INS__";
    public static final String REQ_SERIALNO = "__PIRKA__SNO__";
    public static final String REQ_A_SUBMIT = "__PIRKA__A_SUBMIT__";
    private static final String SESSION_PIRKA_MARK = "__PIRKA__";
    private static final String SESSION_INSTANCE = "__PIRKA__INSTANCE__";
    private static final String SESSION_SERIALNO = "__PIRKA__SERIAL_NO__";
    private static final String SESSION_INIT_WINDOW = "__PIRKA__INIT_WINDOW__";
    private static final String SESSION_ERROR_FLAG = "__PIRKA__ERROR_FLAG__";

    @Deprecated
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.serviceMain(req, res);
    }

    @Deprecated
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.serviceMain(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void serviceMain(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block24: {
            try {
                boolean newSessionFlag = false;
                HttpSession session = req.getSession(false);
                if (session == null) {
                    newSessionFlag = true;
                    session = req.getSession(true);
                }
                PirkaThreadMap.setEntryPointObject(this);
                PirkaThreadMap.setServletPartam(req, res, session);
                PirkaRespons pirkaRespons = null;
                try {
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        HashMap<String, String[]> reqMap = new HashMap<String, String[]>();
                        ArrayList<Long> uploadFileList = new ArrayList<Long>();
                        ReqParser.parser(req, reqMap, uploadFileList);
                        try {
                            if (reqMap.containsKey(REQ_AJAX)) {
                                pirkaRespons = this.serviceMainAjaxProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
                            } else if (reqMap.containsKey(REQ_IMAGE)) {
                                pirkaRespons = this.serviceMainImageProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
                            } else {
                                this.inputDataConvert(reqMap);
                                pirkaRespons = this.isOldServletMode() ? this.serviceMainOldServletProc(newSessionFlag, session, req, res, reqMap, uploadFileList) : this.serviceMainProc(newSessionFlag, session, req, res, reqMap, uploadFileList);
                            }
                        }
                        finally {
                            PirkaUploadManager.deleteFile(uploadFileList);
                        }
                    }
                }
                catch (Throwable e) {
                    pirkaRespons = this.getFatalErrorWindow();
                    if (pirkaRespons instanceof PirkaFatalErrorWindow) {
                        ((PirkaFatalErrorWindow)((Object)pirkaRespons)).setError(e);
                    }
                    this.setErrorFlag(PirkaThreadMap.getSession(), true);
                }
                if (pirkaRespons == null) break block24;
                ((PirkaRespons)pirkaRespons).remakeHeader(res);
                ServletOutputStream out = null;
                try {
                    out = res.getOutputStream();
                    if (pirkaRespons != null) {
                        ((PirkaRespons)pirkaRespons).writeRespons((OutputStream)out);
                        out.flush();
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            finally {
                PirkaThreadMap.removeEntryPointObject();
                PirkaThreadMap.removeServletParam();
            }
        }
    }

    private void inputDataConvert(Map<String, String[]> reqMap) {
        StringConverter converter = this.getInputStringConverter();
        for (String key : reqMap.keySet()) {
            String[] values = reqMap.get(key);
            if (values == null) continue;
            int i = 0;
            while (i < values.length) {
                values[i] = converter.convert(values[i]);
                ++i;
            }
        }
    }

    @Deprecated
    protected PirkaRespons serviceMainAjaxProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (String key : reqMap.keySet()) {
            String[] values = reqMap.get(key);
            if (values == null) {
                params.put(this.decodeUnicodeEscp(key), new String[0]);
                continue;
            }
            int i = 0;
            while (i < values.length) {
                values[i] = this.decodeUnicodeEscp(values[i]);
                ++i;
            }
            params.put(this.decodeUnicodeEscp(key), values);
        }
        this.inputDataConvert(params);
        PirkaFileDownloaderFromBytes respons = new PirkaFileDownloaderFromBytes("", new byte[0]);
        if (session != null) {
            String ajaxName = this.getSingleReqParam(params, REQ_AJAX);
            String instanceNo = this.getSingleReqParam(params, REQ_INSTANCE);
            if (ajaxName != null && instanceNo != null) {
                FieldItem fieldItem;
                String className;
                PirkaWindow window;
                String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                if (sessionSerialNo != null && reqSerialNo != null && reqSerialNo.equals(sessionSerialNo) && (window = this.getWindowObjectFromSession(session, instanceNo)) != null && (className = this.getClassNameFromSerialNo(reqSerialNo)) != null && className.equals(window.getClass().getName()) && (fieldItem = window.getRootFieldItem(ajaxName)) != null && fieldItem.getCtrl() != null && fieldItem.getCtrl().getAjaxScript() != null) {
                    boolean firstFlag = true;
                    ResponseData resMap = fieldItem.getCtrl().getAjaxScript().run(params);
                    StringBuilder sb = new StringBuilder();
                    sb.append("{\n");
                    if (resMap != null) {
                        for (String key : resMap.keySet()) {
                            String value = resMap.get(key);
                            if (value == null) {
                                value = "";
                            }
                            if (!firstFlag) {
                                sb.append(",\n");
                            } else {
                                firstFlag = false;
                            }
                            sb.append('\"');
                            sb.append(key);
                            sb.append("\": \"");
                            sb.append(this.getOutputStringConverter().convert(value));
                            sb.append('\"');
                        }
                    }
                    sb.append("\n}\n");
                    byte[] buffer = sb.toString().getBytes("UTF-8");
                    if (buffer != null) {
                        respons = new PirkaFileDownloaderFromBytes("", "text/plain", buffer);
                    }
                }
            }
        }
        return respons;
    }

    private String decodeUnicodeEscp(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c != '\\') {
                sb.append(c);
                ++i;
                continue;
            }
            if (i <= str.length() - 6 && str.charAt(i + 1) == 'u') {
                char hex = '.';
                String hexStr = str.substring(i + 2, i + 6);
                try {
                    hex = (char)Integer.parseInt(hexStr, 16);
                    sb.append(hex);
                    i += 6;
                }
                catch (NumberFormatException e) {
                    sb.append(c);
                    ++i;
                }
                continue;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    @Deprecated
    protected PirkaRespons serviceMainImageProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        PirkaRespons respons = new PirkaFileDownloaderFromBytes("", new byte[0]);
        if (session != null) {
            String imageName = this.getSingleReqParam(reqMap, REQ_IMAGE);
            String instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
            if (imageName != null && instanceNo != null) {
                PirkaImage image;
                byte[] buffer;
                FieldItem fieldItem;
                String className;
                PirkaWindow window;
                String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                if (sessionSerialNo != null && reqSerialNo != null && reqSerialNo.equals(sessionSerialNo) && (window = this.getWindowObjectFromSession(session, instanceNo)) != null && (className = this.getClassNameFromSerialNo(reqSerialNo)) != null && className.equals(window.getClass().getName()) && (fieldItem = window.getRootFieldItem(imageName)) != null && fieldItem.getCtrl() != null && fieldItem.getCtrl().getImage() != null && (buffer = (image = fieldItem.getCtrl().getImage()).getImage()) != null) {
                    respons = new PirkaImageDownloader(image.getMimeType(), buffer);
                }
            }
        }
        return respons;
    }

    @Deprecated
    protected PirkaRespons serviceMainProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        return this.serviceMainProcAsync(newSessionFlag, session, req, res, reqMap, uploadFileList);
    }

    @Deprecated
    protected PirkaRespons serviceMainProcAsync(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        String instanceNo;
        PirkaRespons nextWindow;
        block35: {
            boolean initWindowFlag;
            boolean actionMethodNoCallFlag;
            block33: {
                block31: {
                    block34: {
                        block32: {
                            nextWindow = null;
                            instanceNo = "";
                            actionMethodNoCallFlag = false;
                            initWindowFlag = false;
                            if (!newSessionFlag) break block31;
                            if (!this.isErrorFlag(session)) break block32;
                            initWindowFlag = true;
                            break block33;
                        }
                        if (!reqMap.containsKey("__PIRKA__")) break block34;
                        nextWindow = this.getSessionTimeoutWindow();
                        this.setErrorFlag(session, true);
                        break block35;
                    }
                    initWindowFlag = true;
                    break block33;
                }
                if (this.isErrorFlag(session)) {
                    initWindowFlag = true;
                } else if (!reqMap.containsKey("__PIRKA__")) {
                    initWindowFlag = true;
                }
            }
            instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
            if (initWindowFlag) {
                if (instanceNo == null || instanceNo.length() <= 0) {
                    if (this.isClearSessionAtInitScreen()) {
                        session.invalidate();
                        session = req.getSession(true);
                    }
                    PirkaThreadMap.setServletPartam(req, res, session);
                    instanceNo = "";
                    this.setErrorFlag(session, false);
                    nextWindow = this.getInitWindow(reqMap);
                } else {
                    nextWindow = this.getSubWindow(reqMap);
                }
            } else {
                String sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                String reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                if (sessionSerialNo == null || reqSerialNo == null) {
                    nextWindow = this.getSessionTimeoutWindow();
                    this.setErrorFlag(session, true);
                } else {
                    if (!reqSerialNo.equals(sessionSerialNo)) {
                        nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                        if (nextWindow == null) {
                            throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 ");
                        }
                        return nextWindow;
                    }
                    nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                    if (nextWindow == null) {
                        throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 ");
                    }
                    String className = this.getClassNameFromSerialNo(reqSerialNo);
                    if (className == null || !className.equals(nextWindow.getClass().getName())) {
                        throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3068\u30ea\u30af\u30a8\u30b9\u30c8\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u9055\u3044\u307e\u3059 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                    }
                    this.clearErrorFlag(((PirkaWindow)nextWindow).getRootFieldMap());
                    ((PirkaWindow)nextWindow).getErrorMessageStocker().clear();
                    String actionName = this.getActionName((PirkaWindow)nextWindow, reqMap);
                    FieldItem actionFieldItem = null;
                    if (actionName != null) {
                        actionFieldItem = ((PirkaWindow)nextWindow).getRootFieldItem(actionName);
                    }
                    if (actionFieldItem != null) {
                        this.setActionLoopIndex((PirkaWindow)nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
                    } else {
                        ((PirkaWindow)nextWindow).setActionLoopIndex(new int[0]);
                    }
                    String mark = this.getSingleReqParam(reqMap, "__PIRKA__");
                    PirkaWindow oldWindow = nextWindow;
                    if (REQ_FORM.equals(mark)) {
                        this.getReqValue(((PirkaWindow)nextWindow).getFieldMap(), reqMap);
                        nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                        if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                            try {
                                ((PirkaWindow)nextWindow).check();
                            }
                            catch (AutoCheckRuntimeException e) {
                                actionMethodNoCallFlag = true;
                            }
                        }
                    } else {
                        nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                    }
                    if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
                        try {
                            nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
                        }
                        catch (AutoCheckRuntimeException e) {
                            // empty catch block
                        }
                    }
                    if (nextWindow == null) {
                        PirkaWindow returnWindow = oldWindow.getReturnWindow();
                        nextWindow = returnWindow != null ? returnWindow : oldWindow;
                    } else if (!(nextWindow instanceof PirkaFileDownloader) && nextWindow != oldWindow) {
                        boolean hitFlag = false;
                        Class<?> nextWindowClass = nextWindow.getClass();
                        PirkaWindow tempWindow = oldWindow;
                        do {
                            Class<?> tempWindowClass;
                            if ((tempWindowClass = tempWindow.getClass()) != nextWindowClass) continue;
                            ((PirkaWindow)nextWindow).setReturnWindow(tempWindow.getReturnWindow());
                            hitFlag = true;
                            break;
                        } while ((tempWindow = tempWindow.getReturnWindow()) != null);
                        if (!hitFlag) {
                            ((PirkaWindow)nextWindow).setReturnWindow(oldWindow);
                        }
                    }
                }
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(((PirkaWindow)nextWindow).getFieldMap());
            ((PirkaWindow)nextWindow).fixField();
            String newSerialNo = this.createSerialNo((PirkaWindow)nextWindow);
            this.setSerialNoToSession(session, instanceNo, newSerialNo);
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo(instanceNo);
            ((PirkaWindow)nextWindow).setWindowBaseData(windowBaseData);
            this.setWindowObjectToSession(session, instanceNo, (PirkaWindow)nextWindow);
        }
        return nextWindow;
    }

    @Deprecated
    protected PirkaRespons serviceMainOldServletProc(boolean newSessionFlag, HttpSession session, HttpServletRequest req, HttpServletResponse res, Map<String, String[]> reqMap, List<Long> uploadFileList) throws ServletException, IOException {
        String instanceNo;
        PirkaRespons nextWindow;
        block31: {
            boolean ieFlag;
            boolean actionMethodNoCallFlag;
            block36: {
                String className;
                String reqSerialNo;
                block35: {
                    String sessionSerialNo;
                    block34: {
                        block33: {
                            boolean initWindowFlag;
                            boolean existsSessionInitWindowFlag;
                            block32: {
                                block29: {
                                    block30: {
                                        nextWindow = null;
                                        instanceNo = "";
                                        actionMethodNoCallFlag = false;
                                        existsSessionInitWindowFlag = false;
                                        ieFlag = false;
                                        String userAgent = req.getHeader("User-Agent");
                                        if (userAgent.indexOf("MSIE") != -1) {
                                            ieFlag = true;
                                        }
                                        initWindowFlag = false;
                                        if (!newSessionFlag) break block29;
                                        if (!reqMap.containsKey("__PIRKA__")) break block30;
                                        nextWindow = this.getSessionTimeoutWindow();
                                        this.setErrorFlag(session, true);
                                        break block31;
                                    }
                                    initWindowFlag = true;
                                    break block32;
                                }
                                if (this.isErrorFlag(session)) {
                                    initWindowFlag = true;
                                } else if (!reqMap.containsKey("__PIRKA__")) {
                                    initWindowFlag = true;
                                    existsSessionInitWindowFlag = true;
                                }
                            }
                            instanceNo = this.getSingleReqParam(reqMap, REQ_INSTANCE);
                            if (!initWindowFlag) break block33;
                            if (instanceNo == null || instanceNo.length() <= 0) {
                                if (this.isClearSessionAtInitScreen() && !existsSessionInitWindowFlag) {
                                    session.invalidate();
                                    session = req.getSession(true);
                                }
                                PirkaThreadMap.setServletPartam(req, res, session);
                                instanceNo = "";
                                this.setErrorFlag(session, false);
                                if (existsSessionInitWindowFlag && this.getInitWindowFromSession(session) != null) {
                                    nextWindow = this.getInitWindowFromSession(session);
                                } else {
                                    nextWindow = this.getInitWindow(reqMap);
                                    this.setInitWindowFromSession(session, nextWindow);
                                }
                            } else {
                                nextWindow = this.getSubWindow(reqMap);
                            }
                            break block31;
                        }
                        sessionSerialNo = this.getSerialNoFromSession(session, instanceNo);
                        reqSerialNo = this.getSingleReqParam(reqMap, REQ_SERIALNO);
                        if (reqSerialNo != null) break block34;
                        nextWindow = this.getSessionTimeoutWindow();
                        this.setErrorFlag(session, true);
                        break block31;
                    }
                    if (sessionSerialNo == null || !sessionSerialNo.equals(reqSerialNo)) break block35;
                    nextWindow = this.getWindowObjectFromSession(session, instanceNo);
                    if (nextWindow == null) {
                        throw new RuntimeException("\u30bb\u30b7\u30e7\u30f3\u5185\u306b\u524d\u56de\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                    }
                    className = this.getClassNameFromSerialNo(reqSerialNo);
                    if (className == null || !className.equals(nextWindow.getClass().getName())) {
                        throw new RuntimeException("\u30bb\u30c3\u30b7\u30e7\u30f3\u5185\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3068\u30ea\u30af\u30a8\u30b9\u30c8\u30a6\u30a3\u30f3\u30c9\u30a6\u304c\u9055\u3044\u307e\u3059 \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u756a\u53f7=" + instanceNo);
                    }
                    break block36;
                }
                className = this.getClassNameFromSerialNo(reqSerialNo);
                nextWindow = this.cleateWindowObject(className);
                if (nextWindow == null) {
                    throw new RuntimeException("\u30a6\u30a3\u30f3\u30c9\u30a6\u30af\u30e9\u30b9\u304c\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 " + className);
                }
                if (ieFlag) break block31;
            }
            this.clearErrorFlag(((PirkaWindow)nextWindow).getRootFieldMap());
            ((PirkaWindow)nextWindow).getErrorMessageStocker().clear();
            String actionName = this.getActionName((PirkaWindow)nextWindow, reqMap);
            FieldItem actionFieldItem = null;
            if (actionName != null) {
                actionFieldItem = ((PirkaWindow)nextWindow).getRootFieldItem(actionName);
            }
            if (actionFieldItem != null) {
                this.setActionLoopIndex((PirkaWindow)nextWindow, actionName, actionFieldItem.getLoopDeepLevel());
            } else {
                ((PirkaWindow)nextWindow).setActionLoopIndex(new int[0]);
            }
            String mark = this.getSingleReqParam(reqMap, "__PIRKA__");
            PirkaWindow oldWindow = (PirkaWindow)nextWindow;
            if (REQ_FORM.equals(mark)) {
                this.getReqValue(((PirkaWindow)nextWindow).getFieldMap(), reqMap);
                nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
                if (actionFieldItem != null && actionFieldItem.getCtrl().isAutoCheck()) {
                    try {
                        ((PirkaWindow)nextWindow).check();
                    }
                    catch (AutoCheckRuntimeException e) {
                        actionMethodNoCallFlag = true;
                    }
                }
            } else {
                nextWindow = this.callAction((PirkaWindow)nextWindow, "onPre");
            }
            if (!actionMethodNoCallFlag && nextWindow == oldWindow) {
                try {
                    nextWindow = actionFieldItem != null ? this.callEventAction((PirkaWindow)nextWindow, actionName) : this.callAction((PirkaWindow)nextWindow, "onElse");
                }
                catch (AutoCheckRuntimeException autoCheckRuntimeException) {
                    // empty catch block
                }
            }
            if (nextWindow != oldWindow) {
                if (nextWindow == null) {
                    nextWindow = oldWindow;
                } else if (!(nextWindow instanceof PirkaFileDownloader) && ieFlag) {
                    this.sendRedirect(req, res, (PirkaWindow)nextWindow, instanceNo);
                    return null;
                }
            }
        }
        if (nextWindow instanceof PirkaWindow) {
            this.callAction((PirkaWindow)nextWindow, "preDraw");
            this.changeLabelErrorFlag(((PirkaWindow)nextWindow).getFieldMap());
            ((PirkaWindow)nextWindow).fixField();
            String newSerialNo = this.createSerialNo((PirkaWindow)nextWindow);
            this.setSerialNoToSession(session, instanceNo, newSerialNo);
            WindowBaseData windowBaseData = new WindowBaseData();
            windowBaseData.setSerialNo(newSerialNo);
            windowBaseData.setInstanceNo(instanceNo);
            ((PirkaWindow)nextWindow).setWindowBaseData(windowBaseData);
            this.setWindowObjectToSession(session, instanceNo, (PirkaWindow)nextWindow);
        }
        return nextWindow;
    }

    private boolean isErrorFlag(HttpSession session) {
        Boolean ret = (Boolean)session.getAttribute(SESSION_ERROR_FLAG);
        if (ret == null) {
            return false;
        }
        return ret;
    }

    private void setErrorFlag(HttpSession session, boolean errorFlag) {
        session.setAttribute(SESSION_ERROR_FLAG, (Object)errorFlag);
    }

    private void sendRedirect(HttpServletRequest req, HttpServletResponse res, PirkaWindow nextWindow, String instanceNo) throws IOException {
        String newSerialNo = this.createSerialNo(nextWindow);
        StringBuilder sb = new StringBuilder();
        sb.append(req.getRequestURL());
        sb.append('?');
        sb.append("__PIRKA__");
        sb.append('=');
        sb.append('&');
        sb.append(REQ_INSTANCE);
        sb.append('=');
        sb.append(instanceNo);
        sb.append('&');
        sb.append(REQ_SERIALNO);
        sb.append('=');
        sb.append(newSerialNo);
        res.sendRedirect(sb.toString());
    }

    private void clearErrorFlag(Map<String, FieldItem> rootFieldMap) {
        for (String fieldName : rootFieldMap.keySet()) {
            rootFieldMap.get(fieldName).setErrorFlag(false);
        }
    }

    private void setActionLoopIndex(PirkaWindow window, String actionName, int loopDeepLevel) {
        int[] index = null;
        if (loopDeepLevel == 0) {
            index = new int[]{};
        } else {
            String[] deeps = actionName.split("\\$");
            index = new int[loopDeepLevel];
            int i = 0;
            while (i < index.length) {
                int ix = i + 1;
                if (ix <= deeps.length) {
                    try {
                        index[i] = Integer.parseInt(deeps[ix]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    index[i] = 0;
                }
                ++i;
            }
        }
        window.setActionLoopIndex(index);
    }

    private String getActionName(PirkaWindow window, Map<String, String[]> reqMap) {
        for (String name : reqMap.keySet()) {
            CtrlProcesser ctrlProcesser;
            HtmlCtrlParts ctrlParts;
            FieldItem fieldItem;
            int index = name.indexOf(46);
            if (index >= 0) {
                name = name.substring(0, index);
            }
            if ((fieldItem = window.getRootFieldItem(name)) == null || (ctrlParts = fieldItem.getCtrl()) == null || (ctrlProcesser = ctrlParts.getCtrlProcesser()) == null || !ctrlProcesser.isActionCtrl()) continue;
            return name;
        }
        String[] aSubmitName = reqMap.get(REQ_A_SUBMIT);
        if (aSubmitName != null && aSubmitName.length >= 1 && aSubmitName[0] != null && aSubmitName[0].length() > 0) {
            return aSubmitName[0];
        }
        return null;
    }

    private PirkaRespons callEventAction(PirkaWindow window, String name) {
        CtrlProcesser ctrlProcesser;
        HtmlCtrlParts ctrlParts;
        FieldItem fieldItem = window.getRootFieldItem(name);
        if (fieldItem != null && (ctrlParts = fieldItem.getCtrl()) != null && (ctrlProcesser = ctrlParts.getCtrlProcesser()) != null && ctrlProcesser.isActionCtrl()) {
            Method method = PirkaInfoPool.getMethod(window, ctrlParts.getBaseName());
            if (method == null) {
                return window;
            }
            try {
                if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                    method.invoke((Object)window, new Object[0]);
                    return window;
                }
                return (PirkaRespons)method.invoke((Object)window, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof AutoCheckRuntimeException) {
                    throw (AutoCheckRuntimeException)e.getCause();
                }
                throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
            }
        }
        return window;
    }

    private PirkaRespons callAction(PirkaWindow window, String name) {
        Method method = PirkaInfoPool.getMethod(window, name);
        if (method == null) {
            return window;
        }
        try {
            if (method.getReturnType() == null || method.getReturnType() == Void.TYPE) {
                method.invoke((Object)window, new Object[0]);
                return window;
            }
            return (PirkaRespons)method.invoke((Object)window, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof AutoCheckRuntimeException) {
                throw (AutoCheckRuntimeException)e.getCause();
            }
            throw new RuntimeException("\u30a2\u30af\u30b7\u30e7\u30f3\u30e1\u30bd\u30c3\u30c9\u306e\u547c\u3073\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + name, e);
        }
    }

    private void getReqValue(FieldMap fieldMap, Map<String, String[]> reqMap) {
        this.getReqValueMain(fieldMap, reqMap, "");
    }

    private void getReqValueMain(FieldMap fieldMap, Map<String, String[]> reqMap, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object loop;
            String fieldName = stringArray[n2];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            if (fieldItem.getCtrl().getCtrlProcesser().isInputCtrl()) {
                String reqFieldName = null;
                reqFieldName = fieldItem.getCtrl().getCtrlProcesser().isGroupItem() ? String.valueOf(fieldItem.getCtrl().getBaseName()) + this.changeSuffix(suffix, fieldItem.getCtrl().getGroupLevel()) : String.valueOf(fieldItem.getCtrl().getBaseName()) + suffix + fieldItem.getCtrl().getSuffixName();
                String[] values = reqMap.get(reqFieldName);
                fieldItem.getCtrl().getCtrlProcesser().setReq(reqMap, reqFieldName, fieldItem, values);
            } else if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && (loop = fieldItem.getValue()) != null && loop instanceof List) {
                List list = (List)loop;
                int index = 0;
                while (index < list.size()) {
                    this.getReqValueMain((FieldMap)list.get(index), reqMap, String.valueOf(suffix) + '$' + index);
                    ++index;
                }
            }
            ++n2;
        }
    }

    private String changeSuffix(String suffix, int groupLevel) {
        if (groupLevel <= 0) {
            return suffix;
        }
        int index = suffix.length();
        int i = 0;
        while (i < groupLevel) {
            if ((index = suffix.lastIndexOf(36, index - 1)) <= 0) {
                return "";
            }
            ++i;
        }
        return suffix.substring(0, index);
    }

    private PirkaWindow getWindowObjectFromSession(HttpSession session, String InstanceNo) {
        return (PirkaWindow)session.getAttribute(SESSION_INSTANCE + InstanceNo);
    }

    private void setWindowObjectToSession(HttpSession session, String InstanceNo, PirkaWindow windowObject) {
        session.setAttribute(SESSION_INSTANCE + InstanceNo, (Object)windowObject);
    }

    private String getSingleReqParam(Map<String, String[]> map, String key) {
        String[] strings = map.get(key);
        if (strings == null || strings.length <= 0) {
            return null;
        }
        return strings[0];
    }

    private String createSerialNo(PirkaWindow windowObject) {
        return Tools.encodePsw(String.valueOf(windowObject.getClass().getName()) + "$" + System.currentTimeMillis());
    }

    private String getClassNameFromSerialNo(String serialNo) {
        if (serialNo == null) {
            return null;
        }
        String decodeSerialNo = Tools.decodePsw(serialNo);
        int index = decodeSerialNo.indexOf(36);
        if (index <= 0) {
            return null;
        }
        return decodeSerialNo.substring(0, index);
    }

    private void setSerialNoToSession(HttpSession session, String instanceNo, String serialNo) {
        HashMap<String, String> instanceMap = (HashMap<String, String>)session.getAttribute(SESSION_SERIALNO);
        if (instanceMap == null) {
            instanceMap = new HashMap<String, String>();
            session.setAttribute(SESSION_SERIALNO, instanceMap);
        }
        instanceMap.put(instanceNo, serialNo);
    }

    private String getSerialNoFromSession(HttpSession session, String instanceNo) {
        Map instanceMap = (Map)session.getAttribute(SESSION_SERIALNO);
        if (instanceMap == null) {
            return null;
        }
        return (String)instanceMap.get(instanceNo);
    }

    private void setInitWindowFromSession(HttpSession session, PirkaRespons initWindow) {
        session.setAttribute(SESSION_INIT_WINDOW, (Object)initWindow);
    }

    private PirkaRespons getInitWindowFromSession(HttpSession session) {
        return (PirkaRespons)session.getAttribute(SESSION_INIT_WINDOW);
    }

    private PirkaWindow cleateWindowObject(String className) {
        PirkaWindow windowObject = null;
        try {
            Class<?> classObject = Class.forName(className);
            Object newObject = classObject.newInstance();
            if (newObject instanceof PirkaWindow) {
                windowObject = (PirkaWindow)newObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return windowObject;
    }

    private void changeLabelErrorFlag(FieldMap fieldMap) {
        this.changeLabelErrorFlagMain(fieldMap, fieldMap, "");
    }

    private void changeLabelErrorFlagMain(FieldMap baseFieldMap, FieldMap fieldMap, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = fieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            FieldItem fieldItem = fieldMap.getFieldItem(fieldName);
            String forId = fieldItem.getCtrl().getOptionMap().get("for");
            if (forId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    forId = String.valueOf(forId) + suffix;
                }
                boolean errorFlag = this.isErrorId(baseFieldMap, forId);
                fieldItem.setErrorFlag(errorFlag);
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    this.changeLabelErrorFlagMain(baseFieldMap, childMap, String.valueOf(suffix) + '$' + index);
                    ++index;
                }
            }
            ++n2;
        }
    }

    private boolean isErrorId(FieldMap baseFieldMap, String id) {
        return this.isErrorIdMain(baseFieldMap, id, "");
    }

    private boolean isErrorIdMain(FieldMap baseFieldMap, String id, String suffix) {
        String[] fieldNames;
        String[] stringArray = fieldNames = baseFieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            FieldItem fieldItem = baseFieldMap.getFieldItem(fieldName);
            String targetId = fieldItem.getCtrl().getOptionMap().get("id");
            if (targetId != null) {
                if (fieldItem.getCtrl().isSuffix()) {
                    targetId = String.valueOf(targetId) + suffix;
                }
                if (id.equals(targetId) && fieldItem.isErrorFlag()) {
                    return true;
                }
            }
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop() && fieldItem.getValue() != null && fieldItem.getValue() instanceof List) {
                List list = (List)fieldItem.getValue();
                int index = 0;
                for (FieldMap childMap : list) {
                    if (this.isErrorIdMain(childMap, id, String.valueOf(suffix) + '$' + index)) {
                        return true;
                    }
                    ++index;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void putSession(String keyName, Object object) {
        HttpSession session = PirkaThreadMap.getSession();
        if (session != null) {
            session.putValue(keyName, object);
        }
    }

    @Override
    public Object getSession(String keyName) {
        HttpSession session = PirkaThreadMap.getSession();
        if (session == null) {
            return null;
        }
        return session.getAttribute(keyName);
    }

    protected HttpServletRequest getHttpServletRequest() {
        return PirkaThreadMap.getServletReq();
    }

    protected HttpServletResponse getHttpServletResponse() {
        return PirkaThreadMap.getServletRes();
    }

    @Override
    public String getUrlAlias() {
        HttpServletRequest req = this.getHttpServletRequest();
        if (req != null) {
            return req.getRequestURI();
        }
        return this.getClass().getName();
    }

    protected abstract PirkaWindow getInitWindow(Map<String, String[]> var1);

    protected PirkaWindow getSubWindow(Map<String, String[]> reqMap) {
        return null;
    }

    protected PirkaWindow getSessionTimeoutWindow() {
        return new SessionTimeoutDefaultWindow();
    }

    protected PirkaWindow getFatalErrorWindow() {
        return new FatalErrorDefaultWindow();
    }

    @Override
    public boolean isOldServletMode() {
        return false;
    }

    @Override
    public Map<String, CtrlProcesser> getCtrlProcesserMap() {
        return null;
    }

    @Override
    public Class getPirkaMessageEnumClass() {
        return null;
    }

    @Override
    public String getResourceHtmlFileCharset() {
        return "MS932";
    }

    @Override
    public String getHtmlStringCharset() {
        return "MS932";
    }

    @Override
    public String getResponsHeaderCharset() {
        return "Shift-jis";
    }

    @Override
    public ReqCharacterConverter getReqCharacterConverter() {
        return DefaultReqCharacterConverter.getInstance();
    }

    @Override
    public StringConverter getInputStringConverter() {
        return DefaultStringConverter.getInstance();
    }

    @Override
    public StringConverter getOutputStringConverter() {
        return DefaultStringConverter.getInstance();
    }

    @Override
    public boolean isClearSessionAtInitScreen() {
        return true;
    }

    @Override
    public TempFileManager getTempFileManager() {
        return DefaultTempFileManager.getInstance();
    }

    @Override
    public PirkaStandardMessageManagerIF getStandardMessageManager() {
        return null;
    }
}

