/*
 * Decompiled with CFR 0.152.
 */
package jp.oarts.pirka.core.win;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.oarts.pirka.core.analyzer.html.HtmlLoopFieldMapAnalyzer;
import jp.oarts.pirka.core.app.EntryPointIF;
import jp.oarts.pirka.core.err.DefaultErrorMessageManager;
import jp.oarts.pirka.core.err.ErrorMessageManagerIF;
import jp.oarts.pirka.core.err.ErrorMessageStocker;
import jp.oarts.pirka.core.general.WindowBaseData;
import jp.oarts.pirka.core.kernel.FieldMap;
import jp.oarts.pirka.core.kernel.PirkaInfoPool;
import jp.oarts.pirka.core.kernel.PirkaMakeHtml;
import jp.oarts.pirka.core.kernel.PirkaThreadMap;
import jp.oarts.pirka.core.res.PirkaRespons;
import jp.oarts.pirka.core.util.check.AutoCheck;
import jp.oarts.pirka.core.util.check.AutoCheckRuntimeException;
import jp.oarts.pirka.core.util.check.CheckAndTeller;
import jp.oarts.pirka.core.util.check.Checker;
import jp.oarts.pirka.core.util.check.CheckerStocker;
import jp.oarts.pirka.core.util.check.PirkaMessage;
import jp.oarts.pirka.core.util.check.message.PirkaStandardMessageManagerIF;
import jp.oarts.pirka.core.util.converter.BeanConverter;
import jp.oarts.pirka.core.util.converter.Converter;
import jp.oarts.pirka.core.util.converter.DtoConverter;
import jp.oarts.pirka.core.util.field.FieldItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PirkaWindow
extends PirkaRespons {
    private FieldMap stratumFieldMap;
    private Map<String, FieldItem> rootFieldMap;
    private Map<String, FieldMap> loopFieldMap;
    private Map<String, FieldItem> defaultFieldMap;
    private Map<String, String> groupFieldMap;
    private CheckerStocker checkerStocker;
    private ErrorMessageManagerIF errorMessageManager;
    private ErrorMessageStocker errorMessageStocker;
    private int autoCheckErrorCount;
    private WindowBaseData windowBaseData;
    private PirkaWindow returnWindow;
    private int[] actionLoopIndex;
    private String htmlFileName;

    protected PirkaWindow() {
        this(null);
    }

    protected PirkaWindow(String htmlFileName) {
        String[] fieldNames;
        if (htmlFileName == null) {
            htmlFileName = this.getDefaultHtmlFileName();
        }
        this.htmlFileName = htmlFileName;
        FieldMap fieldMap = PirkaInfoPool.getFieldMap(htmlFileName);
        if (fieldMap == null) {
            throw new RuntimeException("HTML\u30d5\u30a1\u30a4\u30eb\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + htmlFileName);
        }
        this.stratumFieldMap = (FieldMap)fieldMap.clone();
        String[] stringArray = fieldNames = this.stratumFieldMap.getFieldNames();
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            FieldItem fieldItem = this.stratumFieldMap.getFieldItem(fieldName);
            if (fieldItem.getCtrl().getCtrlProcesser().isLoop()) {
                fieldItem.setValue(new ArrayList());
            }
            ++n2;
        }
        this.rootFieldMap = this.stratumFieldMap.getRootMap();
        this.loopFieldMap = new HashMap<String, FieldMap>();
        this.defaultFieldMap = new HashMap<String, FieldItem>();
        this.groupFieldMap = new HashMap<String, String>();
        HtmlLoopFieldMapAnalyzer.getLoopFieldMap((FieldMap)fieldMap.clone(), this.loopFieldMap, this.defaultFieldMap, this.groupFieldMap);
        this.checkerStocker = new CheckerStocker();
        this.errorMessageStocker = new ErrorMessageStocker();
        this.autoCheckErrorCount = 0;
        this.returnWindow = null;
        this.errorMessageManager = DefaultErrorMessageManager.MANAGER;
        this.actionLoopIndex = new int[0];
    }

    public FieldMap getFieldMap() {
        return this.stratumFieldMap;
    }

    public FieldMap createLoopFieldMap(String loopFieldName) {
        return (FieldMap)this.loopFieldMap.get(loopFieldName).cloneLoop();
    }

    public FieldMap getDefaultLoopFieldMap(String loopFieldName) {
        return this.loopFieldMap.get(loopFieldName);
    }

    public Map<String, Object> getDto(Converter ... converters) {
        return DtoConverter.getDto(this.stratumFieldMap, converters);
    }

    public Map<String, Object> getDto(boolean inputCtrlOnly, Converter ... converters) {
        return DtoConverter.getDto(this.stratumFieldMap, inputCtrlOnly, converters);
    }

    public void setDto(Map<String, Object> dto, Converter ... converters) {
        DtoConverter.setDto(this, dto, this.stratumFieldMap, converters);
    }

    public void setDto(Map<String, Object> dto, boolean inputCtrlOnly, Converter ... converters) {
        DtoConverter.setDto(this, dto, this.stratumFieldMap, inputCtrlOnly, converters);
    }

    public void getBean(Object beanObject, Converter ... converters) {
        BeanConverter.getBean(beanObject, this.stratumFieldMap, converters);
    }

    public void getBean(Object beanObject, boolean inputCtrlOnly, Converter ... converters) {
        BeanConverter.getBean(beanObject, this.stratumFieldMap, inputCtrlOnly, converters);
    }

    public List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        return BeanConverter.getBeanList(beanClass, fieldMap, loopFieldName, converters);
    }

    public List getBeanList(Class beanClass, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        return BeanConverter.getBeanList(beanClass, fieldMap, loopFieldName, inputCtrlOnly, converters);
    }

    public void getBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        BeanConverter.getBeanList(list, fieldMap, loopFieldName, converters);
    }

    public void getBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        BeanConverter.getBeanList(list, fieldMap, loopFieldName, inputCtrlOnly, converters);
    }

    public void setBean(Object beanObject, Converter ... converters) {
        BeanConverter.setBean(this, beanObject, this.stratumFieldMap, converters);
    }

    public void setBean(Object beanObject, boolean inputCtrlOnly, Converter ... converters) {
        BeanConverter.setBean(this, beanObject, this.stratumFieldMap, inputCtrlOnly, converters);
    }

    public void setBeanList(List list, FieldMap fieldMap, String loopFieldName, Converter ... converters) {
        BeanConverter.setBeanList(this, list, fieldMap, loopFieldName, converters);
    }

    public void setBeanList(List list, FieldMap fieldMap, String loopFieldName, boolean inputCtrlOnly, Converter ... converters) {
        BeanConverter.setBeanList(this, list, fieldMap, loopFieldName, inputCtrlOnly, converters);
    }

    public int[] getActionLoopIndex() {
        return this.actionLoopIndex;
    }

    @Deprecated
    public void setActionLoopIndex(int[] actionLoopIndex) {
        this.actionLoopIndex = actionLoopIndex;
    }

    protected void addCheck(String fieldName, Checker ... checker) {
        this.isCheckField(fieldName);
        this.checkerStocker.addCheck(fieldName, checker);
    }

    protected void addCheck(String fieldName, String message, Checker ... checker) {
        this.isCheckField(fieldName);
        this.checkerStocker.addCheck(fieldName, message, checker);
    }

    protected void addCheck(String fieldName, PirkaMessage message, Checker ... checker) {
        this.isCheckField(fieldName);
        this.checkerStocker.addCheck(fieldName, message, checker);
    }

    protected void addCheck(CheckAndTeller ... checckAndTeller) {
        this.checkerStocker.addCheck(checckAndTeller);
    }

    protected void addErrorCheckBreak() {
        this.checkerStocker.addErrorChaeckBreak();
    }

    protected void addErrorCheckReturner() {
        this.checkerStocker.addErrorChaeckReturner();
    }

    protected void clearCheck() {
        this.checkerStocker.clearCheck();
    }

    private void isCheckField(String fieldName) {
        FieldItem fieldItem = this.defaultFieldMap.get(fieldName);
        if (fieldItem == null) {
            throw new RuntimeException("\u7121\u52b9\u306a\u30d5\u30a3\u30fc\u30eb\u30c9\u540d\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f " + fieldName);
        }
    }

    @Deprecated
    public CheckerStocker getCheckerStocker() {
        return this.checkerStocker;
    }

    public boolean check() throws AutoCheckRuntimeException {
        this.autoCheckErrorCount = 0;
        AutoCheck autoCheck = new AutoCheck();
        this.autoCheckErrorCount = autoCheck.runCheck(this.checkerStocker, this.rootFieldMap, this.stratumFieldMap, this.errorMessageStocker, this.getStandardMessageManager());
        if (autoCheck.isReturn()) {
            throw new AutoCheckRuntimeException();
        }
        return this.autoCheckErrorCount == 0;
    }

    protected int getAutoCheckErrorCount() {
        return this.autoCheckErrorCount;
    }

    public PirkaStandardMessageManagerIF getStandardMessageManager() {
        return null;
    }

    public void setErrorMessageManager(ErrorMessageManagerIF errorMessageManager) {
        this.errorMessageManager = errorMessageManager;
    }

    protected void addError(String message) {
        this.errorMessageStocker.addError(message);
    }

    protected void addError(PirkaMessage message) {
        this.errorMessageStocker.addError(message);
    }

    protected void addError(String fieldName, String message) {
        this.errorMessageStocker.addError(fieldName, message);
    }

    protected void addError(String fieldName, PirkaMessage message) {
        this.errorMessageStocker.addError(fieldName, message);
    }

    protected void putSession(String keyName, Object object) {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        entryPoint.putSession(keyName, object);
    }

    protected Object getSession(String keyName) {
        EntryPointIF entryPoint = PirkaThreadMap.getEntryPointObjct();
        return entryPoint.getSession(keyName);
    }

    protected HttpServletRequest getHttpServletRequest() {
        return PirkaThreadMap.getServletReq();
    }

    @Deprecated
    protected HttpServletResponse getHttpServletResponse() {
        return PirkaThreadMap.getServletRes();
    }

    @Deprecated
    public void setWindowBaseData(WindowBaseData windowBaseData) {
        this.windowBaseData = windowBaseData;
    }

    @Deprecated
    public WindowBaseData getWindowBaseData() {
        return this.windowBaseData;
    }

    @Override
    @Deprecated
    public void writeRespons(OutputStream os) throws IOException {
        String html = PirkaMakeHtml.makeHtml(this, this.errorMessageManager, this.errorMessageStocker);
        os.write(html.getBytes(PirkaThreadMap.getEntryPointObjct().getHtmlStringCharset()));
    }

    @Override
    @Deprecated
    public void remakeHeader(HttpServletResponse res) {
        res.setContentType("text/html; charset=" + PirkaThreadMap.getEntryPointObjct().getResponsHeaderCharset());
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
    }

    @Deprecated
    public void fixField() {
        this.rootFieldMap = this.stratumFieldMap.getRootMap();
    }

    @Deprecated
    public Map<String, FieldItem> getRootFieldMap() {
        return this.rootFieldMap;
    }

    @Deprecated
    public FieldItem getRootFieldItem(String fieldName) {
        return this.rootFieldMap.get(fieldName);
    }

    @Deprecated
    public void setReturnWindow(PirkaWindow returnWindow) {
        this.returnWindow = returnWindow;
    }

    @Deprecated
    public PirkaWindow getReturnWindow() {
        return this.returnWindow;
    }

    @Deprecated
    public ErrorMessageStocker getErrorMessageStocker() {
        return this.errorMessageStocker;
    }

    private String getDefaultHtmlFileName() {
        return "/" + this.getClass().getName().replace('.', '/') + ".html";
    }

    @Deprecated
    public String getHtmlFileName() {
        return this.htmlFileName;
    }
}

