package jp.oarts.pirka.sample;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

import jp.oarts.pirka.core.kernel.TempFileManager;

public class MemTempFileManager implements TempFileManager {

	private static final MemTempFileManager obj = new MemTempFileManager();

	private HashMap<Long, byte[]> tempMap;

	private MemTempFileManager() {
		tempMap = new HashMap<Long, byte[]>();
	}

	public static MemTempFileManager getInstance() {
		return obj;
	}

	public OutputStream getOutputStream(long fileId) throws IOException {
		return new MemOutputStream(fileId);
	}

	public InputStream getInputStream(long fileId) throws IOException {
		synchronized (tempMap) {
			return new ByteArrayInputStream(tempMap.get(fileId));
		}
	}

	public void delete(long fileId) throws IOException {
		synchronized (tempMap) {
			tempMap.remove(fileId);
		}
	}

	public class MemOutputStream extends ByteArrayOutputStream {
		long fileId;

		public MemOutputStream(long fileId) {
			this.fileId = fileId;
		}

		public void close() throws IOException {
			super.close();
			synchronized (tempMap) {
				tempMap.put(fileId, toByteArray());
			}
		}
	}
}
