/*
 * Copyright (C) 2002-2003 chik, s.hiranaka
 * For license terms, see the file COPYING in this directory.
 */

// AttachedFileView.cpp :
//

#include "stdafx.h"
#include "Pochy.h"
#include "AttachedFileView.h"
#include "mainfrm.h"
#include "CodeConvert.h"
#include "base64.h"
#include "quoted-printable.h"
#include "lib.h"
#include "sendmail.h"
#include "direct.h"			// _mkdir

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAttachedFileView

IMPLEMENT_DYNCREATE(CAttachedFileView, CListView)

CAttachedFileView::CAttachedFileView()
{
	m_image.Create(16, 16, ILC_COLORDDB | ILC_MASK, 1, 100);
}

CAttachedFileView::~CAttachedFileView()
{
	m_image.Detach();
}

BEGIN_MESSAGE_MAP(CAttachedFileView, CListView)
	//{{AFX_MSG_MAP(CAttachedFileView)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnRclick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	ON_COMMAND(ID_REMOVE_FILE, OnRemoveFile)
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnItemchanged)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAttachedFileView `

void CAttachedFileView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CAttachedFileView ff

#ifdef _DEBUG
void CAttachedFileView::AssertValid() const
{
	CListView::AssertValid();
}

void CAttachedFileView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAttachedFileView bZ[W nh

void CAttachedFileView::OnInitialUpdate() 
{
	CListView::OnInitialUpdate();
	CPochyApp *app = (CPochyApp *)AfxGetApp();
	CDraftFrame *df = (CDraftFrame*)GetParentFrame();

	DWORD dwStyle;
	CListCtrl& lc = GetListCtrl();

	// -1 means no item is selected
	m_index = -1;

	// change to small style icon.
	dwStyle = GetWindowLong(m_hWnd, GWL_STYLE);
	SetWindowLong(m_hWnd, GWL_STYLE, (dwStyle &~ LVS_TYPEMASK) | LVS_SMALLICON ); // | LVS_SHAREIMAGELISTS);
	lc.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_SUBITEMIMAGES);

	// setting of color.
	COLORREF m_colorEdit;
	// backgroud color.
	m_colorEdit = RGB(
		app->GetProfileInt("EditViewColor", "BkColorR", 0),
		app->GetProfileInt("EditViewColor", "BkColorG", 0),
		app->GetProfileInt("EditViewColor", "BkColorB", 0));
	lc.SetBkColor(m_colorEdit);
	// backgroud color of text.
	m_colorEdit = RGB(
		app->GetProfileInt("EditViewColor", "BkColorR", DEF_BKG_COLOR_R),
		app->GetProfileInt("EditViewColor", "BkColorG", DEF_BKG_COLOR_G),
		app->GetProfileInt("EditViewColor", "BkColorB", DEF_BKG_COLOR_B));
	lc.SetTextBkColor(m_colorEdit);
	// color of text.
	m_colorEdit = RGB(
		app->GetProfileInt("EditViewColor", "TxtColorR", DEF_TXT_COLOR_R),
		app->GetProfileInt("EditViewColor", "TxtColorG", DEF_TXT_COLOR_G),
		app->GetProfileInt("EditViewColor", "TxtColorB", DEF_TXT_COLOR_B));
	lc.SetTextColor(m_colorEdit);

	lc.SetImageList(&m_image, LVSIL_SMALL);

	lc.DeleteAllItems();

	// if mail is resurected from draft and file is attached, need to set attached file
	if(df->m_me.GetMode() != ME_MODE_PGP){
		CString path;
		for(int i=1; i<df->m_me.HowManyPart(); i++){ // i=0 is mail body, so start from i=1.
			if(df->m_me.GetMultipartType(i) == "application/pgp-keys"){
				this->AddPgpKey();
			}else{
				// in order to get icon of file, save file into attached directory at first
				if(!g_is_there(app->m_app_path+"\\attached")) // if no folder for attached, create.
					_mkdir(app->m_app_path+"\\attached");
				path = app->m_app_path+"\\attached\\"+df->m_me.GetMultipartFileName(i);
				FILE* file = fopen(path, "wb");
				CString body = df->m_me.GetMultipartBody(i);
				body.Remove('\r');
				body.Remove('\n');
				char* in = body.GetBuffer(0);
				char* out = new char[body.GetLength()];
				int len = from64tobits(out, in, strlen(in));
				fwrite(out, sizeof(char), len, file);
				fclose(file);
				delete out;
				body.ReleaseBuffer();

				// add item
				this->AddFile(path.GetBuffer(0));
				path.ReleaseBuffer();
			}
		}
	}
}

void CAttachedFileView::OnRclick(NMHDR* pNMHDR, LRESULT* pResult)
{
	POINT pt;
	CListCtrl& listCtrl = GetListCtrl();
	CPochyApp *app = (CPochyApp *)AfxGetApp();

	if(m_index != -1){
		PostMessage(WM_NULL, 0, 0); // this is point

		GetCursorPos(&pt);
		CMenu menu;

		menu.LoadMenu(IDR_MULTIPART_DRAFT_POPUP);
		CMenu *pPopup = menu.GetSubMenu(0);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, (int)pt.x, (int)pt.y, this);
	}	
	*pResult = 0;
}

void CAttachedFileView::ReArrange()
{
	int i,width;
	CPoint p;
	CRect rect;
	CListCtrl& lc = GetListCtrl();
	p.x = 0;
	p.y = 0;
	GetClientRect(rect);
	width = rect.right;
	for(i=0;i<lc.GetItemCount();i++){
		lc.SetItemPosition(i,p);
		lc.GetItemRect(i,rect,LVIR_BOUNDS);
		if(width <= rect.right && i){
			p.x = 0;
			p.y = rect.bottom;
			lc.SetItemPosition(i,p);
			lc.GetItemRect(i,rect,LVIR_BOUNDS);
		}
		p.x = rect.right + 20;
	}
}

void CAttachedFileView::ExecuteFile()
{
	CPochyApp *app = (CPochyApp *)AfxGetApp();

	CListCtrl& listCtrl = GetListCtrl();
	CString file_name;
	CString body;
	CStringArray buf;
	CString	msg_id;

	CDraftFrame *df = (CDraftFrame*)GetParentFrame();
	// open file path with editor that is designated in ini file.
	if(!df->m_me.GetMultipartFileName(m_index+1).IsEmpty()){
		if(!g_is_there(app->m_app_path+"\\attached")) // if no folder for attached, create.
			_mkdir(app->m_app_path+"\\attached");
		FILE* file = fopen(app->m_app_path+"\\attached\\"+df->m_me.GetMultipartFileName(m_index+1), "wb");
		body = df->m_me.GetMultipartBody(m_index+1);
		body.Remove('\r');
		body.Remove('\n');
		char* in = body.GetBuffer(0);
		char* out = new char[body.GetLength()];
		int len = from64tobits(out, in, strlen(in));
		fwrite(out, sizeof(char), len, file);
		fclose(file);
		delete out;
		body.ReleaseBuffer();
	}
	ShellExecute(NULL, "open", app->m_app_path+"\\attached\\"+df->m_me.GetMultipartFileName(m_index+1), NULL, NULL, SW_SHOW);
	return;
}

void CAttachedFileView::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{
	ExecuteFile();
	*pResult = 0;
}

void CAttachedFileView::OnRemoveFile()
{
	CDraftFrame *df = (CDraftFrame*)GetParentFrame();
	CListCtrl& lc = GetListCtrl();

	df->m_me.RemoveMultipart(m_index+1);
	lc.DeleteItem(m_index);

	// if attached file is zero, hide view.
	if(0 == lc.GetItemCount())
		df->HideAttachedFileView(TRUE);
	ReArrange();
}

void CAttachedFileView::OnItemchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	CPochyApp *app = (CPochyApp *)AfxGetApp();

	m_index = pNMListView->iItem; // current selected Item num is saved for later reference.

	*pResult = 0;
}

BOOL CAttachedFileView::PreCreateWindow(CREATESTRUCT& cs) 
{
//	cs.style |= (LVS_NOSCROLL | LVS_SINGLESEL);
	cs.style |= LVS_SINGLESEL;
//	cs.style &= ~(WS_VSCROLL | WS_HSCROLL);

	return CListView::PreCreateWindow(cs);
}

void CAttachedFileView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();
	if(df->Char(nChar,this))
		return;

	CListView::OnChar(nChar, nRepCnt, nFlags);
}

void CAttachedFileView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CDraftFrame* df = (CDraftFrame*)GetParentFrame();
	if(df->KeyDown(nChar,this))
		return;	

	CListView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CAttachedFileView::AddFile(LPSTR file_path)
{
	CString path = file_path;

	CListCtrl &lc = this->GetListCtrl();
	int start = path.ReverseFind('\\')+1;
	CString piece = path.Mid(start);

	WORD icon_index = 0;
	HICON hicon = ExtractAssociatedIcon(AfxGetInstanceHandle(), path.GetBuffer(0), &icon_index);
	if(hicon != NULL){
		this->m_image.Add(hicon);
		lc.InsertItem(lc.GetItemCount(), piece, this->m_image.GetImageCount()-1);
	}else{
		hicon = ExtractAssociatedIcon(AfxGetInstanceHandle(), "", &icon_index);
		this->m_image.Add(hicon);
		lc.InsertItem(lc.GetItemCount(), piece, this->m_image.GetImageCount()-1);
	}
}

void CAttachedFileView::AddPgpKey()
{
	WORD icon_index = 0;
	HICON hicon = ExtractAssociatedIcon(AfxGetInstanceHandle(), "", &icon_index);
	this->m_image.Add(hicon);
	CListCtrl &lc = this->GetListCtrl();
	lc.InsertItem(lc.GetItemCount(), "application/pgp-keys", this->m_image.GetImageCount()-1);
}
