/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.udf;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.hssf.record.formula.udf.UDFFinder;

public final class DefaultUDFFinder
implements UDFFinder {
    private final Map _functionsByName;

    public DefaultUDFFinder(String[] functionNames, FreeRefFunction[] functionImpls) {
        int nFuncs = functionNames.length;
        if (functionImpls.length != nFuncs) {
            throw new IllegalArgumentException("Mismatch in number of function names and implementations");
        }
        HashMap<String, FreeRefFunction> m = new HashMap<String, FreeRefFunction>(nFuncs * 3 / 2);
        int i = 0;
        while (i < functionImpls.length) {
            m.put(functionNames[i], functionImpls[i]);
            ++i;
        }
        this._functionsByName = m;
    }

    public FreeRefFunction findFunction(String name) {
        return (FreeRefFunction)this._functionsByName.get(name);
    }
}

