#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/liboptions.sh for portsreinstall-chroot
# - Command line options -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Database of options which are given at each run and not saved =============
# [Syntax of option databases]
# short_name, long_name, variable, defult_vaule, set_value
# Columns are delimited by tab characters.
options_db_onetime ()
{
	cat << eof
h	help	opt_help_mode	0	1
h	short-help	opt_help_mode	0	1
H	long-help	opt_help_mode	0	2
V	show-version	opt_show_version	no	yes
a	batch-mode	opt_batch_mode	no	yes
E	extra-dirs-delim	opt_extra_dirs_delim	,	:
M	reset-minor-options	opt_reset_minor_options	no	yes
S	no-opening-message	opt_no_opening_message	no	yes
eof
}

# ============= Database of options which are saved and not renewable until the temporary database is cleaned =============
options_db_saved_and_non_renewable ()
{
	cat << eof
b	basedir	opt_basedir	/home/.${APPNAME}	:
c	suppress-clean-obsolete-database	opt_suppress_obsolete_db_clean	no	yes
d	invalidate-mount-privilege	opt_invalidate_mount_privilege	no	yes
e	extra-dirs	opt_extra_dirs	''	:
p	load-pkgtoolsconf-as-default	opt_load_pkgtoolsconf	undef	default
P	load-pkgtoolsconf-as-override	opt_load_pkgtoolsconf	undef	override
Q	ignore-pkgtoolsconf	opt_load_pkgtoolsconf	undef	no
eof
}

# ============= Regularize the option value =============
options_regularize ()
{
	opt_basedir=`misc_global_path "$opt_basedir"`
}
