#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# - "forget" command operation -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Operation of forget command =============
command_forget ()
{
	message_echo "The temporary database is trying to forget about the specified ports as much as possible."
	message_echo "Concretely, the data on each of the specified ports and their requirements/dependents is removed unless initially installed or required by other preserved ports."
	message_echo
	
	# Preparation for inspection of the specified ports
	PROGRAM_DEPENDS=''
	_program_exec_and_record_completion__operation ()
	{
		message_section_title "Preparation for inspection of the specified ports"
		rm -rf "${DBDIR}/forget"
		mkdir "${DBDIR}/forget"
		for list in masters remove_scope
		do
			rm -f "${DBDIR}/stage.loop_list/forget_$list"*
		done
		message_echo
	}
	program_exec_and_record_completion FORGET::PREPARATION_INSPECT_MASTER
	
	# (Re)initialization of the specified ports to inspect
	pkgsys_eval_ports_glob "$@" > ${DBDIR}/stage.loop_list/forget_masters
	
	# Inspection of the specified ports
	PROGRAM_DEPENDS='FORGET::PREPARATION_INSPECT_MASTER'
	_program_exec_restartable_loop_operation__routine ()
	{
		local origin origin_orig
		origin=$1
		if [ -e "${DBDIR}/REVERSE_REPLACE.complete_sed_pattern" ]
		then
			origin_orig=`echo "$origin" \
				| sed -E -f "${DBDIR}/REVERSE_REPLACE.complete_sed_pattern"`
		else
			origin_orig=$origin
		fi
		if [ ! -e "${DBDIR}/initial/$origin/installed_version" \
			-a ! -e "${DBDIR}/initial/$origin_orig/installed_version" \
			-a `cat "${DBDIR}/requires/$origin/dependents.all.full" 2> /dev/null | wc -l` -eq 0 ]
		then
			message_echo "$origin"
			echo "$origin" >> ${DBDIR}/forget/remove.master
			cat "${DBDIR}/requires/$origin/requirements.all.full" \
				2> /dev/null >> ${DBDIR}/forget/remove.scope || :
			database_build_forget "$origin"
		fi
	}
	_program_exec_and_record_completion__operation ()
	{
		message_section_title "Inspection of the specified ports"
		message_echo "----------------"
		program_exec_restartable_loop_operation forget_masters
		message_echo "----------------"
		cat "${DBDIR}/forget/remove.scope" 2> /dev/null \
			| sort -u > ${DBDIR}/forget/remove.scope.tmp
		mv "${DBDIR}/forget/remove.scope.tmp" "${DBDIR}/forget/remove.scope"
		{
			cat "${DBDIR}/forget/remove.master" || :
			cat "${DBDIR}/forget/remove.scope" || :
		} 2> /dev/null | sort -u > ${DBDIR}/forget/remove.scope.filter
		ln -f "${DBDIR}/forget/remove.scope" "${DBDIR}/stage.loop_list/forget_remove_scope"
		message_echo
	}
	program_exec_and_record_completion FORGET::INSPECT_MASTER
	
	# Inspection of the requirements of the specified ports to remove
	PROGRAM_DEPENDS='FORGET::INSPECT_MASTER'
	_program_exec_restartable_loop_operation__routine ()
	{
		local origin origin_orig
		origin=$1
		if [ -e "${DBDIR}/REVERSE_REPLACE.complete_sed_pattern" ]
		then
			origin_orig=`echo "$origin" \
				| sed -E -f "${DBDIR}/REVERSE_REPLACE.complete_sed_pattern"`
		else
			origin_orig=$origin
		fi
		if [ ! -e "${DBDIR}/initial/$origin/installed_version" \
			-a ! -e "${DBDIR}/initial/$origin_orig/installed_version" ] \
			&& ! grep -qv -Fx -f "${DBDIR}/forget/remove.scope.filter" \
				"${DBDIR}/requires/$origin/dependents.all.full" \
				2> /dev/null
		then
			message_echo "$origin"
			database_build_forget "$origin"
			echo "$origin" >> ${DBDIR}/forget/remove
		fi
	}
	_program_exec_and_record_completion__operation ()
	{
		message_section_title "Inspection of the requirements of the specified ports to remove"
		message_echo "----------------"
		program_exec_restartable_loop_operation forget_remove_scope
		message_echo "----------------"
		{
			cat "${DBDIR}/forget/remove.master" || :
			cat "${DBDIR}/forget/remove" || :
		} 2> /dev/null | sort -u > ${DBDIR}/forget/remove.filter
		cat "${DBDIR}/inspected_ports.update" 2> /dev/null | sort -u \
			| grep -v -Fx -f "${DBDIR}/forget/remove.filter" \
				> ${DBDIR}/inspected_ports.update.tmp 2> /dev/null || :
		mv "${DBDIR}/inspected_ports.update.tmp" "${DBDIR}/inspected_ports.update"
		message_echo
	}
	program_exec_and_record_completion FORGET::INSPECT_REQUIREMENTS_OF_REMOVED_PORTS
	
	# Set up so that ports are inspected again in the building process of the temporary database
	program_deregister_stage_complete INSPECT_ALL_DEPENDENCIES
	
	# Clean up the database for this command because it is no more effective
	program_deregister_stage_complete FORGET::PREPARATION_INSPECT_MASTER
	
	# Invalidate the completion
	program_deregister_stage_complete ALL_COMPLETE
}
