#!/bin/sh -e
# ==============================================================================
# portsreinstall library script
# Overlay onto lib/libcommand.sh for portsreinstall-upgrade
# - Operations of commands as well as check of command line arguments -
# Copyright (C) 2018 Mamoru Sakaue, MwGhennndo, All Rights Reserved.
# This software is distributed under the 2-Clause BSD License.
# ==============================================================================

# ============= Check and parse command line arguments =============
command_all_parse_args ()
{
	local num_args_init
	num_args_init=$#
	COMMAND_RESTART="$@"
	COMMAND_MODE=${1:-do}
	shift || :
	case $COMMAND_MODE in
	clean )
		COMMAND_OPERATION=${1:-normal}
		shift || :
		case $COMMAND_OPERATION in
		normal )
			misc_chk_privilege
			;;
		esac
		_command_parse_args__chk_no_arg $#
		;;
	do | options )
		_command_parse_args__chk_no_arg $#
		;;
	*)
		message_echo "ERROR: Invalid command [$COMMAND_MODE]." >&2
		exit 1
		;;
	esac
	COMMAND_SHIFT=$(($num_args_init - $#))
}

# ============= Execute command operations which do not need package tools =============
command_all_exec_without_pkgtools ()
{
	local dbdir_parent 
	case $COMMAND_MODE in
	clean )
		command_exec_without_pkgtools__notify_reset_options
		message_echo "Starting to clean up the temporary database..."
		database_maintain_clean_all
		message_echo "Done"
		exit
		;;
	esac
}

# ============= Execute command operations which are irrespective of option settings =============
command_all_exec_irrespective_of_saved_options ()
{
	case $COMMAND_MODE in
	options )
		options_show_all
		exit
		;;
	esac
}

# ============= Execute command operations as the main process =============
command_all_exec_main ()
{
	case $COMMAND_MODE in
	do )
		command_do_main
		command_do_ending_process
		;;
	esac
}

