package jp.co.powerbeans.common.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class PBComboControlData extends ControlDataBase {

	public PBComboControlData(Control[] control) {
		super(control);
	}

	public void setText(String val) {
		Combo combo = (Combo)getControl()[0];
		combo.setText(val);
	}

	public String getText() {
		Combo combo = (Combo)getControl()[0];
		if ((combo.getStyle() & SWT.READ_ONLY) == 0) {
			// 編集可能な場合は表示テキストをそのまま返す
			return combo.getText();
		} else {
			// 編集不可能な場合
			
			String val = ChkConvSwt.getSelectObjectPK(combo);
			
			if (val == null || val.length() == 0) {
				// 取得できなかった場合はModelではないので表示テキストをそのまま返す
				val = combo.getText();
			}
			return val;
		}
	}

}
