package jp.co.powerbeans.common.swt;

import java.lang.reflect.Method;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;


public class PBComposite extends Composite implements PBCmdDispatch {

	public PBComposite(Composite parent, int style) {
		super(parent, style);
	}

	/**
	 * コマンド対応メソッドを実行
	 * 
	 * @param cmd
	 *            コマンド
	 * @return true 実行, false 未実行
	 */
	public boolean dispatchCmd(String cmd, Object[] args) {
		if (cmd == null || cmd.length() <= 1) {
			return false;
		}
		
		String subname = cmd.substring(0, 1).toUpperCase() + cmd.substring(1);
		try {
			// 実行メソッドの引数を作成
			Class[] types = null;
			if (args != null) {
				types = new Class[args.length];
				for (int i = 0; i < args.length; i++) {
					types[i] = args[i].getClass();
				}
			}
			Method method = this.getClass().getMethod("cmd" + subname, types);
			method.invoke(this, args);
			return true;

		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}
	

	/**
	 * Tableダブルクリック時のコマンドを登録
	 * @param table Table
	 * @param cmd コマンド
	 */
	protected void setCmdToTableOnDoubleClick(Table table, String cmd) {
		table.addMouseListener(new CmdDoubleClickMouseListener(this, cmd));
	}
	/**
	 * Tableダブルクリック時のコマンドを登録
	 * @param table Table
	 * @param cmd コマンド
	 */
	protected void setCmdToTableOnSingleClick(Table table, String cmd) {
		table.addMouseListener(new CmdSingleClickMouseListener(this, cmd));
	}
}
