package jp.co.powerbeans.common.swt;


import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class PBControlUtil {

	
	private PBControlUtil() {
		super();
	}

	public static Table createSimpleTable(Composite composit, String[] cols, int[] wids) {
		ChkConvSwt.assertEquals(cols.length, wids.length);
		// テーブルの作成
		Table table = new Table(composit, SWT.MULTI | SWT.FULL_SELECTION
				| SWT.BORDER);
		GridData tableGrid = new GridData();
		tableGrid.horizontalAlignment = GridData.FILL;
		tableGrid.verticalAlignment = GridData.FILL;
		tableGrid.grabExcessHorizontalSpace = true;
		tableGrid.grabExcessVerticalSpace = true;
		tableGrid.minimumHeight = 200;
		table.setLayoutData(tableGrid);
		// 線を表示する
		table.setLinesVisible(true);
		// ヘッダを可視にする
		table.setHeaderVisible(true);
		// 列のヘッダの設定
		for (int i = 0; i < cols.length; i++) {
			TableColumn col = new TableColumn(table, SWT.LEFT);
			col.setText(cols[i]);
			col.setWidth(wids[i]);
		}

		return table;
	}

	public static Button createSimpleButton(PBComposite composit, String label, String cmd) {
		return createSimpleButton(composit, label, cmd, null);
	}
	public static Button createSimpleButton(PBComposite composit, String label, String cmd, Object[] args) {
		GridData gridData = new GridData();
		Button button = new Button(composit, SWT.NONE);
		button.setText(label);
		button.setLayoutData(gridData);
		gridData.horizontalAlignment = SWT.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.addSelectionListener(new CmdSelectionAdapter(composit, cmd, args));

		return button;
	}

	public static void addRow(Table table, String[] data) {
        TableItem item = new TableItem(table, SWT.NULL);
        item.setText(data);
	}
	public static void insertRowTop(Table table, String[] data) {
		insertRow(table, data, 0);
	}

	public static void insertRow(Table table, String[] data, int index) {
        TableItem item = new TableItem(table, SWT.NULL, index);
        item.setText(data);
	}

	public static Label createLabel(Composite composit, String label, int hstyle, int vstyle, int colspan) {
		org.eclipse.swt.widgets.Label l = new org.eclipse.swt.widgets.Label(
				composit, hstyle);
		GridData gridData = new GridData();
		l.setText(label);

		gridData.horizontalAlignment = hstyle;
		gridData.verticalAlignment = vstyle;
//		gridData.grabExcessHorizontalSpace = true;
    gridData.horizontalSpan = colspan;
//    gridData.widthHint = SWT.DEFAULT;
		l.setLayoutData(gridData);
		return l;
	}
	public static Label createLabel(Composite composit, String label, int hstyle) {
		return createLabel(composit, label, hstyle, SWT.BEGINNING, 1);
	}
  public static Label createLabel(Composite composit, String label, int hstyle, int colspan) {
    return createLabel(composit, label, hstyle, SWT.BEGINNING, colspan);
  }
	
	public static Label createLabel_hvcenter(Composite composit, String label) {
		return createLabel(composit, label, SWT.CENTER, SWT.CENTER);
	}
	public static Label createLabel_left(Composite composit, String label) {
		return createLabel(composit, label, SWT.LEFT);
	}
	public static Label createLabel_right(Composite composit, String label) {
		return createLabel(composit, label, SWT.RIGHT);
	}

	public static void addSeparator(Menu menu) {
		new MenuItem(menu, SWT.SEPARATOR);
	}

	/**
	 * 部品を複数(たて1列)配置できるCompositeを生成
	 * @param 親shell
	 * @return composite
	 */
	public static Composite createNRow1ColComposit(Shell shell) {
		Composite comp = new Composite(shell, SWT.NO_FOCUS);
		comp.setLayout(new GridLayout(1, true));
		GridData compGrid = new GridData();
		compGrid.horizontalAlignment = GridData.FILL;
		compGrid.verticalAlignment = GridData.FILL;
		compGrid.grabExcessHorizontalSpace = true;
		compGrid.grabExcessVerticalSpace = true;
		comp.setLayoutData(compGrid);
		return comp;
	}

	/**
	 * 部品を複数(たて2列)配置できるCompositeを生成
	 * 
	 * @param 親shell
	 * @return composite
	 */
	public static Composite createNRow2ColComposit(Shell shell) {
		Composite comp = new Composite(shell, SWT.NO_FOCUS);
		comp.setLayout(new GridLayout(2, true));
		GridData compGrid = new GridData();
		compGrid.horizontalAlignment = GridData.FILL;
		compGrid.verticalAlignment = GridData.FILL;
		compGrid.grabExcessHorizontalSpace = true;
		compGrid.grabExcessVerticalSpace = true;
		comp.setLayoutData(compGrid);
		return comp;
	}

	/**
	 * shellにテキストボックスを追加
	 * @param shell
	 * @return テキストボックス
	 */
	public static Text addTextBox(Shell shell) {
    return new Text(shell, SWT.NULL);
//		Text text = new Text(shell, SWT.SINGLE | SWT.BORDER);
//		GridData gridData = new GridData(GridData.FILL_BOTH);
////		gridData.horizontalAlignment = GridData.FILL;
////		gridData.verticalAlignment = SWT.BEGINNING;
////		gridData.grabExcessHorizontalSpace = true;
//		text.setLayoutData(gridData);
//
//		return text;
	}

  /**
   * shellにテキストボックスを追加
   * @param shell
   * @return テキストボックス
   */
  public static Text addTextBox(Shell shell, int grid_type) {
    return addTextBox(shell, SWT.NULL, grid_type);
  }
  /**
   * shellにテキストボックスを追加
   * @param shell
   * @return テキストボックス
   */
  public static Text addTextBox(Shell shell, int text_type, int grid_type) {
    return addTextBox(shell, text_type, grid_type, 1);
  }

  /**
   * shellにテキストボックスを追加
   * @param shell
   * @return テキストボックス
   */
  public static Text addTextBox(Shell shell, int text_type, int grid_type, int colspan) {
    int type = (text_type & SWT.MULTI) == 0 ? SWT.SINGLE : SWT.MULTI;
    Text text = new Text(shell, SWT.BORDER | type);
    GridData gridData = new GridData(grid_type);
    gridData.horizontalSpan = colspan;
    text.setLayoutData(gridData);

    return text;
  }
  /**
   * 文字列幅のボタンを追加
   * @param shell
   * @param label ラベル
   * @return Button
   */
  public static Button addSimpleButton(Composite comp, String label) {
    Button button = new Button(comp, SWT.NONE);
    button.setText(label);
    return button;
  }
  
	/**
	 * 文字列幅のボタンを追加
	 * @param shell
	 * @param label ラベル
	 * @return Button
	 */
	public static Button addSimpleButton(Shell shell, String label) {

    Button button = new Button(shell, SWT.NONE);
    button.setText(label);
    return button;

//		GridData gridData = new GridData();
//		Button button = new Button(shell, SWT.NONE);
//		button.setText(label);
//		button.setLayoutData(gridData);
//		gridData.horizontalAlignment = SWT.FILL;
//		gridData.grabExcessHorizontalSpace = true;
//
//		return button;
	}

	/**
	 * ラジオボタンを追加 
	 * @param shell
	 * @param labels
	 * @param vals
	 * @return
	 */
	public static Button[] addRadioButtons(Shell shell, String[] labels, int[] vals) {
		Button[] bnts = new Button[labels.length];
		
		for (int i = 0; i < bnts.length; i++) {
			GridData gridData = new GridData();
			Button button = new Button(shell, SWT.RADIO);
			button.setText(labels[i]);
			button.setLayoutData(gridData);
			gridData.horizontalAlignment = SWT.FILL;
			gridData.grabExcessHorizontalSpace = true;
			button.setData("" + vals[i]);
			bnts[i] = button;
		}
		return bnts;
	}

	/**
	 * @param shell
	 * @param style
	 * @return
	 */
	public static Combo createComboBox(Shell shell, int style, int colspan) {
    Combo combo = new Combo(shell, style | SWT.FILL);
//    Combo combo = new Combo(shell, SWT.BEGINNING | SWT.TOP | style);

//    GridData gridData = new GridData();
//    gridData.horizontalSpan = colspan;
//    gridData.horizontalAlignment = SWT.FILL;
//    gridData.verticalAlignment = SWT.BEGINNING;
//    gridData.grabExcessHorizontalSpace = true;
//    combo.setLayoutData(gridData);
    
    
//    if (colspan == 1) {
//      GridData gridData = new GridData();
//      gridData.horizontalSpan = colspan;
//      combo.setLayoutData(gridData);
//    } else {
//      combo.setLayout(new FillLayout());
//    }
    
//		gridData.heightHint = 30;
//		combo.setLayoutData(gridData);
//		gridData.horizontalAlignment = SWT.FILL;
//		gridData.verticalAlignment = SWT.BEGINNING;
//		gridData.grabExcessHorizontalSpace = true;
//		gridData.grabExcessVerticalSpace = true;
		return combo;
	}

	/**
	 * @param shell
	 * @param style
	 * @param colspan 
	 * @return
	 */
	public static Combo createComboBox(Composite composit, int style, int colspan) {
		return createComboBox(composit.getShell(), style, colspan);
	}
	/**
	 * グリッドレイアウトを指定
	 * @param shell 指定するShell
	 * @param col 列数
	 */
	public static void setGridLayout(Shell shell, int col) {

//    Composite container = new Composite(shell, SWT.NULL);
//    GridLayout layout = new GridLayout(col, true);
//    container.setLayout(layout);

    
		GridLayout layout = new GridLayout(col, true);
		layout.makeColumnsEqualWidth = false;
		shell.setLayout(layout);
	}

	/**
	 * グリッドレイアウトを指定
	 * @param composit 指定するShell
	 * @param col 列数
	 */
	public static void setGridLayout(Composite composit, int col) {
		setGridLayout(composit.getShell(), col);
	}

}
