/**
 * CharsetConv
 * create date 2006/10/02
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.charsetconv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

/**
 * CharsetConverter.
 * コンバーター実行クラス
 * @author amonden
 * @create date 2006/10/02
 */
public class CharsetConverter {

  private CharsetConverter() {
    
  }

  /**
   * @param files
   * @param from_charset
   * @param to_charset
   */
  public static void convert(IFile[] files, String from_charset, String to_charset) {
    
    try {
      // 1. 文字コードチェック
      for (int i = 0; i < files.length; i++) {
        convert(files[i], from_charset, to_charset);
      }
      
      MessageBox msgbox = new MessageBox(Display.getCurrent()
          .getActiveShell());
//    msgbox.setText("");
      msgbox.setMessage(files.length + Msg.getFinishedConvert());
      msgbox.open();
    } catch (Exception e) {
      MessageBox msgbox = new MessageBox(Display.getCurrent()
          .getActiveShell(), SWT.ICON_ERROR);
      msgbox.setMessage(e.getMessage());
      msgbox.open();
    }
  }

  /**
   * @param file
   * @param from_charset
   * @param to_charset
   * @throws Exception 
   */
  private static void convert(IFile file, String from_charset, String to_charset) throws Exception {
    
    BufferedReader fin = null;
    try {
      fin = new BufferedReader(new InputStreamReader(file.getContents(), from_charset));
      StringBuffer buf = new StringBuffer();

      char[] cbuf = new char[1024];
      int size = 0;
      while ((size = fin.read(cbuf)) != -1) {
        buf.append(cbuf, 0, size);
      }

      fin.close();

      // 同じファイルを開いて上書き保存
      BufferedWriter bufw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
          ((Path) file.getLocation()).toFile(), false), to_charset));
      bufw.write(buf.toString());
      bufw.close();

      file.refreshLocal(IResource.DEPTH_ZERO, null);
    } catch (UnsupportedEncodingException e) {
      throw e;
//    } catch (ResourceException e) {
//      throw e;
    } catch (CoreException e) {
      throw e;
    } catch (IOException e) {
      throw e;
    } finally {
      if (fin != null) {
        try {
          fin.close();
        } catch (IOException e) {
          e.printStackTrace();
        }
      }
    }
    
  }

}
