/**
 * PowerDBJ
 * create date 2006/09/21
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export;

import java.io.File;
import java.io.IOException;

import jp.co.powerbeans.eclipse.plugin.powerdbj.wizards.DBInfo;

/**
 * ExportMgr
 * @author amonden
 * @create date 2006/09/21
 */
public class ExportMgr {

  private ExportProgressNotifyListener exportProgressNotifyListener;
  
	/**
   * dbinfoを元に定義をエクスポート
	 * @param dbinfo 定義情報
	 */
	public void export(DBInfo dbinfo) {
    
    // 1. エクスポート
		Exporter exporter = ExporterFactory.getExporter(dbinfo.getExportType());
    exporter.setProgressNotifyListener(exportProgressNotifyListener);
		String output_path = exporter.export(dbinfo.getJdbcConfig(), dbinfo.getSelectTables(), dbinfo.getOutputPath());
		
		// 2. 開く
		try {
			File file = new File(output_path);
			Runtime.getRuntime().exec("explorer " + file.getPath());
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

  /**
   * exportProgressNotifyListener を取得する
   * @return exportProgressNotifyListener
   */
  public ExportProgressNotifyListener getExportProgressNotifyListener() {
    return exportProgressNotifyListener;
  }

  /**
   * exportProgressNotifyListener を設定する
   * @param exportProgressNotifyListener 設定する exportProgressNotifyListener
   */
  public void setExportProgressNotifyListener(
      ExportProgressNotifyListener exportProgressNotifyListener) {
    this.exportProgressNotifyListener = exportProgressNotifyListener;
  }
}
